/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.sqlserver.source.reader.fetch;

import com.ververica.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import com.ververica.cdc.connectors.base.source.meta.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.base.source.meta.split.SnapshotSplit;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import com.ververica.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.errors.ConnectException;
import com.ververica.cdc.connectors.sqlserver.source.offset.LsnOffset;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerStreamFetchTask;
import com.ververica.cdc.connectors.sqlserver.source.utils.SqlServerUtils;
import io.debezium.DebeziumException;
import io.debezium.config.Configuration;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.pipeline.EventDispatcher;
import io.debezium.pipeline.source.AbstractSnapshotChangeEventSource;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.pipeline.spi.ChangeRecordEmitter;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Partition;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.relational.RelationalSnapshotChangeEventSource;
import io.debezium.relational.SnapshotChangeRecordEmitter;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.util.Clock;
import io.debezium.util.ColumnUtils;
import io.debezium.util.Strings;
import io.debezium.util.Threads;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerScanFetchTask
implements FetchTask<SourceSplitBase> {
    private final SnapshotSplit split;
    private volatile boolean taskRunning = false;
    private SqlServerSnapshotSplitReadTask snapshotSplitReadTask;

    public SqlServerScanFetchTask(SnapshotSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        this.taskRunning = true;
        this.snapshotSplitReadTask = new SqlServerSnapshotSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getOffsetContext(), sourceFetchContext.getSnapshotChangeEventSourceMetrics(), sourceFetchContext.getDatabaseSchema(), sourceFetchContext.getConnection(), sourceFetchContext.getDispatcher(), sourceFetchContext.getSnapshotReceiver(), this.split);
        SnapshotSplitChangeEventSourceContext changeEventSourceContext = new SnapshotSplitChangeEventSourceContext();
        SnapshotResult<SqlServerOffsetContext> snapshotResult = this.snapshotSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
        StreamSplit backfillBinlogSplit = this.createBackFillLsnSplit(changeEventSourceContext);
        boolean binlogBackfillRequired = backfillBinlogSplit.getEndingOffset().isAfter(backfillBinlogSplit.getStartingOffset());
        if (!binlogBackfillRequired) {
            this.dispatchLsnEndEvent(backfillBinlogSplit, sourceFetchContext.getPartition().getSourcePartition(), sourceFetchContext.getDispatcher());
            this.taskRunning = false;
            return;
        }
        if (!snapshotResult.isCompletedOrSkipped()) {
            this.taskRunning = false;
            throw new IllegalStateException(String.format("Read snapshot for SqlServer split %s fail", this.split));
        }
        SqlServerOffsetContext.Loader loader = new SqlServerOffsetContext.Loader(sourceFetchContext.getDbzConnectorConfig());
        OffsetContext streamOffsetContext = loader.load((Map)backfillBinlogSplit.getStartingOffset().getOffset());
        SqlServerStreamFetchTask.StreamSplitReadTask backfillBinlogReadTask = this.createBackFillLsnSplitReadTask(backfillBinlogSplit, sourceFetchContext);
        backfillBinlogReadTask.execute((ChangeEventSource.ChangeEventSourceContext)new SnapshotBinlogSplitChangeEventSourceContext(), sourceFetchContext.getPartition(), (SqlServerOffsetContext)streamOffsetContext);
    }

    private StreamSplit createBackFillLsnSplit(SnapshotSplitChangeEventSourceContext sourceContext) {
        return new StreamSplit(this.split.splitId(), sourceContext.getLowWatermark(), sourceContext.getHighWatermark(), new ArrayList<FinishedSnapshotSplitInfo>(), this.split.getTableSchemas(), 0);
    }

    private void dispatchLsnEndEvent(StreamSplit backFillBinlogSplit, Map<String, ?> sourcePartition, JdbcSourceEventDispatcher<SqlServerPartition> eventDispatcher) throws InterruptedException {
        eventDispatcher.dispatchWatermarkEvent(sourcePartition, backFillBinlogSplit, backFillBinlogSplit.getEndingOffset(), WatermarkKind.END);
    }

    private SqlServerStreamFetchTask.StreamSplitReadTask createBackFillLsnSplitReadTask(StreamSplit backfillBinlogSplit, SqlServerSourceFetchTaskContext context) {
        Configuration dezConf = ((Configuration.Builder)((Configuration.Builder)context.getDbzConnectorConfig().getConfig().edit().with("table.include.list", (Object)new TableId(null, this.split.getTableId().schema(), this.split.getTableId().table()))).with(Heartbeat.HEARTBEAT_INTERVAL, 0)).build();
        return new SqlServerStreamFetchTask.StreamSplitReadTask(new SqlServerConnectorConfig(dezConf), context.getConnection(), context.getMetaDataConnection(), context.getDispatcher(), context.getErrorHandler(), context.getDatabaseSchema(), backfillBinlogSplit);
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public SourceSplitBase getSplit() {
        return this.split;
    }

    @Override
    public void close() {
        this.taskRunning = false;
    }

    public class SnapshotBinlogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        public void finished() {
            SqlServerScanFetchTask.this.taskRunning = false;
        }

        @Override
        public boolean isRunning() {
            return SqlServerScanFetchTask.this.taskRunning;
        }
    }

    public static class SnapshotSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private LsnOffset lowWatermark;
        private LsnOffset highWatermark;

        public LsnOffset getLowWatermark() {
            return this.lowWatermark;
        }

        public void setLowWatermark(LsnOffset lowWatermark) {
            this.lowWatermark = lowWatermark;
        }

        public LsnOffset getHighWatermark() {
            return this.highWatermark;
        }

        public void setHighWatermark(LsnOffset highWatermark) {
            this.highWatermark = highWatermark;
        }

        @Override
        public boolean isRunning() {
            return this.lowWatermark != null && this.highWatermark != null;
        }
    }

    public static class SqlServerSnapshotSplitReadTask
    extends AbstractSnapshotChangeEventSource<SqlServerPartition, SqlServerOffsetContext> {
        private static final Logger LOG = LoggerFactory.getLogger(SqlServerSnapshotSplitReadTask.class);
        private static final Duration LOG_INTERVAL = Duration.ofMillis(10000L);
        private final SqlServerConnectorConfig connectorConfig;
        private final SqlServerDatabaseSchema databaseSchema;
        private final SqlServerConnection jdbcConnection;
        private final JdbcSourceEventDispatcher<SqlServerPartition> dispatcher;
        private final Clock clock;
        private final SnapshotSplit snapshotSplit;
        private final SqlServerOffsetContext offsetContext;
        private final SnapshotProgressListener<SqlServerPartition> snapshotProgressListener;
        private final EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver;

        public SqlServerSnapshotSplitReadTask(SqlServerConnectorConfig connectorConfig, SqlServerOffsetContext previousOffset, SnapshotProgressListener<SqlServerPartition> snapshotProgressListener, SqlServerDatabaseSchema databaseSchema, SqlServerConnection jdbcConnection, JdbcSourceEventDispatcher<SqlServerPartition> dispatcher, EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver, SnapshotSplit snapshotSplit) {
            super(connectorConfig, snapshotProgressListener);
            this.offsetContext = previousOffset;
            this.connectorConfig = connectorConfig;
            this.databaseSchema = databaseSchema;
            this.jdbcConnection = jdbcConnection;
            this.dispatcher = dispatcher;
            this.clock = Clock.SYSTEM;
            this.snapshotSplit = snapshotSplit;
            this.snapshotProgressListener = snapshotProgressListener;
            this.snapshotReceiver = snapshotReceiver;
        }

        @Override
        public SnapshotResult<SqlServerOffsetContext> execute(ChangeEventSource.ChangeEventSourceContext context, SqlServerPartition partition, SqlServerOffsetContext previousOffset) throws InterruptedException {
            SqlSeverSnapshotContext ctx;
            AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask = this.getSnapshottingTask(partition, previousOffset);
            try {
                ctx = this.prepare(partition);
            }
            catch (Exception e) {
                LOG.error("Failed to initialize snapshot context.", (Throwable)e);
                throw new RuntimeException(e);
            }
            try {
                return this.doExecute(context, previousOffset, (AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext>)ctx, snapshottingTask);
            }
            catch (InterruptedException e) {
                LOG.warn("Snapshot was interrupted before completion");
                throw e;
            }
            catch (Exception t) {
                throw new DebeziumException(t);
            }
        }

        @Override
        protected SnapshotResult<SqlServerOffsetContext> doExecute(ChangeEventSource.ChangeEventSourceContext context, SqlServerOffsetContext previousOffset, AbstractSnapshotChangeEventSource.SnapshotContext<SqlServerPartition, SqlServerOffsetContext> snapshotContext, AbstractSnapshotChangeEventSource.SnapshottingTask snapshottingTask) throws Exception {
            SqlSeverSnapshotContext ctx = (SqlSeverSnapshotContext)snapshotContext;
            ctx.offset = this.offsetContext;
            LsnOffset lowWatermark = SqlServerUtils.currentLsn(this.jdbcConnection);
            LOG.info("Snapshot step 1 - Determining low watermark {} for split {}", (Object)lowWatermark, (Object)this.snapshotSplit);
            ((SnapshotSplitChangeEventSourceContext)context).setLowWatermark(lowWatermark);
            this.dispatcher.dispatchWatermarkEvent(((SqlServerPartition)snapshotContext.partition).getSourcePartition(), this.snapshotSplit, lowWatermark, WatermarkKind.LOW);
            LOG.info("Snapshot step 2 - Snapshotting data");
            this.createDataEvents(ctx, this.snapshotSplit.getTableId());
            LsnOffset highWatermark = SqlServerUtils.currentLsn(this.jdbcConnection);
            LOG.info("Snapshot step 3 - Determining high watermark {} for split {}", (Object)highWatermark, (Object)this.snapshotSplit);
            ((SnapshotSplitChangeEventSourceContext)context).setHighWatermark(highWatermark);
            this.dispatcher.dispatchWatermarkEvent(((SqlServerPartition)snapshotContext.partition).getSourcePartition(), this.snapshotSplit, highWatermark, WatermarkKind.HIGH);
            return SnapshotResult.completed(ctx.offset);
        }

        @Override
        protected AbstractSnapshotChangeEventSource.SnapshottingTask getSnapshottingTask(SqlServerPartition partition, SqlServerOffsetContext previousOffset) {
            return new AbstractSnapshotChangeEventSource.SnapshottingTask(false, true);
        }

        protected SqlSeverSnapshotContext prepare(SqlServerPartition partition) throws Exception {
            return new SqlSeverSnapshotContext(partition);
        }

        private void createDataEvents(SqlSeverSnapshotContext snapshotContext, TableId tableId) throws Exception {
            LOG.debug("Snapshotting table {}", (Object)tableId);
            this.createDataEventsForTable(snapshotContext, this.snapshotReceiver, this.databaseSchema.tableFor(tableId));
            this.snapshotReceiver.completeSnapshot();
        }

        private void createDataEventsForTable(SqlSeverSnapshotContext snapshotContext, EventDispatcher.SnapshotReceiver<SqlServerPartition> snapshotReceiver, Table table) throws InterruptedException {
            long exportStart = this.clock.currentTimeInMillis();
            LOG.info("Exporting data from split '{}' of table {}", (Object)this.snapshotSplit.splitId(), (Object)table.id());
            String selectSql = SqlServerUtils.buildSplitScanQuery(this.snapshotSplit.getTableId(), this.snapshotSplit.getSplitKeyType(), this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null);
            LOG.info("For split '{}' of table {} using select statement: '{}'", new Object[]{this.snapshotSplit.splitId(), table.id(), selectSql});
            try (PreparedStatement selectStatement = SqlServerUtils.readTableSplitDataStatement(this.jdbcConnection, selectSql, this.snapshotSplit.getSplitStart() == null, this.snapshotSplit.getSplitEnd() == null, this.snapshotSplit.getSplitStart(), this.snapshotSplit.getSplitEnd(), this.snapshotSplit.getSplitKeyType().getFieldCount(), this.connectorConfig.getQueryFetchSize());
                 ResultSet rs = selectStatement.executeQuery();){
                ColumnUtils.ColumnArray columnArray = ColumnUtils.toArray(rs, table);
                long rows = 0L;
                Threads.Timer logTimer = this.getTableScanLogTimer();
                while (rs.next()) {
                    ++rows;
                    Object[] row = this.jdbcConnection.rowToArray(table, this.databaseSchema, rs, columnArray);
                    if (logTimer.expired()) {
                        long stop = this.clock.currentTimeInMillis();
                        LOG.info("Exported {} records for split '{}' after {}", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(stop - exportStart)});
                        this.snapshotProgressListener.rowsScanned((SqlServerPartition)snapshotContext.partition, table.id(), rows);
                        logTimer = this.getTableScanLogTimer();
                    }
                    this.dispatcher.dispatchSnapshotEvent((SqlServerPartition)snapshotContext.partition, table.id(), this.getChangeRecordEmitter(snapshotContext, table.id(), row), snapshotReceiver);
                }
                LOG.info("Finished exporting {} records for split '{}', total duration '{}'", new Object[]{rows, this.snapshotSplit.splitId(), Strings.duration(this.clock.currentTimeInMillis() - exportStart)});
            }
            catch (SQLException e) {
                throw new ConnectException("Snapshotting of table " + table.id() + " failed", e);
            }
        }

        protected ChangeRecordEmitter<SqlServerPartition> getChangeRecordEmitter(SqlSeverSnapshotContext snapshotContext, TableId tableId, Object[] row) {
            ((SqlServerOffsetContext)snapshotContext.offset).event(tableId, this.clock.currentTime());
            return new SnapshotChangeRecordEmitter<Partition>(snapshotContext.partition, snapshotContext.offset, row, this.clock);
        }

        private Threads.Timer getTableScanLogTimer() {
            return Threads.timer(this.clock, LOG_INTERVAL);
        }

        private static class SqlSeverSnapshotContext
        extends RelationalSnapshotChangeEventSource.RelationalSnapshotContext<SqlServerPartition, SqlServerOffsetContext> {
            public SqlSeverSnapshotContext(SqlServerPartition partition) throws SQLException {
                super(partition, "");
            }
        }
    }
}

