/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.sqlserver.source.reader.fetch;

import com.ververica.cdc.connectors.base.relational.JdbcSourceEventDispatcher;
import com.ververica.cdc.connectors.base.source.meta.offset.Offset;
import com.ververica.cdc.connectors.base.source.meta.split.SourceSplitBase;
import com.ververica.cdc.connectors.base.source.meta.split.StreamSplit;
import com.ververica.cdc.connectors.base.source.meta.wartermark.WatermarkKind;
import com.ververica.cdc.connectors.base.source.reader.external.FetchTask;
import com.ververica.cdc.connectors.sqlserver.source.offset.LsnOffset;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerScanFetchTask;
import com.ververica.cdc.connectors.sqlserver.source.reader.fetch.SqlServerSourceFetchTaskContext;
import io.debezium.DebeziumException;
import io.debezium.connector.sqlserver.Lsn;
import io.debezium.connector.sqlserver.SqlServerConnection;
import io.debezium.connector.sqlserver.SqlServerConnectorConfig;
import io.debezium.connector.sqlserver.SqlServerDatabaseSchema;
import io.debezium.connector.sqlserver.SqlServerOffsetContext;
import io.debezium.connector.sqlserver.SqlServerPartition;
import io.debezium.connector.sqlserver.SqlServerStreamingChangeEventSource;
import io.debezium.pipeline.ErrorHandler;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlServerStreamFetchTask
implements FetchTask<SourceSplitBase> {
    private final StreamSplit split;
    private volatile boolean taskRunning = false;
    private StreamSplitReadTask redoLogSplitReadTask;

    public SqlServerStreamFetchTask(StreamSplit split) {
        this.split = split;
    }

    @Override
    public void execute(FetchTask.Context context) throws Exception {
        SqlServerSourceFetchTaskContext sourceFetchContext = (SqlServerSourceFetchTaskContext)context;
        sourceFetchContext.getOffsetContext().preSnapshotCompletion();
        this.taskRunning = true;
        this.redoLogSplitReadTask = new StreamSplitReadTask(sourceFetchContext.getDbzConnectorConfig(), sourceFetchContext.getConnection(), sourceFetchContext.getMetaDataConnection(), sourceFetchContext.getDispatcher(), sourceFetchContext.getErrorHandler(), sourceFetchContext.getDatabaseSchema(), this.split);
        RedoLogSplitChangeEventSourceContext changeEventSourceContext = new RedoLogSplitChangeEventSourceContext();
        this.redoLogSplitReadTask.execute((ChangeEventSource.ChangeEventSourceContext)changeEventSourceContext, sourceFetchContext.getPartition(), sourceFetchContext.getOffsetContext());
    }

    @Override
    public boolean isRunning() {
        return this.taskRunning;
    }

    @Override
    public StreamSplit getSplit() {
        return this.split;
    }

    @Override
    public void close() {
        this.taskRunning = false;
    }

    private class RedoLogSplitChangeEventSourceContext
    implements ChangeEventSource.ChangeEventSourceContext {
        private RedoLogSplitChangeEventSourceContext() {
        }

        @Override
        public boolean isRunning() {
            return SqlServerStreamFetchTask.this.taskRunning;
        }
    }

    public static class StreamSplitReadTask
    extends SqlServerStreamingChangeEventSource {
        private static final Logger LOG = LoggerFactory.getLogger(StreamSplitReadTask.class);
        private final StreamSplit lsnSplit;
        private final JdbcSourceEventDispatcher<SqlServerPartition> dispatcher;
        private final ErrorHandler errorHandler;
        private ChangeEventSource.ChangeEventSourceContext context;

        public StreamSplitReadTask(SqlServerConnectorConfig connectorConfig, SqlServerConnection connection, SqlServerConnection metadataConnection, JdbcSourceEventDispatcher<SqlServerPartition> dispatcher, ErrorHandler errorHandler, SqlServerDatabaseSchema schema, StreamSplit lsnSplit) {
            super(connectorConfig, connection, metadataConnection, dispatcher, errorHandler, Clock.system(), schema);
            this.lsnSplit = lsnSplit;
            this.dispatcher = dispatcher;
            this.errorHandler = errorHandler;
        }

        @Override
        public void afterHandleLsn(SqlServerPartition partition, Lsn toLsn) {
            Offset endingOffset;
            LsnOffset currentLsnOffset;
            if (this.isBoundedRead() && (currentLsnOffset = new LsnOffset(null, toLsn, null)).isAtOrAfter(endingOffset = this.lsnSplit.getEndingOffset())) {
                try {
                    this.dispatcher.dispatchWatermarkEvent(partition.getSourcePartition(), this.lsnSplit, currentLsnOffset, WatermarkKind.END);
                }
                catch (InterruptedException e) {
                    LOG.error("Send signal event error.", (Throwable)e);
                    this.errorHandler.setProducerThrowable(new DebeziumException("Error processing binlog signal event", e));
                }
                ((SqlServerScanFetchTask.SnapshotBinlogSplitChangeEventSourceContext)this.context).finished();
            }
        }

        private boolean isBoundedRead() {
            return !LsnOffset.NO_STOPPING_OFFSET.equals(this.lsnSplit.getEndingOffset());
        }

        @Override
        public void execute(ChangeEventSource.ChangeEventSourceContext context, SqlServerPartition partition, SqlServerOffsetContext offsetContext) throws InterruptedException {
            this.context = context;
            super.execute(context, partition, offsetContext);
        }
    }
}

