/*
 * Decompiled with CFR 0.152.
 */
package com.yunpian.sdk.api;

import com.yunpian.sdk.constant.Code;
import com.yunpian.sdk.constant.YunpianConstant;
import com.yunpian.sdk.model.Result;
import com.yunpian.sdk.util.JsonUtil;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface YunpianApiResult {
    public <R, T> Result<T> result(String var1, ResultHandler<R, T> var2, Result<T> var3);

    public static abstract class SimpleListResultHandler<T>
    extends ListResultHandler<T, List<T>>
    implements YunpianConstant {
    }

    public static abstract class ListResultHandler<R, T>
    extends AbstractResultHandler<List<R>, T>
    implements YunpianConstant {
        protected Map<String, String> rspMap;

        @Override
        public List<R> response(String rsp) throws Exception {
            if (rsp == null) {
                return Collections.emptyList();
            }
            if (rsp.startsWith("[")) {
                return (List)JsonUtil.fromJson(rsp, this.rspType());
            }
            this.rspMap = JsonUtil.fromJsonToMap(rsp);
            return Collections.emptyList();
        }

        abstract Type rspType();

        @Override
        public Result<T> succ(Integer code, List<R> rsp, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            r.setCode(code).setMsg(Code.getErrorMsg(code));
            T data = this.data(rsp);
            return r.setData(data);
        }

        public abstract T data(List<R> var1);

        @Override
        public Result<T> fail(Integer code, List<R> rsp, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            Map<Object, Object> map = this.rspMap == null ? Collections.emptyMap() : this.rspMap;
            return r.setCode(code).setMsg(map.containsKey("msg") ? (String)map.get("msg") : Code.getErrorMsg(code)).setDetail((String)map.get("detail"));
        }

        @Override
        public Result<T> catchExceptoin(Throwable e, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            return r.setCode(-50).setMsg(Code.getErrorMsg(-50)).setThrowable(e);
        }
    }

    public static abstract class MapResultHandler<T>
    extends AbstractResultHandler<Map<String, String>, T>
    implements YunpianConstant {
        @Override
        public Map<String, String> response(String rsp) throws Exception {
            if (rsp == null) {
                return Collections.emptyMap();
            }
            return JsonUtil.fromJsonToMap(rsp);
        }

        @Override
        public Result<T> succ(Integer code, Map<String, String> rsp, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            r.setCode(code).setMsg(rsp.containsKey("msg") ? rsp.get("msg") : Code.getErrorMsg(code));
            T data = this.data(rsp);
            return r.setData(data);
        }

        public abstract T data(Map<String, String> var1);

        @Override
        public Result<T> fail(Integer code, Map<String, String> rsp, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            return r.setCode(code).setMsg(rsp.containsKey("msg") ? rsp.get("msg") : Code.getErrorMsg(code)).setDetail(rsp.get("detail"));
        }
    }

    public static abstract class AbstractResultHandler<R, T>
    implements ResultHandler<R, T> {
        @Override
        public Result<T> catchExceptoin(Throwable e, Result<T> r) {
            if (r == null) {
                r = new Result();
            }
            return r.setCode(-50).setMsg(Code.getErrorMsg(-50)).setThrowable(e);
        }
    }

    public static interface ResultHandler<R, T> {
        public R response(String var1) throws Exception;

        public Integer code(R var1);

        public Result<T> succ(Integer var1, R var2, Result<T> var3);

        public Result<T> fail(Integer var1, R var2, Result<T> var3);

        public Result<T> catchExceptoin(Throwable var1, Result<T> var2);
    }
}

