/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.io;

import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LEDataOutputStream
implements DataOutput {
    private static final String EMBEDDEDCOPYRIGHT = "copyright (c) 1999-2007 Roedy Green, Canadian Mind Products, http://mindprod.com";
    protected final DataOutputStream dis;
    protected final byte[] work;

    public LEDataOutputStream(OutputStream out) {
        this.dis = new DataOutputStream(out);
        this.work = new byte[8];
    }

    public LEDataOutputStream(String filename) throws FileNotFoundException {
        this(new FileOutputStream(filename));
    }

    public final void close() throws IOException {
        this.dis.close();
    }

    public void flush() throws IOException {
        this.dis.flush();
    }

    public final int size() {
        return this.dis.size();
    }

    @Override
    public final synchronized void write(int ib) throws IOException {
        this.dis.write(ib);
    }

    @Override
    public final void write(byte[] ba) throws IOException {
        this.dis.write(ba, 0, ba.length);
    }

    @Override
    public final synchronized void write(byte[] ba, int off, int len) throws IOException {
        this.dis.write(ba, off, len);
    }

    @Override
    public final void writeBoolean(boolean v) throws IOException {
        this.dis.writeBoolean(v);
    }

    public final void writeBoolean(boolean[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeBoolean(v[i]);
            ++i;
        }
    }

    public final void writeBoolean(boolean[] v) throws IOException {
        this.writeBoolean(v, 0, v.length);
    }

    @Override
    public final void writeByte(int v) throws IOException {
        this.dis.writeByte(v);
    }

    public final void writeByte(byte[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeByte(v[i]);
            ++i;
        }
    }

    public final void writeByte(byte[] v) throws IOException {
        this.writeByte(v, 0, v.length);
    }

    @Override
    public final void writeBytes(String s) throws IOException {
        this.dis.writeBytes(s);
    }

    @Override
    public final void writeChar(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.dis.write(this.work, 0, 2);
    }

    public final void writeChar(char[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeChar(v[i]);
            ++i;
        }
    }

    public final void writeChar(char[] v) throws IOException {
        this.writeChar(v, 0, v.length);
    }

    @Override
    public final void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.writeChar(s.charAt(i));
            ++i;
        }
    }

    @Override
    public final void writeDouble(double v) throws IOException {
        this.writeLong(Double.doubleToLongBits(v));
    }

    public final void writeDouble(double[] v, int startPos, int len) throws IOException {
        int i = startPos;
        while (i < startPos + len) {
            this.writeDouble(v[i]);
            ++i;
        }
    }

    public final void writeDouble(double[] v) throws IOException {
        this.writeDouble(v, 0, v.length);
    }

    @Override
    public final void writeFloat(float v) throws IOException {
        this.writeInt(Float.floatToIntBits(v));
    }

    public final void writeFloat(float[] v, int startPos, int len) throws IOException {
        int i = startPos;
        while (i < startPos + len) {
            this.writeFloat(v[i]);
            ++i;
        }
    }

    public final void writeFloat(float[] v) throws IOException {
        this.writeFloat(v, 0, v.length);
    }

    @Override
    public final void writeInt(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.work[2] = (byte)(v >> 16);
        this.work[3] = (byte)(v >> 24);
        this.dis.write(this.work, 0, 4);
    }

    public final void writeInt(int[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeInt(v[i]);
            ++i;
        }
    }

    public final void writeInt(int[] v) throws IOException {
        this.writeInt(v, 0, v.length);
    }

    @Override
    public final void writeLong(long v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.work[2] = (byte)(v >> 16);
        this.work[3] = (byte)(v >> 24);
        this.work[4] = (byte)(v >> 32);
        this.work[5] = (byte)(v >> 40);
        this.work[6] = (byte)(v >> 48);
        this.work[7] = (byte)(v >> 56);
        this.dis.write(this.work, 0, 8);
    }

    public final void writeLong(long[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeLong(v[i]);
            ++i;
        }
    }

    public final void writeLong(long[] v) throws IOException {
        this.writeLong(v, 0, v.length);
    }

    @Override
    public final void writeShort(int v) throws IOException {
        this.work[0] = (byte)v;
        this.work[1] = (byte)(v >> 8);
        this.dis.write(this.work, 0, 2);
    }

    public final void writeShort(short[] v, int startPos, int len) throws IOException {
        assert (v.length < startPos + len);
        int i = startPos;
        while (i < startPos + len) {
            this.writeShort(v[i]);
            ++i;
        }
    }

    public final void writeShort(short[] v) throws IOException {
        this.writeShort(v, 0, v.length);
    }

    @Override
    public final void writeUTF(String s) throws IOException {
        this.dis.writeUTF(s);
    }
}

