/*
 * Decompiled with CFR 0.152.
 */
package marytts.cart.io;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import marytts.cart.DecisionNode;
import marytts.cart.DirectedGraph;
import marytts.cart.DirectedGraphNode;
import marytts.cart.LeafNode;
import marytts.cart.Node;
import marytts.cart.io.MaryCARTReader;
import marytts.exceptions.MaryConfigurationException;
import marytts.features.FeatureDefinition;
import marytts.util.data.MaryHeader;

public class DirectedGraphReader {
    public static int LEAFNODE = 0;
    public static int DECISIONNODE = 1;
    public static int DIRECTEDGRAPHNODE = 2;

    public DirectedGraph load(String fileName) throws IOException, MaryConfigurationException {
        try (FileInputStream is = new FileInputStream(fileName);){
            DirectedGraph directedGraph = this.load(is);
            return directedGraph;
        }
    }

    public DirectedGraph load(InputStream inStream) throws IOException, MaryConfigurationException {
        Node rootNode;
        Properties props;
        BufferedInputStream buffInStream = new BufferedInputStream(inStream);
        assert (buffInStream.markSupported());
        buffInStream.mark(10000);
        DataInputStream raf = new DataInputStream(buffInStream);
        MaryHeader maryHeader = new MaryHeader((DataInput)raf);
        if (!maryHeader.hasCurrentVersion()) {
            throw new IOException("Wrong version of database file");
        }
        if (maryHeader.getType() != 110) {
            if (maryHeader.getType() == 100) {
                buffInStream.reset();
                return new MaryCARTReader().loadFromStream(buffInStream);
            }
            throw new IOException("Not a directed graph file");
        }
        short propDataLength = raf.readShort();
        if (propDataLength == 0) {
            props = null;
        } else {
            byte[] propsData = new byte[propDataLength];
            raf.readFully(propsData);
            ByteArrayInputStream bais = new ByteArrayInputStream(propsData);
            props = new Properties();
            props.load(bais);
            bais.close();
        }
        FeatureDefinition featureDefinition = new FeatureDefinition(raf);
        int numDecNodes = raf.readInt();
        DecisionNode[] dns = new DecisionNode[numDecNodes];
        int[][] childIndexes = new int[numDecNodes][];
        int i = 0;
        while (i < numDecNodes) {
            int featureNameIndex = raf.readInt();
            int nodeTypeNr = raf.readInt();
            DecisionNode.Type nodeType = DecisionNode.Type.values()[nodeTypeNr];
            int numChildren = 2;
            switch (nodeType) {
                case BinaryByteDecisionNode: {
                    int criterion = raf.readInt();
                    dns[i] = new DecisionNode.BinaryByteDecisionNode(featureNameIndex, (byte)criterion, featureDefinition);
                    break;
                }
                case BinaryShortDecisionNode: {
                    int criterion = raf.readInt();
                    dns[i] = new DecisionNode.BinaryShortDecisionNode(featureNameIndex, (short)criterion, featureDefinition);
                    break;
                }
                case BinaryFloatDecisionNode: {
                    float floatCriterion = raf.readFloat();
                    dns[i] = new DecisionNode.BinaryFloatDecisionNode(featureNameIndex, floatCriterion, featureDefinition);
                    break;
                }
                case ByteDecisionNode: {
                    numChildren = raf.readInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ByteDecisionNode(featureNameIndex, numChildren, featureDefinition);
                    break;
                }
                case ShortDecisionNode: {
                    numChildren = raf.readInt();
                    if (featureDefinition.getNumberOfValues(featureNameIndex) != numChildren) {
                        throw new IOException("Inconsistent cart file: feature " + featureDefinition.getFeatureName(featureNameIndex) + " should have " + featureDefinition.getNumberOfValues(featureNameIndex) + " values, but decision node " + i + " has only " + numChildren + " child nodes");
                    }
                    dns[i] = new DecisionNode.ShortDecisionNode(featureNameIndex, numChildren, featureDefinition);
                }
            }
            dns[i].setUniqueDecisionNodeId(i + 1);
            childIndexes[i] = new int[numChildren];
            int k = 0;
            while (k < numChildren) {
                childIndexes[i][k] = raf.readInt();
                ++k;
            }
            ++i;
        }
        int numLeafNodes = raf.readInt();
        LeafNode[] lns = new LeafNode[numLeafNodes];
        int j = 0;
        while (j < numLeafNodes) {
            int leafTypeNr = raf.readInt();
            LeafNode.LeafType leafNodeType = LeafNode.LeafType.values()[leafTypeNr];
            switch (leafNodeType) {
                case IntArrayLeafNode: {
                    int numData = raf.readInt();
                    int[] data = new int[numData];
                    int d = 0;
                    while (d < numData) {
                        data[d] = raf.readInt();
                        ++d;
                    }
                    lns[j] = new LeafNode.IntArrayLeafNode(data);
                    break;
                }
                case FloatLeafNode: {
                    float stddev = raf.readFloat();
                    float mean = raf.readFloat();
                    lns[j] = new LeafNode.FloatLeafNode(new float[]{stddev, mean});
                    break;
                }
                case IntAndFloatArrayLeafNode: 
                case StringAndFloatLeafNode: {
                    int numPairs = raf.readInt();
                    int[] ints = new int[numPairs];
                    float[] floats = new float[numPairs];
                    int d = 0;
                    while (d < numPairs) {
                        ints[d] = raf.readInt();
                        floats[d] = raf.readFloat();
                        ++d;
                    }
                    if (leafNodeType == LeafNode.LeafType.IntAndFloatArrayLeafNode) {
                        lns[j] = new LeafNode.IntAndFloatArrayLeafNode(ints, floats);
                        break;
                    }
                    lns[j] = new LeafNode.StringAndFloatLeafNode(ints, floats);
                    break;
                }
                case FeatureVectorLeafNode: {
                    throw new IllegalArgumentException("Reading feature vector leaf nodes is not yet implemented");
                }
                case PdfLeafNode: {
                    throw new IllegalArgumentException("Reading pdf leaf nodes is not yet implemented");
                }
            }
            lns[j].setUniqueLeafId(j + 1);
            ++j;
        }
        int numDirectedGraphNodes = raf.readInt();
        DirectedGraphNode[] graphNodes = new DirectedGraphNode[numDirectedGraphNodes];
        int[] dgnLeafIndices = new int[numDirectedGraphNodes];
        int[] dgnDecIndices = new int[numDirectedGraphNodes];
        int g = 0;
        while (g < numDirectedGraphNodes) {
            graphNodes[g] = new DirectedGraphNode(null, null);
            graphNodes[g].setUniqueGraphNodeID(g + 1);
            dgnLeafIndices[g] = raf.readInt();
            dgnDecIndices[g] = raf.readInt();
            ++g;
        }
        int i2 = 0;
        while (i2 < numDecNodes) {
            int k = 0;
            while (k < childIndexes[i2].length) {
                Node child = this.childIndexToNode(childIndexes[i2][k], dns, lns, graphNodes);
                dns[i2].addDaughter(child);
                ++k;
            }
            ++i2;
        }
        g = 0;
        while (g < numDirectedGraphNodes) {
            Node leaf = this.childIndexToNode(dgnLeafIndices[g], dns, lns, graphNodes);
            graphNodes[g].setLeafNode(leaf);
            Node dec = this.childIndexToNode(dgnDecIndices[g], dns, lns, graphNodes);
            if (dec != null && !dec.isDecisionNode()) {
                throw new IllegalArgumentException("Only decision nodes allowed, read " + dec.getClass());
            }
            graphNodes[g].setDecisionNode((DecisionNode)dec);
            ++g;
        }
        if (graphNodes.length > 0) {
            rootNode = graphNodes[0];
        } else if (dns.length > 0) {
            rootNode = dns[0];
            ((DecisionNode)rootNode).countData();
        } else {
            rootNode = lns.length > 0 ? lns[0] : null;
        }
        return new DirectedGraph(rootNode, featureDefinition, props);
    }

    private Node childIndexToNode(int childIndexAndType, DecisionNode[] dns, LeafNode[] lns, DirectedGraphNode[] graphNodes) {
        int childIndex = childIndexAndType & 0x3FFFFFFF;
        int childType = childIndexAndType >> 30 & 3;
        if (childIndex == 0) {
            return null;
        }
        if (childType == DECISIONNODE) {
            assert (childIndex - 1 < dns.length);
            return dns[childIndex - 1];
        }
        if (childType == LEAFNODE) {
            assert (childIndex - 1 < lns.length);
            return lns[childIndex - 1];
        }
        if (childType == DIRECTEDGRAPHNODE) {
            assert (childIndex - 1 < graphNodes.length);
            return graphNodes[childIndex - 1];
        }
        throw new IllegalArgumentException("Unexpected child type: " + childType);
    }
}

