/*
 * Decompiled with CFR 0.152.
 */
package marytts.htsengine;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.htsengine.HMMData;
import marytts.htsengine.HTSPStream;
import marytts.htsengine.HTSParameterGeneration;
import marytts.signalproc.process.AmplitudeNormalizer;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.MaryUtils;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.ProducingDoubleDataSource;
import marytts.util.data.audio.AudioPlayer;
import marytts.util.data.audio.DDSAudioInputStream;
import marytts.util.io.FileUtils;
import marytts.util.io.LEDataInputStream;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;

public class HTSVocoder {
    public static final int IPERIOD = 1;
    public static final int SEED = 1;
    public static final int PADEORDER = 5;
    public static final int IRLENG = 96;
    public static final double ZERO = 1.0E-10;
    public static final double LZERO = -1.0E10;
    static final double[] pade = new double[]{1.0, 1.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.4999273, 0.1067005, 0.01170221, 5.656279E-4, 1.0, 0.4999391, 0.1107098, 0.01369984, 9.564853E-4, 3.041721E-5};
    static final int ppade = 15;
    private static final Logger logger = MaryUtils.getLogger((String)"Vocoder");
    private Random rand;
    private int stage;
    private double gamma;
    private boolean use_log_gain;
    private int fprd;
    private double p1;
    private double pc;
    private double[] C;
    private double[] CC;
    private double[] CINC;
    private double[] D1;
    private double rate;
    int pt2;
    private final int[] pt3 = new int[6];
    private int numM;
    private int orderM;
    private double[][] h;
    private double[] xpulseSignal;
    private double[] xnoiseSignal;
    private boolean mixedExcitation = false;
    private boolean fourierMagnitudes = false;

    private void initVocoder(int mcep_order, int mcep_vsize, HMMData htsData) {
        this.stage = htsData.getStage();
        this.gamma = htsData.getGamma();
        this.use_log_gain = htsData.getUseLogGain();
        this.fprd = htsData.getFperiod();
        this.rate = htsData.getRate();
        this.rand = new Random(1L);
        this.C = new double[mcep_order];
        this.CC = new double[mcep_order];
        this.CINC = new double[mcep_order];
        if (this.stage == 0) {
            int vector_size = mcep_vsize * 8 + 25 + 6 - 3 * mcep_order;
            this.D1 = new double[vector_size];
            this.pt2 = 12 + 5 * (mcep_order + 1);
            int i = 5;
            while (i >= 1) {
                this.pt3[i] = 12 + (i - 1) * (mcep_order + 1);
                --i;
            }
        } else {
            int vector_size = (mcep_vsize + 1) * (this.stage + 3) - 3 * mcep_order;
            this.D1 = new double[vector_size];
        }
        this.p1 = -1.0;
        this.pc = 0.0;
    }

    public AudioInputStream htsMLSAVocoder(HTSParameterGeneration pdf2par, HMMData htsData) throws Exception {
        int audioSize = this.computeAudioSize(pdf2par.getMcepPst(), htsData);
        HTSVocoderDataProducer producer = new HTSVocoderDataProducer(audioSize, pdf2par, htsData);
        producer.start();
        return new DDSAudioInputStream((DoubleDataSource)producer, HTSVocoder.getHTSAudioFormat(htsData));
    }

    public static AudioFormat getHTSAudioFormat(HMMData htsData) {
        float sampleRate = htsData.getRate();
        int sampleSizeInBits = 16;
        int channels = 1;
        boolean signed = true;
        boolean bigEndian = false;
        AudioFormat af = new AudioFormat(sampleRate, sampleSizeInBits, channels, signed, bigEndian);
        return af;
    }

    public double[] htsMLSAVocoder(HTSPStream lf0Pst, HTSPStream mcepPst, HTSPStream strPst, HTSPStream magPst, boolean[] voiced, HMMData htsData, HTSVocoderDataProducer audioProducer) throws Exception {
        double xp = 0.0;
        double xn = 0.0;
        double alpha = htsData.getAlpha();
        double beta = htsData.getBeta();
        double[] magPulse = null;
        double[] hp = null;
        double[] hn = null;
        int m = mcepPst.getOrder();
        this.initVocoder(m, mcepPst.getVsize() - 1, htsData);
        double[] pulse = new double[this.fprd];
        double[] noise = new double[this.fprd];
        double[] source = new double[this.fprd];
        double[] cfr_ignored_0 = new double[m];
        this.mixedExcitation = htsData.getUseMixExc();
        this.fourierMagnitudes = htsData.getUseFourierMag();
        if (this.mixedExcitation && htsData.getPdfStrStream() != null) {
            this.numM = htsData.getNumFilters();
            this.orderM = htsData.getOrderFilters();
            this.xpulseSignal = new double[this.orderM];
            this.xnoiseSignal = new double[this.orderM];
            this.h = htsData.getMixFilters();
            hp = new double[this.orderM];
            hn = new double[this.orderM];
            if (this.numM != strPst.getOrder()) {
                logger.debug((Object)("htsMLSAVocoder: error num mix-excitation filters =" + this.numM + " in configuration file is different from generated str order=" + strPst.getOrder()));
                throw new Exception("htsMLSAVocoder: error num mix-excitation filters = " + this.numM + " in configuration file is different from generated str order=" + strPst.getOrder());
            }
            logger.debug((Object)"HMM speech generation with mixed-excitation.");
        } else {
            logger.debug((Object)"HMM speech generation without mixed-excitation.");
        }
        if (this.fourierMagnitudes && htsData.getPdfMagStream() != null) {
            logger.debug((Object)"Pulse generated with Fourier Magnitudes.");
        }
        if (beta != 0.0) {
            logger.debug((Object)("Postfiltering applied with beta=" + beta));
        } else {
            logger.debug((Object)"No postfiltering applied.");
        }
        double f0Std = htsData.getF0Std();
        double f0Shift = htsData.getF0Mean();
        double f0MeanOri = 0.0;
        int mcepframe = 0;
        int lf0frame = 0;
        while (mcepframe < mcepPst.getT()) {
            if (voiced[mcepframe]) {
                f0MeanOri += Math.exp(lf0Pst.getPar(lf0frame, 0));
                ++lf0frame;
            }
            ++mcepframe;
        }
        f0MeanOri /= (double)lf0frame;
        int s_double = 0;
        int audio_size = this.computeAudioSize(mcepPst, htsData);
        double[] audio_double = new double[audio_size];
        int magSample = 1;
        int magPulseSize = 0;
        mcepframe = 0;
        lf0frame = 0;
        while (mcepframe < mcepPst.getT()) {
            double inc;
            int i;
            int i2;
            int j;
            double[] mc = new double[m];
            int i3 = 0;
            while (i3 < m) {
                mc[i3] = mcepPst.getPar(mcepframe, i3);
                ++i3;
            }
            double f0 = 0.0;
            if (voiced[mcepframe]) {
                f0 = f0Std * Math.exp(lf0Pst.getPar(lf0frame, 0)) + (1.0 - f0Std) * f0MeanOri + f0Shift;
                ++lf0frame;
                f0 = Math.max(0.0, f0);
            }
            double str = 0.0;
            if (this.mixedExcitation) {
                j = 0;
                while (j < this.orderM) {
                    hn[j] = 0.0;
                    hp[j] = 0.0;
                    i2 = 0;
                    while (i2 < this.numM) {
                        str = strPst.getPar(mcepframe, i2);
                        int n = j;
                        hp[n] = hp[n] + str * this.h[i2][j];
                        int n2 = j;
                        hn[n2] = hn[n2] + (1.0 - str) * this.h[i2][j];
                        ++i2;
                    }
                    ++j;
                }
            }
            if (f0 != 0.0) {
                f0 = this.rate / f0;
            }
            if (this.p1 < 0.0) {
                this.pc = this.p1 = f0;
                if (this.stage != 0) {
                    this.C[0] = this.use_log_gain ? -1.0E10 : 1.0E-10;
                    double PI_m = Math.PI / (double)m;
                    int i4 = 0;
                    while (i4 < m) {
                        this.C[i4] = (double)i4 * PI_m;
                        ++i4;
                    }
                    this.lsp2mgc(this.C, this.C, m - 1, alpha);
                    HTSVocoder.mc2b(this.C, this.C, m - 1, alpha);
                    HTSVocoder.gnorm(this.C, this.C, m - 1, this.gamma);
                    i4 = 1;
                    while (i4 < m) {
                        int n = i4++;
                        this.C[n] = this.C[n] * this.gamma;
                    }
                }
            }
            if (this.stage == 0) {
                HTSVocoder.postfilter_mgc(mc, m - 1, alpha, beta);
                HTSVocoder.mc2b(mc, this.CC, m - 1, alpha);
                i = 0;
                while (i < m) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * 1.0 / (double)this.fprd;
                    ++i;
                }
            } else {
                this.lsp2mgc(mc, this.CC, m - 1, alpha);
                HTSVocoder.mc2b(this.CC, this.CC, m - 1, alpha);
                HTSVocoder.gnorm(this.CC, this.CC, m - 1, this.gamma);
                i = 1;
                while (i < m) {
                    int n = i++;
                    this.CC[n] = this.CC[n] * this.gamma;
                }
                i = 0;
                while (i < m) {
                    this.CINC[i] = (this.CC[i] - this.C[i]) * 1.0 / (double)this.fprd;
                    ++i;
                }
            }
            if (this.p1 != 0.0 && f0 != 0.0) {
                inc = (f0 - this.p1) * 1.0 / (double)this.fprd;
            } else {
                inc = 0.0;
                this.pc = f0;
                this.p1 = 0.0;
            }
            j = this.fprd - 1;
            i2 = 1;
            while (j >= 0) {
                int k;
                double x;
                if (this.p1 == 0.0) {
                    x = this.uniformRand();
                    if (this.mixedExcitation) {
                        xn = x;
                        xp = 0.0;
                    }
                } else {
                    double d;
                    this.pc += 1.0;
                    if (d >= this.p1) {
                        if (this.fourierMagnitudes) {
                            magPulse = HTSVocoder.genPulseFromFourierMag(magPst, mcepframe, this.p1);
                            magSample = 0;
                            magPulseSize = magPulse.length;
                            x = magPulse[magSample];
                            ++magSample;
                        } else {
                            x = Math.sqrt(this.p1);
                        }
                        this.pc -= this.p1;
                    } else if (this.fourierMagnitudes) {
                        x = magSample >= magPulseSize ? 0.0 : magPulse[magSample];
                        ++magSample;
                    } else {
                        x = 0.0;
                    }
                    if (this.mixedExcitation) {
                        xp = x;
                        xn = this.uniformRand();
                    }
                }
                if (this.mixedExcitation) {
                    double fxp = 0.0;
                    double fxn = 0.0;
                    k = this.orderM - 1;
                    while (k > 0) {
                        fxp += hp[k] * this.xpulseSignal[k];
                        fxn += hn[k] * this.xnoiseSignal[k];
                        this.xpulseSignal[k] = this.xpulseSignal[k - 1];
                        this.xnoiseSignal[k] = this.xnoiseSignal[k - 1];
                        --k;
                    }
                    this.xpulseSignal[0] = xp;
                    this.xnoiseSignal[0] = xn;
                    double mix = (fxp += hp[0] * xp) + (fxn += hn[0] * xn);
                    pulse[j] = fxp;
                    noise[j] = fxn;
                    source[j] = mix;
                    x = mix;
                }
                if (this.stage == 0) {
                    if (x != 0.0) {
                        x *= Math.exp(this.C[0]);
                    }
                    x = HTSVocoder.mlsadf(x, this.C, m, alpha, this.D1, this.pt2, this.pt3);
                } else {
                    x *= this.C[0];
                    x = HTSVocoder.mglsadf(x, this.C, m - 1, alpha, this.stage, this.D1);
                }
                audio_double[s_double] = x;
                if (audioProducer != null) {
                    audioProducer.putOneDataPoint(x);
                }
                ++s_double;
                if (--i2 == 0) {
                    this.p1 += inc;
                    k = 0;
                    while (k < m) {
                        int n = k;
                        this.C[n] = this.C[n] + this.CINC[k];
                        ++k;
                    }
                    i2 = 1;
                }
                --j;
            }
            this.p1 = f0;
            System.arraycopy(this.CC, 0, this.C, 0, m);
            ++mcepframe;
        }
        logger.debug((Object)("Finish processing " + mcepframe + " mcep frames."));
        return audio_double;
    }

    private int computeAudioSize(HTSPStream mcepPst, HMMData htsData) {
        return mcepPst.getT() * htsData.getFperiod();
    }

    private void printVector(String val, int m, double[] vec) {
        System.out.println(val);
        int i = 0;
        while (i < m) {
            System.out.println("v[" + i + "]=" + vec[i]);
            ++i;
        }
    }

    private static double mlsafir(double x, double[] b, int m, double a, double[] d, int _pt3) {
        d[_pt3 + 0] = x;
        d[_pt3 + 1] = (1.0 - a * a) * d[_pt3 + 0] + a * d[_pt3 + 1];
        int i = 2;
        while (i <= m) {
            int n = _pt3 + i;
            d[n] = d[n] + a * (d[_pt3 + i + 1] - d[_pt3 + i - 1]);
            ++i;
        }
        double y = 0.0;
        int i2 = 2;
        while (i2 <= m) {
            y += d[_pt3 + i2] * b[i2];
            ++i2;
        }
        i2 = m + 1;
        while (i2 > 1) {
            d[_pt3 + i2] = d[_pt3 + i2 - 1];
            --i2;
        }
        return y;
    }

    private static double mlsadf1(double x, double[] b, int m, double a, double[] d) {
        double out = 0.0;
        int i = 5;
        while (i > 0) {
            d[i] = (1.0 - a * a) * d[5 + i] + a * d[i];
            d[6 + i] = d[i] * b[1];
            double v = d[6 + i] * pade[15 + i];
            x += (1 & i) == 1 ? v : -v;
            out += v;
            --i;
        }
        d[6] = x;
        return out += x;
    }

    private static double mlsadf2(double x, double[] b, int m, double a, double[] d, int pt2, int[] pt3) {
        double out = 0.0;
        int i = 5;
        while (i > 0) {
            int pt2_plus_i = pt2 + i;
            d[pt2_plus_i] = HTSVocoder.mlsafir(d[pt2_plus_i - 1], b, m, a, d, pt3[i]);
            double v = d[pt2_plus_i] * pade[15 + i];
            x += (1 & i) == 1 ? v : -v;
            out += v;
            --i;
        }
        d[pt2] = x;
        return out += x;
    }

    public static double mlsadf(double x, double[] b, int m, double a, double[] d, int pt2, int[] pt3) {
        x = HTSVocoder.mlsadf1(x, b, m, a, d);
        x = HTSVocoder.mlsadf2(x, b, m - 1, a, d, pt2, pt3);
        return x;
    }

    public double uniformRand() {
        return this.rand.nextBoolean() ? 1.0 : -1.0;
    }

    public static void mc2b(double[] mc, double[] b, int m, double a) {
        b[m] = mc[m];
        --m;
        while (m >= 0) {
            b[m] = mc[m] - a * b[m + 1];
            --m;
        }
    }

    public static void b2mc(double[] b, double[] mc, int m, double a) {
        double d = mc[m] = b[m];
        int i = m--;
        while (i >= 0) {
            double o = b[i] + a * d;
            d = b[i];
            mc[i] = o;
            --i;
        }
    }

    public static void freqt(double[] c1, int m1, double[] c2, int m2, double a) {
        double b = 1.0 - a * a;
        double[] freqt_buff = new double[m2 + m2 + 2];
        int g = m2 + 1;
        int i = -m1;
        while (i <= 0) {
            if (m2 >= 0) {
                freqt_buff[0] = freqt_buff[g + 0];
                freqt_buff[g + 0] = c1[-i] + a * freqt_buff[0];
            }
            if (1 <= m2) {
                freqt_buff[1] = freqt_buff[g + 1];
                freqt_buff[g + 1] = b * freqt_buff[0] + a * freqt_buff[1];
            }
            int j = 2;
            while (j <= m2) {
                freqt_buff[j] = freqt_buff[g + j];
                freqt_buff[g + j] = freqt_buff[j - 1] + a * (freqt_buff[j] - freqt_buff[g + j - 1]);
                ++j;
            }
            ++i;
        }
        System.arraycopy(freqt_buff, g, c2, 0, m2);
    }

    public static void c2ir(double[] c, int nc, double[] hh, int leng) {
        hh[0] = Math.exp(c[0]);
        int n = 1;
        while (n < leng) {
            double d = 0.0;
            int upl = n >= nc ? nc - 1 : n;
            int k = 1;
            while (k <= upl) {
                d += (double)k * c[k] * hh[n - k];
                ++k;
            }
            hh[n] = d / (double)n;
            ++n;
        }
    }

    public static double b2en(double[] b, int m, double a) {
        int arrayLength = m + 1 + 192;
        double[] spectrum2en_buff = new double[arrayLength];
        double[] cep = new double[arrayLength];
        double[] ir = new double[arrayLength];
        HTSVocoder.b2mc(b, spectrum2en_buff, m, a);
        HTSVocoder.freqt(spectrum2en_buff, m, cep, 95, -a);
        HTSVocoder.c2ir(cep, 96, ir, 96);
        double en = 0.0;
        int i = 0;
        while (i < 96) {
            en += ir[i] * ir[i];
            ++i;
        }
        return en;
    }

    public static void ignorm(double[] c1, double[] c2, int m, double ng) {
        if (ng != 0.0) {
            double k = Math.pow(c1[0], ng);
            int i = m;
            while (i >= 1) {
                c2[i] = k * c1[i];
                --i;
            }
            c2[0] = (k - 1.0) / ng;
        } else {
            System.arraycopy(c1, 1, c2, 1, m - 1);
            c2[0] = Math.log(c1[0]);
        }
    }

    public static void gnorm(double[] c1, double[] c2, int m, double g) {
        if (g != 0.0) {
            double k = 1.0 + g * c1[0];
            while (m >= 1) {
                c2[m] = c1[m] / k;
                --m;
            }
            c2[0] = Math.pow(k, 1.0 / g);
        } else {
            System.arraycopy(c1, 1, c2, 1, m - 1);
            c2[0] = Math.exp(c1[0]);
        }
    }

    public static void lsp2lpc(double[] lsp, double[] a, int m) {
        int mh1;
        int mh2;
        boolean flag_odd = false;
        if (m % 2 == 0) {
            mh1 = mh2 = m / 2;
        } else {
            mh1 = (m + 1) / 2;
            mh2 = (m - 1) / 2;
            flag_odd = true;
        }
        double[] lsp2lpc_buff = new double[5 * m + 6];
        int p = m;
        int q = p + mh1;
        int a0 = q + mh2;
        int a1 = a0 + (mh1 + 1);
        int a2 = a1 + (mh1 + 1);
        int b0 = a2 + (mh1 + 1);
        int b1 = b0 + (mh2 + 1);
        int b2 = b1 + (mh2 + 1);
        System.arraycopy(lsp, 1, lsp2lpc_buff, 0, m);
        int i = 0;
        while (i < mh1 + 1) {
            lsp2lpc_buff[a0 + i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < mh1 + 1) {
            lsp2lpc_buff[a1 + i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < mh1 + 1) {
            lsp2lpc_buff[a2 + i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < mh2 + 1) {
            lsp2lpc_buff[b0 + i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < mh2 + 1) {
            lsp2lpc_buff[b1 + i] = 0.0;
            ++i;
        }
        i = 0;
        while (i < mh2 + 1) {
            lsp2lpc_buff[b2 + i] = 0.0;
            ++i;
        }
        int k = 0;
        i = 0;
        while (i < mh1) {
            lsp2lpc_buff[p + i] = -2.0 * Math.cos(lsp2lpc_buff[k]);
            ++i;
            k += 2;
        }
        k = 0;
        i = 0;
        while (i < mh2) {
            lsp2lpc_buff[q + i] = -2.0 * Math.cos(lsp2lpc_buff[k + 1]);
            ++i;
            k += 2;
        }
        double xx = 1.0;
        double xff = 0.0;
        double xf = 0.0;
        k = 0;
        while (k <= m) {
            if (flag_odd) {
                lsp2lpc_buff[a0 + 0] = xx;
                lsp2lpc_buff[b0 + 0] = xx - xff;
                xff = xf;
                xf = xx;
            } else {
                lsp2lpc_buff[a0 + 0] = xx + xf;
                lsp2lpc_buff[b0 + 0] = xx - xf;
                xf = xx;
            }
            i = 0;
            while (i < mh1) {
                lsp2lpc_buff[a0 + i + 1] = lsp2lpc_buff[a0 + i] + lsp2lpc_buff[p + i] * lsp2lpc_buff[a1 + i] + lsp2lpc_buff[a2 + i];
                lsp2lpc_buff[a2 + i] = lsp2lpc_buff[a1 + i];
                lsp2lpc_buff[a1 + i] = lsp2lpc_buff[a0 + i];
                ++i;
            }
            i = 0;
            while (i < mh2) {
                lsp2lpc_buff[b0 + i + 1] = lsp2lpc_buff[b0 + i] + lsp2lpc_buff[q + i] * lsp2lpc_buff[b1 + i] + lsp2lpc_buff[b2 + i];
                lsp2lpc_buff[b2 + i] = lsp2lpc_buff[b1 + i];
                lsp2lpc_buff[b1 + i] = lsp2lpc_buff[b0 + i];
                ++i;
            }
            if (k != 0) {
                a[k - 1] = -0.5 * (lsp2lpc_buff[a0 + mh1] + lsp2lpc_buff[b0 + mh2]);
            }
            xx = 0.0;
            ++k;
        }
        i = m - 1;
        while (i >= 0) {
            a[i + 1] = -a[i];
            --i;
        }
        a[0] = 1.0;
    }

    public static void gc2gc(double[] c1, int m1, double g1, double[] c2, int m2, double g2) {
        double[] gc2gc_buff = Arrays.copyOf(c1, m1 + 1);
        c2[0] = gc2gc_buff[0];
        int i = 1;
        while (i <= m2) {
            double ss1 = 0.0;
            double ss2 = 0.0;
            int min = m1 < i ? m1 : i - 1;
            int k = 1;
            while (k <= min) {
                int mk = i - k;
                double cc = gc2gc_buff[k] * c2[mk];
                ss2 += (double)k * cc;
                ss1 += (double)mk * cc;
                ++k;
            }
            c2[i] = i <= m1 ? gc2gc_buff[i] + (g2 * ss2 - g1 * ss1) / (double)i : (g2 * ss2 - g1 * ss1) / (double)i;
            ++i;
        }
    }

    public static void mgc2mgc(double[] c1, int m1, double a1, double g1, double[] c2, int m2, double a2, double g2) {
        if (a1 == a2) {
            HTSVocoder.gnorm(c1, c1, m1, g1);
            HTSVocoder.gc2gc(c1, m1, g1, c2, m2, g2);
            HTSVocoder.ignorm(c2, c2, m2, g2);
        } else {
            double a = (a2 - a1) / (1.0 - a1 * a2);
            HTSVocoder.freqt(c1, m1, c2, m2, a);
            HTSVocoder.gnorm(c2, c2, m2, g1);
            HTSVocoder.gc2gc(c2, m2, g1, c2, m2, g2);
            HTSVocoder.ignorm(c2, c2, m2, g2);
        }
    }

    public void lsp2mgc(double[] lsp, double[] mgc, int m, double alpha) {
        HTSVocoder.lsp2lpc(lsp, mgc, m);
        mgc[0] = this.use_log_gain ? Math.exp(lsp[0]) : lsp[0];
        HTSVocoder.ignorm(mgc, mgc, m, this.gamma);
        int i = m;
        while (i >= 1) {
            int n = i--;
            mgc[n] = mgc[n] * (double)(-this.stage);
        }
        HTSVocoder.mgc2mgc(mgc, m, alpha, this.gamma, mgc, m, alpha, this.gamma);
    }

    public static double mglsadf(double x, double[] b, int m, double a, int n, double[] d) {
        int i = 0;
        while (i < n) {
            x = HTSVocoder.mglsadff(x, b, m, a, d, i * (m + 1));
            ++i;
        }
        return x;
    }

    private static double mglsadff(double x, double[] b, int m, double a, double[] d, int d_offset) {
        double y = d[d_offset + 0] * b[1];
        int i = 1;
        while (i < m) {
            int n = d_offset + i;
            d[n] = d[n] + a * (d[d_offset + i + 1] - d[d_offset + i - 1]);
            y += d[d_offset + i] * b[i + 1];
            ++i;
        }
        x -= y;
        i = m;
        while (i > 0) {
            d[d_offset + i] = d[d_offset + i - 1];
            --i;
        }
        d[d_offset + 0] = a * d[d_offset + 0] + (1.0 - a * a) * x;
        return x;
    }

    public static void postfilter_mgc(double[] mgc, int m, double alpha, double beta) {
        if (beta > 0.0 && m > 1) {
            double[] postfilter_buff = new double[m + 1];
            HTSVocoder.mc2b(mgc, postfilter_buff, m, alpha);
            double e1 = HTSVocoder.b2en(postfilter_buff, m, alpha);
            postfilter_buff[1] = postfilter_buff[1] - beta * alpha * mgc[2];
            int k = 2;
            while (k < m) {
                int n = k++;
                postfilter_buff[n] = postfilter_buff[n] * (1.0 + beta);
            }
            double e2 = HTSVocoder.b2en(postfilter_buff, m, alpha);
            postfilter_buff[0] = postfilter_buff[0] + Math.log(e1 / e2) / 2.0;
            HTSVocoder.b2mc(postfilter_buff, mgc, m, alpha);
        }
    }

    public static double[] genPulseFromFourierMag(HTSPStream mag, int n, double f0) {
        return HTSVocoder.genPulseFromFourierMag(mag.getParVec(n), f0);
    }

    public static double[] genPulseFromFourierMag(double[] mag, double f0) {
        int numHarm = mag.length;
        int currentF0 = (int)Math.round(f0);
        int T = currentF0 < 512 ? 512 : 1024;
        int T2 = 2 * T;
        double[] pulse = new double[T];
        double[] real = new double[T2];
        double[] imag = new double[T2];
        real[T] = 0.0;
        real[0] = 0.0;
        int i = 1;
        while (i <= numHarm) {
            double d = mag[i - 1];
            real[T2 - i] = d;
            real[T + i] = d;
            real[T - i] = d;
            real[i] = d;
            imag[T2 - i] = 0.0;
            imag[T + i] = 0.0;
            imag[T - i] = 0.0;
            imag[i] = 0.0;
            ++i;
        }
        i = numHarm + 1;
        while (i < T - numHarm) {
            real[T2 - i] = 1.0;
            real[T + i] = 1.0;
            real[T - i] = 1.0;
            real[i] = 1.0;
            imag[T2 - i] = 0.0;
            imag[T + i] = 0.0;
            imag[T - i] = 0.0;
            imag[i] = 0.0;
            ++i;
        }
        FFT.transform((double[])real, (double[])imag, (boolean)true);
        double sqrt_f0 = Math.sqrt(currentF0);
        int i2 = 0;
        while (i2 < T) {
            pulse[i2] = real[(i2 - numHarm) % T] * sqrt_f0;
            ++i2;
        }
        return pulse;
    }

    private void circularShift(double[] y, int T, int n) {
        double[] x = new double[T];
        int i = 0;
        while (i < T) {
            x[i] = y[this.modShift(i - n, T)];
            ++i;
        }
        i = 0;
        while (i < T) {
            y[i] = x[i];
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private int modShift(int n, int N) {
        block2: {
            if (n >= 0) ** GOTO lbl7
            while (n < 0) {
                n += N;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                n -= N;
lbl7:
                // 2 sources

                ** while (n >= N)
            }
        }
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public static void main1(String[] args) throws IOException, InterruptedException, Exception {
        htsData = new HMMData();
        voiced = null;
        MaryBase = "/project/mary/marcela/openmary/";
        outDir = "/project/mary/marcela/openmary/tmp/";
        outFile = String.valueOf(outDir) + "tmp.wav";
        voiceName = "hsmm-ot";
        voiceConfig = "tr-hsmm-ot.config";
        voiceExample = "ot0010";
        hmmTrainDir = "/project/mary/marcela/HMM-voices/turkish/";
        htsData.initHMMData(voiceName, MaryBase, voiceConfig);
        htsData.setUseMixExc(true);
        htsData.setUseFourierMag(true);
        lf0File = String.valueOf(hmmTrainDir) + "data/lf0/" + voiceExample + ".lf0";
        mcepFile = String.valueOf(hmmTrainDir) + "data/mgc/" + voiceExample + ".mgc";
        strFile = String.valueOf(hmmTrainDir) + "data/str/" + voiceExample + ".str";
        magFile = String.valueOf(hmmTrainDir) + "data/mag/" + voiceExample + ".mag";
        mcepVsize = htsData.getCartTreeSet().getMcepVsize();
        strVsize = htsData.getCartTreeSet().getStrVsize();
        lf0Vsize = htsData.getCartTreeSet().getLf0Stream();
        magVsize = htsData.getCartTreeSet().getMagVsize();
        totalFrame = 0;
        lf0VoicedFrame = 0;
        lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0File)));
        try {
            while (true) {
                fval = lf0Data.readFloat();
                ++totalFrame;
                if (!(fval > 0.0f)) continue;
                ++lf0VoicedFrame;
            }
        }
        catch (EOFException v0) {
            lf0Data.close();
            System.out.println("Total number of Frames = " + (totalFrame -= 2));
            voiced = new boolean[totalFrame];
            lf0Pst = new HTSPStream(lf0Vsize, totalFrame, HMMData.FeatureType.LF0, 0);
            mcepPst = new HTSPStream(mcepVsize, totalFrame, HMMData.FeatureType.MGC, 0);
            strPst = new HTSPStream(strVsize, totalFrame, HMMData.FeatureType.STR, 0);
            magPst = new HTSPStream(magVsize, totalFrame, HMMData.FeatureType.MAG, 0);
            lf0VoicedFrame = 0;
            lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0File)));
            i = 0;
            ** while (i < totalFrame)
        }
lbl-1000:
        // 1 sources

        {
            fval = lf0Data.readFloat();
            if (fval < 0.0f) {
                voiced[i] = false;
            } else {
                voiced[i] = true;
                lf0Pst.setPar(lf0VoicedFrame, 0, fval);
                ++lf0VoicedFrame;
            }
            ++i;
            continue;
        }
lbl52:
        // 1 sources

        lf0Data.close();
        mcepData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(mcepFile)));
        i = 0;
        while (i < totalFrame) {
            j = 0;
            while (j < mcepPst.getOrder()) {
                mcepPst.setPar(i, j, mcepData.readFloat());
                ++j;
            }
            ++i;
        }
        mcepData.close();
        strData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(strFile)));
        i = 0;
        while (i < totalFrame) {
            j = 0;
            while (j < strPst.getOrder()) {
                strPst.setPar(i, j, strData.readFloat());
                ++j;
            }
            ++i;
        }
        strData.close();
        magData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(magFile)));
        i = 0;
        while (i < totalFrame) {
            j = 0;
            while (j < magPst.getOrder()) {
                magPst.setPar(i, j, magData.readFloat());
                ++j;
            }
            ++i;
        }
        magData.close();
        af = HTSVocoder.getHTSAudioFormat(htsData);
        audio_double = null;
        par2speech = new HTSVocoder();
        audio_double = par2speech.htsMLSAVocoder(lf0Pst, mcepPst, strPst, magPst, voiced, htsData, null);
        lengthInSamples = audio_double.length * 2 / (af.getSampleSizeInBits() / 8);
        HTSVocoder.logger.debug((Object)("length in samples=" + lengthInSamples));
        MaxSample = MathUtils.getAbsMax((double[])audio_double);
        i = 0;
        while (i < audio_double.length) {
            audio_double[i] = 0.3 * (audio_double[i] / MaxSample);
            ++i;
        }
        oais = new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource(audio_double), af);
        fileOut = new File(outFile);
        System.out.println("saving to file: " + outFile);
        if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, (AudioInputStream)oais)) {
            AudioSystem.write((AudioInputStream)oais, AudioFileFormat.Type.WAVE, fileOut);
        }
        System.out.println("Calling audioplayer:");
        player = new AudioPlayer(fileOut);
        player.start();
        player.join();
        System.out.println("audioplayer finished...");
    }

    public static void htsMLSAVocoderCommand(String[] args) throws IOException, InterruptedException, Exception {
        int j;
        float fval;
        long lengthMag;
        long lengthStr;
        HMMData htsData = new HMMData();
        HTSPStream strPst = null;
        HTSPStream magPst = null;
        boolean[] voiced = null;
        String strFile = "";
        String magFile = "";
        int strVsize = 0;
        int magVsize = 0;
        float f0LoudFemale = 0.01313791f;
        float[] strLoudFemale = new float[]{-0.002995137f, -0.042511884f, 0.072285675f, 0.12703018f, 0.00660317f};
        float[] magLoudFemale = new float[]{0.041733656f, 2.531457E-4f, -0.04368399f, -0.033519227f, -0.021750178f, -0.016627293f, -0.042482533f, -0.046011977f, -0.03071149f, -0.03273694f};
        float[] mcepLoudFemale = new float[]{-0.24540184f, -0.06282596f, -0.3609731f, 0.117120504f, 0.9172233f, 0.13892077f, 0.33855328f, -0.00485714f, 0.285192f, -0.35829273f, -0.06290734f, -0.008040502f, 0.029470561f, -0.48508f, -0.006727651f, -1.3138696f, -0.35379764f, 0.79709774f, -0.1646146f, -0.3111739f, -0.20513453f, -0.478117f, -0.31134018f, -1.4858553f, -0.045632627f};
        float f0SoftFemale = 0.3107256f;
        float[] strSoftFemale = new float[]{0.22054622f, 0.11091616f, 0.06378487f, 0.02110654f, -0.05118725f};
        float[] magSoftFemale = new float[]{0.5747024f, 0.3248238f, 0.2356782f, 0.2441387f, 0.2702851f, 0.2895966f, 0.2437654f, 0.2959747f, 0.2910529f, 0.2508167f};
        float[] mcepSoftFemale = new float[]{-0.10331817f, 0.31569844f, 0.17000097f, 0.22358972f, 0.26213965f, -0.06264676f, -4.9981604f, 0.008026212f, 1.7427409f, 1.9907197f, 0.54817754f, 0.99909383f, 0.26286837f, 1.7550194f, 0.3300586f, -5.2413054f, -0.021005178f, -5.8909426f, 0.3443851f, 0.24217945f, 0.20093668f, -1.6306833f, 0.1106742f, -53.525043f, -0.22368276f};
        float[] fArray = new float[]{0.070929f, 0.4114929f, 0.24479926f, 0.01326785f, -0.01517731f};
        float[] fArray2 = new float[]{-0.2192362f, -0.1103112f, -0.02786084f, -0.10640244f, -0.12020442f, -0.08508762f, -0.08171423f, -0.08000552f, -0.07291968f, -0.09478534f};
        float[] fArray3 = new float[]{0.15335238f, 0.30880293f, -0.22922052f, -0.01116095f, 1.0408835f, -0.3169363f, -19.365107f, -0.12210441f, 0.81743413f, -0.19799408f, 0.44572112f, -0.24845725f, -1.395454f, -0.8878849f, 8.830064f, -1.2662388f, 0.524281f, -1.026157f, -0.28092042f, -0.82543015f, 0.33081815f, 0.39498875f, 0.20100945f, 0.6089079f, -0.37892216f};
        float[] fArray4 = new float[]{0.07595702f, 0.02348965f, -0.02038628f, -0.0857297f, -0.06090386f};
        float[] fArray5 = new float[]{0.08869109f, 0.05517088f, 0.08902098f, 0.09263865f, 0.04866824f, 0.04554406f, 0.04937004f, 0.05082076f, 0.04988959f, 0.0345944f};
        float[] fArray6 = new float[]{0.09812939f, 0.12468682f, 0.195709f, -0.007066379f, -1.7956206f, 0.08998292f, 15.371712f, -0.05102383f, -0.21352194f, 0.009725292f, 0.36148873f, 0.118609995f, 1.7941431f, 0.100130945f, 0.005999542f, -0.5931289f, -0.1653853f, 0.10170568f, 0.17553416f, 0.049246304f, 0.009530379f, -0.27255705f, -0.043030772f, 0.15869488f, 0.09910797f};
        float f0Trans = 0.0f;
        float[] strTrans = null;
        float[] magTrans = null;
        float[] mcepTrans = null;
        int ind = 0;
        htsData.setStage(Integer.parseInt(args[ind++]));
        htsData.setAlpha(Float.parseFloat(args[ind++]));
        if (args[ind++].contentEquals("1")) {
            htsData.setUseLogGain(true);
        } else {
            htsData.setUseLogGain(false);
        }
        htsData.setBeta(Float.parseFloat(args[ind++]));
        htsData.setRate(Integer.parseInt(args[ind++]));
        htsData.setFperiod(Integer.parseInt(args[ind++]));
        String mcepFile = args[ind++];
        int mcepVsize = Integer.parseInt(args[ind++]);
        String lf0File = args[ind++];
        int lf0Vsize = Integer.parseInt(args[ind++]);
        String outFile = args[ind++];
        if (args.length > ind + 1) {
            htsData.setUseMixExc(true);
            strFile = args[ind++];
            strVsize = Integer.parseInt(args[ind++]);
            FileInputStream mixedFiltersStream = new FileInputStream(args[ind++]);
            htsData.setNumFilters(Integer.parseInt(args[ind++]));
            htsData.readMixedExcitationFilters(mixedFiltersStream);
            htsData.setPdfStrStream(null);
        } else {
            htsData.setUseMixExc(false);
        }
        if (args.length > ind + 1) {
            htsData.setUseFourierMag(true);
            magFile = args[ind++];
            magVsize = Integer.parseInt(args[ind++]);
            htsData.setPdfMagStream(null);
        } else {
            htsData.setUseFourierMag(false);
        }
        boolean play = Boolean.parseBoolean(args[ind++]);
        boolean trans = true;
        if (args[ind].contentEquals("loud")) {
            f0Trans = f0LoudFemale;
            strTrans = strLoudFemale;
            magTrans = magLoudFemale;
            mcepTrans = mcepLoudFemale;
            System.out.println("Generating loud voice");
        } else if (args[ind].contentEquals("soft")) {
            f0Trans = f0SoftFemale;
            strTrans = strSoftFemale;
            magTrans = magSoftFemale;
            mcepTrans = mcepSoftFemale;
            System.out.println("Generating soft voice");
        } else {
            trans = false;
            System.out.println("Generating modal voice");
        }
        htsData.setF0Std(1.0);
        htsData.setF0Mean(0.0);
        int totalFrame = 0;
        int lf0VoicedFrame = 0;
        LEDataInputStream lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0File)));
        File lf0 = new File(lf0File);
        long lengthLf0 = lf0.length();
        lengthLf0 /= (long)(lf0Vsize / 3 * 4);
        File mcep = new File(mcepFile);
        long lengthMcep = mcep.length();
        lengthMcep /= (long)(mcepVsize / 3 * 4);
        int numSize = 2;
        if (htsData.getUseMixExc()) {
            File str = new File(strFile);
            lengthStr = str.length();
            lengthStr /= (long)(strVsize / 3 * 4);
            ++numSize;
        } else {
            lengthStr = 0L;
        }
        if (htsData.getUseFourierMag()) {
            File mag = new File(magFile);
            lengthMag = mag.length();
            lengthMag /= (long)(magVsize / 3 * 4);
            ++numSize;
        } else {
            lengthMag = 0L;
        }
        float[] sizes = new float[numSize];
        int n = 0;
        sizes[n++] = lengthMcep;
        sizes[n++] = lengthLf0;
        if (lengthStr > 0L) {
            sizes[n++] = lengthStr;
        }
        if (lengthMag > 0L) {
            sizes[n++] = lengthMag;
        }
        totalFrame = (int)MathUtils.getMin((float[])sizes);
        System.out.println("Total number of Frames = " + totalFrame);
        voiced = new boolean[totalFrame];
        HTSPStream lf0Pst = new HTSPStream(lf0Vsize, totalFrame, HMMData.FeatureType.LF0, 0);
        HTSPStream mcepPst = new HTSPStream(mcepVsize, totalFrame, HMMData.FeatureType.MGC, 0);
        lf0VoicedFrame = 0;
        lf0Data = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(lf0File)));
        int i = 0;
        while (i < totalFrame) {
            fval = lf0Data.readFloat();
            if (fval < 0.0f) {
                voiced[i] = false;
            } else {
                voiced[i] = true;
                if (trans) {
                    fval = (float)Math.exp(fval);
                    fval += fval * f0Trans;
                    fval = (float)Math.log(fval);
                }
                lf0Pst.setPar(lf0VoicedFrame, 0, fval);
                ++lf0VoicedFrame;
            }
            ++i;
        }
        lf0Data.close();
        LEDataInputStream mcepData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(mcepFile)));
        i = 0;
        while (i < totalFrame) {
            j = 0;
            while (j < mcepPst.getOrder()) {
                fval = mcepData.readFloat();
                if (trans & j < 4) {
                    fval += fval * mcepTrans[j];
                }
                mcepPst.setPar(i, j, fval);
                ++j;
            }
            ++i;
        }
        mcepData.close();
        if (htsData.getUseMixExc()) {
            strPst = new HTSPStream(strVsize, totalFrame, HMMData.FeatureType.STR, 0);
            LEDataInputStream strData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(strFile)));
            i = 0;
            while (i < totalFrame) {
                j = 0;
                while (j < strPst.getOrder()) {
                    fval = strData.readFloat();
                    if (trans) {
                        fval += fval * strTrans[j];
                    }
                    strPst.setPar(i, j, fval);
                    ++j;
                }
                ++i;
            }
            strData.close();
        }
        n = 0;
        if (htsData.getUseFourierMag()) {
            magPst = new HTSPStream(magVsize, totalFrame, HMMData.FeatureType.MAG, 0);
            LEDataInputStream magData = new LEDataInputStream((InputStream)new BufferedInputStream(new FileInputStream(magFile)));
            i = 0;
            while (i < totalFrame) {
                j = 0;
                while (j < magPst.getOrder()) {
                    ++n;
                    fval = magData.readFloat();
                    if (trans) {
                        fval += fval * magTrans[j];
                    }
                    magPst.setPar(i, j, fval);
                    ++j;
                }
                ++i;
            }
            magData.close();
        }
        AudioFormat af = HTSVocoder.getHTSAudioFormat(htsData);
        double[] audio_double = null;
        HTSVocoder par2speech = new HTSVocoder();
        audio_double = par2speech.htsMLSAVocoder(lf0Pst, mcepPst, strPst, magPst, voiced, htsData, null);
        long lengthInSamples = audio_double.length * 2 / (af.getSampleSizeInBits() / 8);
        logger.debug((Object)("length in samples=" + lengthInSamples));
        double MaxSample = MathUtils.getAbsMax((double[])audio_double);
        i = 0;
        while (i < audio_double.length) {
            audio_double[i] = audio_double[i] / MaxSample;
            ++i;
        }
        DDSAudioInputStream oais = new DDSAudioInputStream((DoubleDataSource)new BufferedDoubleDataSource(audio_double), af);
        File fileOut = new File(outFile);
        System.out.println("saving to file: " + outFile);
        if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, (AudioInputStream)oais)) {
            AudioSystem.write((AudioInputStream)oais, AudioFileFormat.Type.WAVE, fileOut);
        }
        if (play) {
            System.out.println("Calling audioplayer:");
            AudioPlayer player = new AudioPlayer(fileOut);
            player.start();
            player.join();
            System.out.println("audioplayer finished...");
        }
    }

    public static void main(String[] args) throws IOException, InterruptedException, Exception {
        BasicConfigurator.configure();
    }

    public static void vocoderList(String[] args) throws IOException, InterruptedException, Exception {
        String path = "/project/mary/marcela/quality_parameters/necadbs/hts/data/";
        File outDir = new File(String.valueOf(path) + "vocoder");
        if (!outDir.exists()) {
            outDir.mkdir();
        }
        File directory = new File(String.valueOf(path) + "raw");
        String[] files = FileUtils.listBasenames((File)directory, (String)".raw");
        int i = 0;
        while (i < files.length) {
            System.out.println("file: " + files[i]);
            String[] args1 = new String[]{"0", "0.42", "0.05", "0.15", "16000", "80", String.valueOf(path) + "mgc/" + files[i] + ".mgc", "75", String.valueOf(path) + "lf0/" + files[i] + ".lf0", "3", String.valueOf(path) + "vocoder/" + files[i] + ".wav", String.valueOf(path) + "str/" + files[i] + ".str", "15", String.valueOf(path) + "filters/mix_excitation_filters.txt", "5", "true"};
            HTSVocoder.htsMLSAVocoderCommand(args1);
            ++i;
        }
    }

    protected class HTSVocoderDataProducer
    extends ProducingDoubleDataSource {
        private static final double INITIAL_MAX_AMPLITUDE = 17000.0;
        private HTSPStream lf0Pst;
        private HTSPStream mcepPst;
        private HTSPStream strPst;
        private HTSPStream magPst;
        private boolean[] voiced;
        private HMMData htsData;

        public HTSVocoderDataProducer(int audioSize, HTSParameterGeneration pdf2par, HMMData htsData) {
            super((long)audioSize, (InlineDataProcessor)new AmplitudeNormalizer(17000.0));
            this.lf0Pst = pdf2par.getlf0Pst();
            this.mcepPst = pdf2par.getMcepPst();
            this.strPst = pdf2par.getStrPst();
            this.magPst = pdf2par.getMagPst();
            this.voiced = pdf2par.getVoicedArray();
            this.htsData = htsData;
        }

        public void run() {
            try {
                HTSVocoder.this.htsMLSAVocoder(this.lf0Pst, this.mcepPst, this.strPst, this.magPst, this.voiced, this.htsData, this);
                this.putEndOfStream();
            }
            catch (Exception e) {
                logger.error((Object)"Cannot vocode", (Throwable)e);
            }
        }
    }
}

