/*
 * Decompiled with CFR 0.152.
 */
package marytts.server.http;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import marytts.server.MaryProperties;
import marytts.server.http.FileRequestHandler;
import marytts.server.http.InfoRequestHandler;
import marytts.server.http.SynthesisRequestHandler;
import marytts.util.MaryUtils;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.nio.DefaultServerIOEventDispatch;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.NHttpServiceHandler;
import org.apache.http.nio.protocol.BufferingHttpServiceHandler;
import org.apache.http.nio.protocol.EventListener;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.HttpRequestHandlerRegistry;
import org.apache.http.protocol.HttpRequestHandlerResolver;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.log4j.Logger;

public class MaryHttpServer
extends Thread {
    private static Logger logger;
    private boolean isReady = false;

    public MaryHttpServer() {
        logger = MaryUtils.getLogger((String)"server");
    }

    public boolean isReady() {
        return this.isReady;
    }

    @Override
    public void run() {
        logger.info((Object)"Starting server.");
        int localPort = MaryProperties.needInteger("socket.port");
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 0).setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)"HttpComponents/1.1");
        BasicHttpProcessor httpproc = new BasicHttpProcessor();
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpproc.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        BufferingHttpServiceHandler handler = new BufferingHttpServiceHandler((HttpProcessor)httpproc, (HttpResponseFactory)new DefaultHttpResponseFactory(), (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpParams)params);
        HttpRequestHandlerRegistry registry = new HttpRequestHandlerRegistry();
        registry.register("/process", (HttpRequestHandler)new SynthesisRequestHandler());
        InfoRequestHandler infoRH = new InfoRequestHandler();
        registry.register("/version", (HttpRequestHandler)infoRH);
        registry.register("/datatypes", (HttpRequestHandler)infoRH);
        registry.register("/locales", (HttpRequestHandler)infoRH);
        registry.register("/voices", (HttpRequestHandler)infoRH);
        registry.register("/audioformats", (HttpRequestHandler)infoRH);
        registry.register("/exampletext", (HttpRequestHandler)infoRH);
        registry.register("/audioeffects", (HttpRequestHandler)infoRH);
        registry.register("/audioeffect-default-param", (HttpRequestHandler)infoRH);
        registry.register("/audioeffect-full", (HttpRequestHandler)infoRH);
        registry.register("/audioeffect-help", (HttpRequestHandler)infoRH);
        registry.register("/audioeffect-is-hmm-effect", (HttpRequestHandler)infoRH);
        registry.register("/features", (HttpRequestHandler)infoRH);
        registry.register("/features-discrete", (HttpRequestHandler)infoRH);
        registry.register("/vocalizations", (HttpRequestHandler)infoRH);
        registry.register("/styles", (HttpRequestHandler)infoRH);
        registry.register("*", (HttpRequestHandler)new FileRequestHandler());
        handler.setHandlerResolver((HttpRequestHandlerResolver)registry);
        handler.setEventListener((EventListener)new EventLogger());
        DefaultServerIOEventDispatch ioEventDispatch = new DefaultServerIOEventDispatch((NHttpServiceHandler)handler, (HttpParams)params);
        int numParallelThreads = MaryProperties.getInteger("server.http.parallelthreads", 5);
        logger.info((Object)("Waiting for client to connect on port " + localPort));
        try {
            DefaultListeningIOReactor ioReactor = new DefaultListeningIOReactor(numParallelThreads, (HttpParams)params);
            ioReactor.listen((SocketAddress)new InetSocketAddress(localPort));
            this.isReady = true;
            ioReactor.execute((IOEventDispatch)ioEventDispatch);
        }
        catch (InterruptedIOException ex) {
            logger.info((Object)"Interrupted", (Throwable)ex);
        }
        catch (IOException e) {
            logger.info((Object)"Problem with HTTP connection", (Throwable)e);
        }
        logger.debug((Object)"Shutdown");
    }

    static class EventLogger
    implements EventListener {
        EventLogger() {
        }

        public void connectionOpen(NHttpConnection conn) {
            logger.info((Object)("Connection from " + conn.getContext().getAttribute("http.target_host")));
        }

        public void connectionTimeout(NHttpConnection conn) {
            logger.info((Object)("Connection timed out: " + conn));
        }

        public void connectionClosed(NHttpConnection conn) {
            logger.info((Object)("Connection closed: " + conn));
        }

        public void fatalIOException(IOException ex, NHttpConnection conn) {
            logger.info((Object)("I/O error: " + ex.getMessage()));
        }

        public void fatalProtocolException(HttpException ex, NHttpConnection conn) {
            logger.info((Object)("HTTP error: " + ex.getMessage()));
        }
    }
}

