/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.net.URL;
import java.util.SortedSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import marytts.tools.install.ComponentDescription;
import org.jdesktop.layout.GroupLayout;

public class LicensePanel
extends JPanel {
    private JScrollPane jScrollPane1;
    private JTextPane licenseTextPane;
    private JLabel questionText;

    public LicensePanel(URL licenseURL, SortedSet<ComponentDescription> comps) {
        this.initComponents();
        StringBuilder sb = new StringBuilder();
        boolean isSingle = comps.size() == 1;
        sb.append("The component");
        if (isSingle) {
            sb.append("s");
        }
        sb.append(":\n");
        boolean isFirst = true;
        for (ComponentDescription cd : comps) {
            if (!isFirst) {
                sb.append(", ");
            }
            sb.append(cd.getName());
            isFirst = false;
        }
        sb.append("\n");
        sb.append(isSingle ? "is" : "are");
        sb.append(" governed by the following license.");
        this.questionText.setText(sb.toString());
        try {
            this.licenseTextPane.setPage(licenseURL);
        }
        catch (IOException ioe) {
            this.licenseTextPane.setText("Unknown license -- only proceed if you are certain you have the right to install these components!");
            ioe.printStackTrace();
        }
    }

    private void initComponents() {
        this.questionText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.licenseTextPane = new JTextPane();
        this.jScrollPane1.setViewportView(this.licenseTextPane);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 462, Short.MAX_VALUE).add(1, (Component)this.questionText, -1, 462, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.questionText, -2, 58, -2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 460, Short.MAX_VALUE).addContainerGap()));
    }
}

