/*
 * Decompiled with CFR 0.152.
 */
package marytts.unitselection.select;

import marytts.features.FeatureDefinition;
import marytts.features.FeatureVector;
import marytts.unitselection.data.Unit;
import marytts.unitselection.select.FFRTargetCostFunction;
import marytts.unitselection.select.Target;
import marytts.unitselection.weightingfunctions.WeightFunc;
import marytts.unitselection.weightingfunctions.WeightFunctionManager;
import marytts.vocalizations.VocalizationFeatureFileReader;

public class VocalizationFFRTargetCostFunction
extends FFRTargetCostFunction {
    private int MEANING_RATING_RANGE = 5;

    public VocalizationFFRTargetCostFunction(VocalizationFeatureFileReader ffr) {
        this(ffr, ffr.getFeatureDefinition());
    }

    public VocalizationFFRTargetCostFunction(VocalizationFeatureFileReader ffr, FeatureDefinition fDef) {
        this.load(ffr, fDef);
    }

    private void load(VocalizationFeatureFileReader ffr, FeatureDefinition fDef) {
        this.featureVectors = ffr.featureVectorMapping(fDef);
        this.featureDefinition = fDef;
        this.weightFunction = new WeightFunc[this.featureDefinition.getNumberOfContinuousFeatures()];
        WeightFunctionManager wfm = new WeightFunctionManager();
        int nDiscreteFeatures = this.featureDefinition.getNumberOfByteFeatures() + this.featureDefinition.getNumberOfShortFeatures();
        int i = 0;
        while (i < this.weightFunction.length) {
            String weightFunctionName = this.featureDefinition.getWeightFunctionName(nDiscreteFeatures + i);
            this.weightFunction[i] = "".equals(weightFunctionName) ? wfm.getWeightFunction("linear") : wfm.getWeightFunction(weightFunctionName);
            ++i;
        }
        this.rememberWhichWeightsAreNonZero();
    }

    @Override
    protected double cost(Target target, Unit unit, FeatureDefinition weights, WeightFunc[] weightFunctions) {
        int i;
        ++this.nCostComputations;
        FeatureVector targetFeatures = target.getFeatureVector();
        assert (targetFeatures != null) : "Target " + target + " does not have pre-computed feature vector";
        FeatureVector unitFeatures = this.featureVectors[unit.index];
        int nBytes = targetFeatures.byteValuedDiscreteFeatures.length;
        int nShorts = targetFeatures.shortValuedDiscreteFeatures.length;
        int nFloats = targetFeatures.continuousFeatures.length;
        assert (nBytes == unitFeatures.byteValuedDiscreteFeatures.length);
        assert (nShorts == unitFeatures.shortValuedDiscreteFeatures.length);
        assert (nFloats == unitFeatures.continuousFeatures.length);
        float[] weightVector = weights.getFeatureWeights();
        double cost = 0.0;
        if (nBytes > 0) {
            i = 0;
            while (i < nBytes) {
                if (this.weightsNonZero[i]) {
                    float weight = weightVector[i];
                    if (this.featureDefinition.hasSimilarityMatrix(i)) {
                        byte targetFeatValueIndex = targetFeatures.byteValuedDiscreteFeatures[i];
                        byte unitFeatValueIndex = unitFeatures.byteValuedDiscreteFeatures[i];
                        float similarity = this.featureDefinition.getSimilarity(i, unitFeatValueIndex, targetFeatValueIndex);
                        cost += (double)(similarity * weight);
                        if (this.debugShowCostGraph) {
                            int n = i;
                            this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)(similarity * weight);
                        }
                    } else if (targetFeatures.byteValuedDiscreteFeatures[i] != unitFeatures.byteValuedDiscreteFeatures[i]) {
                        cost += (double)weight;
                        if (this.debugShowCostGraph) {
                            int n = i;
                            this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
                        }
                    }
                }
                ++i;
            }
        }
        if (nShorts > 0) {
            i = nBytes;
            int n = nBytes + nShorts;
            while (i < n) {
                if (this.weightsNonZero[i]) {
                    float weight = weightVector[i];
                    if (targetFeatures.shortValuedDiscreteFeatures[i - nBytes] != unitFeatures.shortValuedDiscreteFeatures[i - nBytes]) {
                        cost += (double)weight;
                        if (this.debugShowCostGraph) {
                            int n2 = i;
                            this.cumulWeightedCosts[n2] = this.cumulWeightedCosts[n2] + (double)weight;
                        }
                    }
                }
                ++i;
            }
        }
        if (nFloats > 0) {
            int nDiscrete;
            int i2 = nDiscrete = nBytes + nShorts;
            int n = nDiscrete + nFloats;
            while (i2 < n) {
                if (this.weightsNonZero[i2]) {
                    float weight = weightVector[i2];
                    float a = targetFeatures.continuousFeatures[i2 - nDiscrete];
                    float b = unitFeatures.continuousFeatures[i2 - nDiscrete];
                    if (a == a) {
                        double myCost = b == b ? weightFunctions[i2 - nDiscrete].cost(a, b) : (double)this.MEANING_RATING_RANGE;
                        cost += (double)weight * myCost;
                        if (this.debugShowCostGraph) {
                            int n3 = i2;
                            this.cumulWeightedCosts[n3] = this.cumulWeightedCosts[n3] + (double)weight * myCost;
                        }
                    }
                }
                ++i2;
            }
        }
        return cost;
    }

    @Override
    protected double featureCost(Target target, Unit unit, String featureName, FeatureDefinition weights, WeightFunc[] weightFunctions) {
        if (!this.featureDefinition.hasFeature(featureName)) {
            throw new IllegalArgumentException("this feature does not exists in feature definition");
        }
        FeatureVector targetFeatures = target.getFeatureVector();
        assert (targetFeatures != null) : "Target " + target + " does not have pre-computed feature vector";
        FeatureVector unitFeatures = this.featureVectors[unit.index];
        int nBytes = targetFeatures.byteValuedDiscreteFeatures.length;
        int nShorts = targetFeatures.shortValuedDiscreteFeatures.length;
        int nFloats = targetFeatures.continuousFeatures.length;
        assert (nBytes == unitFeatures.byteValuedDiscreteFeatures.length);
        assert (nShorts == unitFeatures.shortValuedDiscreteFeatures.length);
        assert (nFloats == unitFeatures.continuousFeatures.length);
        int featureIndex = this.featureDefinition.getFeatureIndex(featureName);
        float[] weightVector = weights.getFeatureWeights();
        double cost = 0.0;
        if (featureIndex < nBytes) {
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                if (this.featureDefinition.hasSimilarityMatrix(featureIndex)) {
                    byte targetFeatValueIndex = targetFeatures.byteValuedDiscreteFeatures[featureIndex];
                    byte unitFeatValueIndex = unitFeatures.byteValuedDiscreteFeatures[featureIndex];
                    float similarity = this.featureDefinition.getSimilarity(featureIndex, unitFeatValueIndex, targetFeatValueIndex);
                    cost = similarity * weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)(similarity * weight);
                    }
                } else if (targetFeatures.byteValuedDiscreteFeatures[featureIndex] != unitFeatures.byteValuedDiscreteFeatures[featureIndex]) {
                    cost = weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
                    }
                }
            }
        } else if (featureIndex < nShorts + nBytes) {
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                if (targetFeatures.shortValuedDiscreteFeatures[featureIndex - nBytes] != unitFeatures.shortValuedDiscreteFeatures[featureIndex - nBytes]) {
                    cost = weight;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight;
                    }
                }
            }
        } else {
            int nDiscrete = nBytes + nShorts;
            if (this.weightsNonZero[featureIndex]) {
                float weight = weightVector[featureIndex];
                float a = targetFeatures.continuousFeatures[featureIndex - nDiscrete];
                float b = unitFeatures.continuousFeatures[featureIndex - nDiscrete];
                if (a == a) {
                    double myCost = b == b ? weightFunctions[featureIndex - nDiscrete].cost(a, b) : (double)this.MEANING_RATING_RANGE;
                    cost = (double)weight * myCost;
                    if (this.debugShowCostGraph) {
                        int n = featureIndex;
                        this.cumulWeightedCosts[n] = this.cumulWeightedCosts[n] + (double)weight * myCost;
                    }
                }
            }
        }
        return cost;
    }
}

