/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.gmm.jointgmm;

import java.util.Arrays;
import marytts.signalproc.adaptation.gmm.GMMMapper;
import marytts.signalproc.adaptation.gmm.GMMMatch;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMM;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMatch;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMSet;
import marytts.util.math.MathUtils;

public class JointGMMMapper
extends GMMMapper {
    public GMMMatch transform(double[] inputLsfs, JointGMMSet jointGMMSet, double[] weights, boolean isVocalTractMatchUsingTargetModel) {
        JointGMMMatch jointGMMMatch = new JointGMMMatch(inputLsfs.length);
        JointGMMMatch tmpGMMMatch = new JointGMMMatch(inputLsfs.length);
        Arrays.fill(jointGMMMatch.mappedSourceFeatures, 0.0);
        Arrays.fill(jointGMMMatch.outputFeatures, 0.0);
        int i = 0;
        while (i < jointGMMSet.gmms.length) {
            if (jointGMMSet.gmms[i] == null) {
                weights[i] = 0.0;
            }
            ++i;
        }
        weights = MathUtils.normalizeToSumUpTo(weights, 1.0);
        i = 0;
        while (i < jointGMMSet.gmms.length) {
            if (jointGMMSet.gmms[i] != null && weights[i] > 0.0) {
                tmpGMMMatch = this.transform(inputLsfs, jointGMMSet.gmms[i], isVocalTractMatchUsingTargetModel);
                int n = 0;
                while (n < inputLsfs.length) {
                    int n2 = n;
                    jointGMMMatch.mappedSourceFeatures[n2] = jointGMMMatch.mappedSourceFeatures[n2] + weights[i] * tmpGMMMatch.mappedSourceFeatures[n];
                    int n3 = n;
                    jointGMMMatch.outputFeatures[n3] = jointGMMMatch.outputFeatures[n3] + weights[i] * tmpGMMMatch.outputFeatures[n];
                    ++n;
                }
            }
            ++i;
        }
        return jointGMMMatch;
    }

    public JointGMMMatch transform(double[] inputLsfs, JointGMM jointGMM, boolean isVocalTractMatchUsingTargetModel) {
        JointGMMMatch jointGMMMatch = new JointGMMMatch(inputLsfs.length);
        double[] h = new double[jointGMM.source.totalComponents];
        double totalP = 0.0;
        int i = 0;
        while (i < jointGMM.source.totalComponents) {
            h[i] = jointGMM.source.components[i].probability(inputLsfs);
            totalP += h[i];
            ++i;
        }
        i = 0;
        while (i < jointGMM.source.totalComponents) {
            h[i] = h[i] / totalP;
            ++i;
        }
        if (jointGMM.covarianceTerms.isDiagonalCovariance) {
            Arrays.fill(jointGMMMatch.mappedSourceFeatures, 0.0);
            Arrays.fill(jointGMMMatch.outputFeatures, 0.0);
            int n = 0;
            while (n < inputLsfs.length) {
                i = 0;
                while (i < jointGMM.source.totalComponents) {
                    int n2 = n;
                    jointGMMMatch.mappedSourceFeatures[n2] = jointGMMMatch.mappedSourceFeatures[n2] + h[i] * jointGMM.source.components[i].meanVector[n];
                    int n3 = n;
                    jointGMMMatch.outputFeatures[n3] = jointGMMMatch.outputFeatures[n3] + h[i] * (jointGMM.targetMeans.components[i].meanVector[n] + jointGMM.covarianceTerms.components[i].covMatrix[0][n] * (inputLsfs[n] - jointGMM.source.components[i].meanVector[n]));
                    ++i;
                }
                ++n;
            }
        } else {
            Arrays.fill(jointGMMMatch.mappedSourceFeatures, 0.0);
            Arrays.fill(jointGMMMatch.outputFeatures, 0.0);
            double[] tmpMappedSourceLsfs = new double[inputLsfs.length];
            double[] tmpOutputLsfs = new double[inputLsfs.length];
            i = 0;
            while (i < jointGMM.source.totalComponents) {
                tmpMappedSourceLsfs = MathUtils.multiply(jointGMM.source.components[i].meanVector, h[i]);
                double[] inputMeanNormalized = MathUtils.subtract(inputLsfs, jointGMM.source.components[i].meanVector);
                double[] covarianceTransformed = MathUtils.matrixProduct(jointGMM.covarianceTerms.components[i].covMatrix, inputMeanNormalized);
                double[] targetMeanAdded = MathUtils.add(jointGMM.targetMeans.components[i].meanVector, covarianceTransformed);
                tmpOutputLsfs = MathUtils.multiply(targetMeanAdded, h[i]);
                int n = 0;
                while (n < inputLsfs.length) {
                    int n4 = n;
                    jointGMMMatch.mappedSourceFeatures[n4] = jointGMMMatch.mappedSourceFeatures[n4] + tmpMappedSourceLsfs[n];
                    int n5 = n;
                    jointGMMMatch.outputFeatures[n5] = jointGMMMatch.outputFeatures[n5] + tmpOutputLsfs[n];
                    ++n;
                }
                ++i;
            }
        }
        return jointGMMMatch;
    }
}

