/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.gmm.jointgmm;

import java.io.IOException;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.adaptation.BaselineAdaptationItem;
import marytts.signalproc.adaptation.BaselineAdaptationSet;
import marytts.signalproc.adaptation.BaselineFeatureExtractor;
import marytts.signalproc.adaptation.BaselinePostprocessor;
import marytts.signalproc.adaptation.BaselinePreprocessor;
import marytts.signalproc.adaptation.BaselineTransformer;
import marytts.signalproc.adaptation.FdpsolaAdapter;
import marytts.signalproc.adaptation.MfccAdapter;
import marytts.signalproc.adaptation.TargetLsfCopyMapper;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMM;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMMapper;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMSet;
import marytts.signalproc.adaptation.gmm.jointgmm.JointGMMTransformerParams;
import marytts.signalproc.adaptation.prosody.PitchMapping;
import marytts.signalproc.adaptation.prosody.PitchMappingFile;
import marytts.signalproc.adaptation.prosody.PitchStatistics;
import marytts.signalproc.adaptation.prosody.PitchTransformationData;
import marytts.signalproc.analysis.LsfFileHeader;
import marytts.signalproc.analysis.MfccFileHeader;
import marytts.util.io.BasenameList;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class JointGMMTransformer
extends BaselineTransformer {
    public JointGMMTransformerParams params;
    public JointGMMMapper mapper;
    public JointGMMSet jointGmmSet;
    private PitchMappingFile pitchMappingFile;
    public PitchMapping pitchMapping;

    public JointGMMTransformer(BaselinePreprocessor pp, BaselineFeatureExtractor fe, BaselinePostprocessor po, JointGMMTransformerParams pa) {
        super(pp, fe, po, pa);
        this.params = new JointGMMTransformerParams(pa);
        this.jointGmmSet = null;
        this.mapper = null;
    }

    @Override
    public boolean checkParams() throws IOException {
        this.params.inputFolder = StringUtils.checkLastSlash((String)this.params.inputFolder);
        this.params.outputBaseFolder = StringUtils.checkLastSlash((String)this.params.outputBaseFolder);
        JointGMM nonNullGmm = null;
        if (!FileUtils.exists((String)this.params.jointGmmFile)) {
            System.out.println("Error: Codebook file " + this.params.jointGmmFile + " not found!");
            return false;
        }
        this.jointGmmSet = new JointGMMSet(this.params.jointGmmFile);
        assert (this.jointGmmSet.gmms != null);
        int i = 0;
        while (i < this.jointGmmSet.gmms.length) {
            if (this.jointGmmSet.gmms[i] != null) {
                nonNullGmm = new JointGMM(this.jointGmmSet.gmms[i]);
                break;
            }
            ++i;
        }
        if (nonNullGmm != null) {
            if (nonNullGmm.featureType == BaselineFeatureExtractor.LSF_FEATURES) {
                this.params.lsfParams = new LsfFileHeader((LsfFileHeader)nonNullGmm.featureParams);
            } else if (nonNullGmm.featureType == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
                this.params.mfccParams = new MfccFileHeader((MfccFileHeader)nonNullGmm.featureParams);
            }
        }
        if (nonNullGmm == null) {
            System.out.println("Error! All GMMs are null in " + this.params.jointGmmFile);
            return false;
        }
        if (!FileUtils.exists((String)this.params.pitchMappingFile)) {
            System.out.println("Error: Pitch mapping file " + this.params.pitchMappingFile + " not found!");
            return false;
        }
        this.pitchMappingFile = new PitchMappingFile(this.params.pitchMappingFile, PitchMappingFile.OPEN_FOR_READ);
        this.pitchMapping = new PitchMapping();
        this.pitchMapping.header = this.pitchMappingFile.readPitchMappingHeader();
        if (!FileUtils.exists((String)this.params.inputFolder) || !FileUtils.isDirectory((String)this.params.inputFolder)) {
            System.out.println("Error: Input folder " + this.params.inputFolder + " not found!");
            return false;
        }
        if (!FileUtils.isDirectory((String)this.params.outputBaseFolder)) {
            System.out.println("Creating output base folder " + this.params.outputBaseFolder + "...");
            FileUtils.createDirectory((String)this.params.outputBaseFolder);
        }
        this.params.outputFolder = this.params.outputFolderInfoString != "" ? String.valueOf(this.params.outputBaseFolder) + this.params.outputFolderInfoString + "_mixes" + String.valueOf(nonNullGmm.source.totalComponents) + "_prosody" + String.valueOf(this.params.prosodyParams.pitchStatisticsType) + "x" + String.valueOf(this.params.prosodyParams.pitchTransformationMethod) + "x" + String.valueOf(this.params.prosodyParams.durationTransformationMethod) : String.valueOf(this.params.outputBaseFolder) + "_mixes" + String.valueOf(nonNullGmm.source.totalComponents) + "_prosody" + String.valueOf(this.params.prosodyParams.pitchStatisticsType) + "x" + String.valueOf(this.params.prosodyParams.pitchTransformationMethod) + "x" + String.valueOf(this.params.prosodyParams.durationTransformationMethod);
        if (!FileUtils.isDirectory((String)this.params.outputFolder)) {
            System.out.println("Creating output folder " + this.params.outputFolder + "...");
            FileUtils.createDirectory((String)this.params.outputFolder);
        }
        if (!this.params.isSeparateProsody) {
            this.params.isSaveVocalTractOnlyVersion = false;
        }
        if (this.params.isPitchFromTargetFile) {
            this.params.prosodyParams.pitchTransformationMethod = -10;
        }
        if (this.params.isDurationFromTargetFile) {
            this.params.prosodyParams.durationTransformationMethod = -10;
        }
        if (this.params.isEnergyFromTargetFile) {
            this.params.prosodyParams.energyTransformationMethod = -10;
        }
        if (!this.params.isVocalTractTransformation && !this.params.isLsfsFromTargetFile) {
            this.params.isTemporalSmoothing = false;
        }
        return true;
    }

    public void run() throws IOException, UnsupportedAudioFileException {
        if (this.checkParams()) {
            BaselineAdaptationSet inputSet = this.getInputSet(this.params.inputFolder);
            if (inputSet == null) {
                System.out.println("No input files found in " + this.params.inputFolder);
            } else {
                BaselineAdaptationSet outputSet = this.getOutputSet(inputSet, this.params.outputFolder);
                this.transform(inputSet, outputSet);
            }
        }
    }

    public BaselineAdaptationSet getInputSet(String inputFolder) {
        BasenameList b = new BasenameList(inputFolder, ".wav");
        BaselineAdaptationSet inputSet = new BaselineAdaptationSet(b.getListAsVector().size());
        int i = 0;
        while (i < inputSet.items.length) {
            inputSet.items[i].setFromWavFilename(String.valueOf(inputFolder) + b.getName(i) + ".wav");
            ++i;
        }
        return inputSet;
    }

    public BaselineAdaptationSet getOutputSet(BaselineAdaptationSet inputSet, String outputFolder) {
        BaselineAdaptationSet outputSet = null;
        outputFolder = StringUtils.checkLastSlash((String)outputFolder);
        if (inputSet != null && inputSet.items != null) {
            outputSet = new BaselineAdaptationSet(inputSet.items.length);
            int i = 0;
            while (i < inputSet.items.length) {
                outputSet.items[i].audioFile = String.valueOf(outputFolder) + StringUtils.getFileName((String)inputSet.items[i].audioFile) + "_output" + ".wav";
                outputSet.items[i].rawMfccFile = StringUtils.modifyExtension((String)outputSet.items[i].audioFile, (String)".mgc");
                ++i;
            }
        }
        return outputSet;
    }

    @Override
    public void transform(BaselineAdaptationSet inputSet, BaselineAdaptationSet outputSet) throws UnsupportedAudioFileException {
        System.out.println("Transformation started...");
        if (inputSet.items != null && outputSet.items != null) {
            int numItems = Math.min(inputSet.items.length, outputSet.items.length);
            if (numItems > 0) {
                this.preprocessor.run(inputSet);
                int desiredFeatures = BaselineFeatureExtractor.F0_FEATURES;
                try {
                    this.featureExtractor.run(inputSet, this.params, desiredFeatures);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.pitchMappingFile.readPitchMappingFileExcludingHeader(this.pitchMapping);
            this.mapper = new JointGMMMapper();
            int i = 0;
            while (i < numItems) {
                try {
                    JointGMMTransformer.transformOneItem(inputSet.items[i], outputSet.items[i], this.params, this.mapper, this.jointGmmSet, (PitchTransformationData)this.pitchMapping);
                }
                catch (UnsupportedAudioFileException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                System.out.println("Transformed file " + String.valueOf(i + 1) + " of " + String.valueOf(numItems));
                ++i;
            }
        }
        System.out.println("Transformation completed...");
    }

    public static void transformOneItem(BaselineAdaptationItem inputItem, BaselineAdaptationItem outputItem, JointGMMTransformerParams wctParams, JointGMMMapper jgMapper, JointGMMSet jgSet, PitchTransformationData pMap) throws UnsupportedAudioFileException, IOException {
        TargetLsfCopyMapper tcMapper = new TargetLsfCopyMapper();
        if (jgSet.gmms[0].featureType == BaselineFeatureExtractor.LSF_FEATURES) {
            if (wctParams.isTemporalSmoothing) {
                wctParams.isSeparateProsody = true;
                wctParams.isFixedRateVocalTractConversion = true;
            }
            if (wctParams.isFixedRateVocalTractConversion && (wctParams.prosodyParams.pitchTransformationMethod != 0 || wctParams.prosodyParams.pitchTransformationMethod != -10 || wctParams.prosodyParams.durationTransformationMethod != -10 || wctParams.prosodyParams.energyTransformationMethod != -10)) {
                wctParams.isSeparateProsody = true;
            }
            double[] pscales = new double[]{1.0};
            double[] tscales = new double[]{1.0};
            double[] escales = new double[]{1.0};
            double[] vscales = new double[]{1.0};
            double[] pscalesNone = new double[]{1.0};
            double[] tscalesNone = new double[]{1.0};
            double[] escalesNone = new double[]{1.0};
            double[] vscalesNone = new double[]{1.0};
            FdpsolaAdapter adapter = null;
            JointGMMTransformerParams currentWctParams = new JointGMMTransformerParams(wctParams);
            String firstPassOutputWavFile = "";
            String smoothedVocalTractFile = "";
            if (currentWctParams.isSeparateProsody) {
                firstPassOutputWavFile = String.valueOf(StringUtils.getFolderName((String)outputItem.audioFile)) + StringUtils.getFileName((String)outputItem.audioFile) + "_vt.wav";
                smoothedVocalTractFile = String.valueOf(StringUtils.getFolderName((String)outputItem.audioFile)) + StringUtils.getFileName((String)outputItem.audioFile) + "_vt.vtf";
                int tmpPitchTransformationMethod = currentWctParams.prosodyParams.pitchTransformationMethod;
                int tmpDurationTransformationMethod = currentWctParams.prosodyParams.durationTransformationMethod;
                int tmpEnergyTransformationMethod = currentWctParams.prosodyParams.energyTransformationMethod;
                currentWctParams.prosodyParams.pitchTransformationMethod = 0;
                currentWctParams.prosodyParams.durationTransformationMethod = 0;
                currentWctParams.prosodyParams.energyTransformationMethod = 0;
                boolean tmpPitchFromTargetFile = currentWctParams.isPitchFromTargetFile;
                boolean tmpDurationFromTargetFile = currentWctParams.isDurationFromTargetFile;
                boolean tmpEnergyFromTargetFile = currentWctParams.isEnergyFromTargetFile;
                currentWctParams.isPitchFromTargetFile = false;
                currentWctParams.isDurationFromTargetFile = false;
                currentWctParams.isEnergyFromTargetFile = false;
                if (currentWctParams.isTemporalSmoothing) {
                    currentWctParams.smoothingState = 1;
                    currentWctParams.smoothedVocalTractFile = smoothedVocalTractFile;
                    adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
                    boolean bl = adapter.bSilent = !currentWctParams.isDisplayProcessingFrameCount;
                    if (!currentWctParams.isLsfsFromTargetFile) {
                        adapter.fdpsolaOnline(jgMapper, jgSet, pMap);
                    } else {
                        adapter.fdpsolaOnline(tcMapper, jgSet, pMap);
                    }
                    currentWctParams.smoothingState = 2;
                    currentWctParams.smoothedVocalTractFile = smoothedVocalTractFile;
                    adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
                } else {
                    currentWctParams.smoothingMethod = 0;
                    currentWctParams.smoothingState = 0;
                    currentWctParams.smoothedVocalTractFile = "";
                    adapter = new FdpsolaAdapter(inputItem, firstPassOutputWavFile, currentWctParams, pscalesNone, tscalesNone, escalesNone, vscalesNone);
                }
                currentWctParams.isPitchFromTargetFile = tmpPitchFromTargetFile;
                currentWctParams.isDurationFromTargetFile = tmpDurationFromTargetFile;
                currentWctParams.isEnergyFromTargetFile = tmpEnergyFromTargetFile;
                if (adapter != null) {
                    boolean bl = adapter.bSilent = !currentWctParams.isDisplayProcessingFrameCount;
                    if (!currentWctParams.isLsfsFromTargetFile) {
                        adapter.fdpsolaOnline(jgMapper, jgSet, pMap);
                    } else {
                        adapter.fdpsolaOnline(tcMapper, jgSet, pMap);
                    }
                    if (JointGMMTransformer.isScalingsRequired(pscales, tscales, escales, vscales) || tmpPitchTransformationMethod != 0) {
                        System.out.println("Performing prosody modifications...");
                        currentWctParams.isVocalTractTransformation = false;
                        currentWctParams.isFixedRateVocalTractConversion = false;
                        currentWctParams.isResynthesizeVocalTractFromSourceModel = false;
                        currentWctParams.isVocalTractMatchUsingTargetModel = false;
                        currentWctParams.prosodyParams.pitchTransformationMethod = tmpPitchTransformationMethod;
                        currentWctParams.prosodyParams.durationTransformationMethod = tmpDurationTransformationMethod;
                        currentWctParams.prosodyParams.energyTransformationMethod = tmpEnergyTransformationMethod;
                        currentWctParams.smoothingMethod = 0;
                        currentWctParams.smoothingState = 0;
                        currentWctParams.smoothedVocalTractFile = "";
                        String tmpInputWavFile = inputItem.audioFile;
                        inputItem.audioFile = firstPassOutputWavFile;
                        adapter = new FdpsolaAdapter(inputItem, outputItem.audioFile, currentWctParams, pscales, tscales, escales, vscales);
                        inputItem.audioFile = tmpInputWavFile;
                        adapter.bSilent = true;
                        adapter.fdpsolaOnline(null, jgSet, pMap);
                    } else {
                        FileUtils.copy((String)firstPassOutputWavFile, (String)outputItem.audioFile);
                    }
                    if (!currentWctParams.isSaveVocalTractOnlyVersion) {
                        FileUtils.delete((String)firstPassOutputWavFile);
                    }
                    System.out.println("Done...");
                }
            } else {
                currentWctParams.smoothingMethod = 0;
                currentWctParams.smoothingState = 0;
                currentWctParams.smoothedVocalTractFile = "";
                adapter = new FdpsolaAdapter(inputItem, outputItem.audioFile, currentWctParams, pscales, tscales, escales, vscales);
                boolean bl = adapter.bSilent = !wctParams.isDisplayProcessingFrameCount;
                if (!currentWctParams.isLsfsFromTargetFile) {
                    adapter.fdpsolaOnline(jgMapper, jgSet, pMap);
                } else {
                    adapter.fdpsolaOnline(tcMapper, jgSet, pMap);
                }
            }
        } else if (jgSet.gmms[0].featureType == BaselineFeatureExtractor.MFCC_FEATURES_FROM_FILES) {
            MfccAdapter adapter = null;
            JointGMMTransformerParams currentWctParams = new JointGMMTransformerParams(wctParams);
            adapter = new MfccAdapter(inputItem, outputItem.rawMfccFile, currentWctParams);
            if (adapter != null) {
                adapter.bSilent = !currentWctParams.isDisplayProcessingFrameCount;
                adapter.transformOnline(jgMapper, jgSet);
                System.out.println("Done...");
            }
        }
    }

    public static void main(String[] args) throws IOException, UnsupportedAudioFileException {
        JointGMMTransformer.mainQuickTest2(args);
    }

    public static void mainHmmVoiceConversion(String[] args) throws UnsupportedAudioFileException, IOException {
        int i;
        String outputBaseFolder;
        String wavBaseFolder = "D:/Oytun/DFKI/voices/hmmVoiceConversionTest2/";
        String sourceTag = "hmmSource_nogv";
        String targetTag = "origTarget";
        String method = "F";
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        BaselinePostprocessor po = new BaselinePostprocessor();
        JointGMMTransformerParams pa = new JointGMMTransformerParams();
        int numTrainingFiles = 1092;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{128};
        String inputFolder = String.valueOf(wavBaseFolder) + "/" + sourceTag + "/test_1/";
        if (!isContextualGMMs) {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles);
        } else {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_" + "context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
        }
        String baseFile = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/" + sourceTag + method + "_X_" + targetTag + method + "_" + String.valueOf(numTrainingFiles);
        pa.isForcedAnalysis = false;
        pa.isSourceVocalTractSpectrumFromModel = true;
        pa.isVocalTractTransformation = true;
        pa.isResynthesizeVocalTractFromSourceModel = false;
        pa.isVocalTractMatchUsingTargetModel = false;
        pa.isTemporalSmoothing = false;
        pa.smoothingNumNeighbours = 3;
        if (!pa.isTemporalSmoothing) {
            pa.smoothingNumNeighbours = 0;
        }
        pa.smoothingMethod = 1;
        pa.isDisplayProcessingFrameCount = true;
        pa.inputFolder = inputFolder;
        pa.outputBaseFolder = outputBaseFolder;
        if (!isContextualGMMs) {
            pa.jointGmmFile = String.valueOf(baseFile) + "_" + String.valueOf(numComponents[0]) + ".jgs";
        } else {
            pa.jointGmmFile = String.valueOf(baseFile) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + ".jgs";
        }
        pa.pitchMappingFile = String.valueOf(baseFile) + PitchMappingFile.DEFAULT_EXTENSION;
        pa.outputFolderInfoString = "isSrc" + String.valueOf(pa.isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(pa.isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(pa.smoothingNumNeighbours);
        pa.isSeparateProsody = false;
        pa.isSaveVocalTractOnlyVersion = false;
        pa.isFixedRateVocalTractConversion = true;
        pa.prosodyParams.pitchStatisticsType = PitchStatistics.STATISTICS_IN_HERTZ;
        pa.prosodyParams.durationTransformationMethod = 0;
        pa.prosodyParams.isUseInputMeanPitch = false;
        pa.prosodyParams.isUseInputStdDevPitch = false;
        pa.prosodyParams.isUseInputRangePitch = false;
        pa.prosodyParams.isUseInputInterceptPitch = false;
        pa.prosodyParams.isUseInputSlopePitch = false;
        pa.isPitchFromTargetFile = false;
        pa.isDurationFromTargetFile = false;
        pa.isEnergyFromTargetFile = false;
        pa.targetAlignmentFileType = 1;
        JointGMMTransformer t = new JointGMMTransformer(pp, fe, po, pa);
        t.run();
    }

    public static void mainQuickTest(String[] args) throws UnsupportedAudioFileException, IOException {
        int i;
        String outputBaseFolder;
        String wavBaseFolder = "D:/quickTest/";
        String sourceTag = "source";
        String targetTag = "target";
        String method = "F";
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        BaselinePostprocessor po = new BaselinePostprocessor();
        JointGMMTransformerParams pa = new JointGMMTransformerParams();
        int numTrainingFiles = 50;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{10};
        String inputFolder = String.valueOf(wavBaseFolder) + "/" + sourceTag + "/test_5/";
        if (!isContextualGMMs) {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles);
        } else {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_" + "context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
        }
        String baseFile = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/" + sourceTag + method + "_X_" + targetTag + method + "_" + String.valueOf(numTrainingFiles);
        pa.isForcedAnalysis = false;
        pa.isSourceVocalTractSpectrumFromModel = false;
        pa.isVocalTractTransformation = true;
        pa.isResynthesizeVocalTractFromSourceModel = false;
        pa.isVocalTractMatchUsingTargetModel = false;
        pa.isTemporalSmoothing = true;
        pa.smoothingNumNeighbours = 10;
        if (!pa.isTemporalSmoothing) {
            pa.smoothingNumNeighbours = 0;
        }
        pa.smoothingMethod = 1;
        pa.isDisplayProcessingFrameCount = true;
        pa.inputFolder = inputFolder;
        pa.outputBaseFolder = outputBaseFolder;
        if (!isContextualGMMs) {
            pa.jointGmmFile = String.valueOf(baseFile) + "_" + String.valueOf(numComponents[0]) + ".jgs";
        } else {
            pa.jointGmmFile = String.valueOf(baseFile) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + ".jgs";
        }
        pa.pitchMappingFile = String.valueOf(baseFile) + PitchMappingFile.DEFAULT_EXTENSION;
        pa.outputFolderInfoString = "isSrc" + String.valueOf(pa.isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(pa.isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(pa.smoothingNumNeighbours);
        pa.isSeparateProsody = false;
        pa.isSaveVocalTractOnlyVersion = false;
        pa.isFixedRateVocalTractConversion = true;
        pa.prosodyParams.pitchStatisticsType = PitchStatistics.STATISTICS_IN_HERTZ;
        pa.prosodyParams.durationTransformationMethod = 0;
        pa.prosodyParams.isUseInputMeanPitch = false;
        pa.prosodyParams.isUseInputStdDevPitch = false;
        pa.prosodyParams.isUseInputRangePitch = false;
        pa.prosodyParams.isUseInputInterceptPitch = false;
        pa.prosodyParams.isUseInputSlopePitch = false;
        pa.isPitchFromTargetFile = false;
        pa.isDurationFromTargetFile = false;
        pa.isEnergyFromTargetFile = false;
        pa.targetAlignmentFileType = 1;
        JointGMMTransformer t = new JointGMMTransformer(pp, fe, po, pa);
        t.run();
    }

    public static void mainQuickTest2(String[] args) throws UnsupportedAudioFileException, IOException {
        int i;
        String outputBaseFolder;
        String wavBaseFolder = "/project/mary/marcela/VoiceConversion/Neutral-Spike-Conversion/";
        String sourceTag = "source";
        String targetTag = "target";
        String method = "F";
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        BaselinePostprocessor po = new BaselinePostprocessor();
        JointGMMTransformerParams pa = new JointGMMTransformerParams();
        int numTrainingFiles = 99;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{10};
        String inputFolder = String.valueOf(wavBaseFolder) + "/" + sourceTag + "/wav/";
        if (!isContextualGMMs) {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles);
        } else {
            outputBaseFolder = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_" + "context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
        }
        String baseFile = String.valueOf(wavBaseFolder) + "output/" + sourceTag + "2" + targetTag + "/" + sourceTag + method + "_X_" + targetTag + method + "_" + String.valueOf(numTrainingFiles);
        pa.isForcedAnalysis = false;
        pa.isSourceVocalTractSpectrumFromModel = false;
        pa.isVocalTractTransformation = true;
        pa.isResynthesizeVocalTractFromSourceModel = false;
        pa.isVocalTractMatchUsingTargetModel = false;
        pa.isTemporalSmoothing = true;
        pa.smoothingNumNeighbours = 10;
        if (!pa.isTemporalSmoothing) {
            pa.smoothingNumNeighbours = 0;
        }
        pa.smoothingMethod = 1;
        pa.isDisplayProcessingFrameCount = true;
        pa.inputFolder = inputFolder;
        pa.outputBaseFolder = outputBaseFolder;
        if (!isContextualGMMs) {
            pa.jointGmmFile = String.valueOf(baseFile) + "_" + String.valueOf(numComponents[0]) + ".jgs";
        } else {
            pa.jointGmmFile = String.valueOf(baseFile) + "_context" + String.valueOf(contextClassificationType);
            i = 0;
            while (i < numComponents.length) {
                pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + ".jgs";
        }
        pa.pitchMappingFile = String.valueOf(baseFile) + PitchMappingFile.DEFAULT_EXTENSION;
        pa.outputFolderInfoString = "isSrc" + String.valueOf(pa.isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(pa.isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(pa.smoothingNumNeighbours);
        pa.isSeparateProsody = false;
        pa.isSaveVocalTractOnlyVersion = false;
        pa.isFixedRateVocalTractConversion = true;
        pa.prosodyParams.pitchStatisticsType = PitchStatistics.STATISTICS_IN_HERTZ;
        pa.prosodyParams.durationTransformationMethod = 0;
        pa.prosodyParams.isUseInputMeanPitch = false;
        pa.prosodyParams.isUseInputStdDevPitch = false;
        pa.prosodyParams.isUseInputRangePitch = false;
        pa.prosodyParams.isUseInputInterceptPitch = false;
        pa.prosodyParams.isUseInputSlopePitch = false;
        pa.isPitchFromTargetFile = false;
        pa.isDurationFromTargetFile = false;
        pa.isEnergyFromTargetFile = false;
        pa.targetAlignmentFileType = 1;
        JointGMMTransformer t = new JointGMMTransformer(pp, fe, po, pa);
        t.run();
    }

    public static void mainInterspeech2008(String[] args) throws IOException, UnsupportedAudioFileException {
        String outputBaseFolder;
        String emotion = "angry";
        String method = "F";
        int numTrainingFiles = 200;
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{40};
        String inputFolder = "D:/Oytun/DFKI/voices/Interspeech08/neutral/test_tts_" + emotion;
        if (!isContextualGMMs) {
            outputBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out2/neutral2" + emotion + "/neutral2" + emotion + "Out_gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_" + String.valueOf(numComponents[0]);
        } else {
            outputBaseFolder = "D:/Oytun/DFKI/voices/Interspeech08_out2/neutral2" + emotion + "/neutral2" + emotion + "Out_gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_" + "context" + String.valueOf(contextClassificationType);
            int i = 0;
            while (i < numComponents.length) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
        }
        String baseFile = "D:/Oytun/DFKI/voices/Interspeech08_out2/neutral2" + emotion + "/neutral" + method + "_X_" + emotion + method + "_" + String.valueOf(numTrainingFiles);
        boolean isSourceVocalTractSpectrumFromModel = false;
        boolean isTemporalSmoothing = true;
        int smoothingNumNeighbours = 10;
        boolean isPitchFromTargetFile = true;
        int pitchFromTargetMethod = 30;
        boolean isDurationFromTargetFile = true;
        int durationFromTargetMethod = 1;
        boolean isEnergyFromTargetFile = false;
        boolean isLsfsFromTargetFile = false;
        int targetAlignmentFileType = 2;
        String outputFolderInfoString = "isSrc" + String.valueOf(isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(smoothingNumNeighbours) + "_psUtt" + String.valueOf(isPitchFromTargetFile ? 1 : 0) + "_tsUtt" + String.valueOf(isDurationFromTargetFile ? 1 : 0);
        JointGMMTransformer.mainParametric(inputFolder, outputBaseFolder, baseFile, outputFolderInfoString, isSourceVocalTractSpectrumFromModel, isTemporalSmoothing, smoothingNumNeighbours, isPitchFromTargetFile, pitchFromTargetMethod, isDurationFromTargetFile, durationFromTargetMethod, isEnergyFromTargetFile, isLsfsFromTargetFile, targetAlignmentFileType, isContextualGMMs, contextClassificationType, numComponents);
    }

    public static void mainIeeeTaslp2009_mary(String[] args) throws IOException, UnsupportedAudioFileException {
        String[] emotions = new String[]{"angry", "happy", "sad"};
        int emCount = 0;
        while (emCount < emotions.length) {
            String emotion = emotions[emCount];
            String method = "F";
            int numTrainingFiles = 200;
            boolean isContextualGMMs = false;
            int contextClassificationType = -1;
            int[] numComponents = new int[]{40};
            String inputFolder = "D:/publications/IEEE_TASLP/2009/expressiveVC/voice_conversion/test_neutral2" + emotion;
            String outputBaseString = "D:/publications/IEEE_TASLP/2009/expressiveVC/voice_conversion/out2_neutral2";
            String outputBaseFolder = String.valueOf(outputBaseString) + emotion + "/neutral2" + emotion + "Out_gmm" + method + "_" + String.valueOf(numTrainingFiles) + "_";
            if (!isContextualGMMs) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + String.valueOf(numComponents[0]);
            } else {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "context" + String.valueOf(contextClassificationType);
                int i = 0;
                while (i < numComponents.length) {
                    outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                    ++i;
                }
            }
            String baseFile = String.valueOf(outputBaseString) + emotion + "/neutral" + method + "_X_" + emotion + method + "_" + String.valueOf(numTrainingFiles);
            boolean isSourceVocalTractSpectrumFromModel = false;
            boolean isTemporalSmoothing = false;
            int smoothingNumNeighbours = 5;
            boolean isPitchFromTargetFile = true;
            int pitchFromTargetMethod = 26;
            boolean isDurationFromTargetFile = true;
            int durationFromTargetMethod = 1;
            boolean isEnergyFromTargetFile = false;
            boolean isLsfsFromTargetFile = false;
            int targetAlignmentFileType = 1;
            String outputFolderInfoString = "isSrc" + String.valueOf(isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(smoothingNumNeighbours) + "_psUtt" + String.valueOf(isPitchFromTargetFile ? 1 : 0) + "_tsUtt" + String.valueOf(isDurationFromTargetFile ? 1 : 0);
            JointGMMTransformer.mainParametric(inputFolder, outputBaseFolder, baseFile, outputFolderInfoString, isSourceVocalTractSpectrumFromModel, isTemporalSmoothing, smoothingNumNeighbours, isPitchFromTargetFile, pitchFromTargetMethod, isDurationFromTargetFile, durationFromTargetMethod, isEnergyFromTargetFile, isLsfsFromTargetFile, targetAlignmentFileType, isContextualGMMs, contextClassificationType, numComponents);
            ++emCount;
        }
    }

    public static void mainIeeeTaslp2009_rap(String[] args) throws IOException, UnsupportedAudioFileException {
        String outputBaseFolder;
        String source = "uch";
        String target = "target";
        String method = "F";
        boolean isContextualGMMs = false;
        int contextClassificationType = -1;
        int[] numComponents = new int[]{32};
        String inputFolder = "D:/Oytun/Papers/IEEE_Transaction_VT/musicVC/final_gmm/uch_test";
        if (!isContextualGMMs) {
            outputBaseFolder = "D:/Oytun/Papers/IEEE_Transaction_VT/musicVC/final_gmm/out_gmm" + method + "_" + String.valueOf(numComponents[0]);
        } else {
            outputBaseFolder = "D:/Oytun/Papers/IEEE_Transaction_VT/musicVC/final_gmm/out_gmm" + method + "_" + String.valueOf(numComponents[0]) + "_" + "context" + String.valueOf(contextClassificationType);
            int i = 0;
            while (i < numComponents.length) {
                outputBaseFolder = String.valueOf(outputBaseFolder) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
        }
        String baseFile = "D:/Oytun/Papers/IEEE_Transaction_VT/musicVC/final_gmm/" + source + method + "_X_" + target + method;
        boolean isSourceVocalTractSpectrumFromModel = false;
        boolean isTemporalSmoothing = true;
        int smoothingNumNeighbours = 20;
        boolean isPitchFromTargetFile = false;
        int pitchFromTargetMethod = 30;
        boolean isDurationFromTargetFile = false;
        int durationFromTargetMethod = 1;
        boolean isEnergyFromTargetFile = false;
        boolean isLsfsFromTargetFile = false;
        int targetAlignmentFileType = 2;
        String outputFolderInfoString = "isSrc" + String.valueOf(isSourceVocalTractSpectrumFromModel ? 1 : 0) + "_smooth" + String.valueOf(isTemporalSmoothing ? 1 : 0) + "_" + String.valueOf(smoothingNumNeighbours) + "_psUtt" + String.valueOf(isPitchFromTargetFile ? 1 : 0) + "_tsUtt" + String.valueOf(isDurationFromTargetFile ? 1 : 0);
        JointGMMTransformer.mainParametric(inputFolder, outputBaseFolder, baseFile, outputFolderInfoString, isSourceVocalTractSpectrumFromModel, isTemporalSmoothing, smoothingNumNeighbours, isPitchFromTargetFile, pitchFromTargetMethod, isDurationFromTargetFile, durationFromTargetMethod, isEnergyFromTargetFile, isLsfsFromTargetFile, targetAlignmentFileType, isContextualGMMs, contextClassificationType, numComponents);
    }

    public static void mainParametric(String inputFolder, String outputBaseFolder, String baseFile, String outputFolderInfoString, boolean isSourceVocalTractSpectrumFromModel, boolean isTemporalSmoothing, int smoothingNumNeighbours, boolean isPitchFromTargetFile, int pitchFromTargetMethod, boolean isDurationFromTargetFile, int durationFromTargetMethod, boolean isEnergyFromTargetFile, boolean isLsfsFromTargetFile, int targetAlignmentFileType, boolean isContextualGMMs, int contextClassificationType, int[] numComponents) throws IOException, UnsupportedAudioFileException {
        BaselinePreprocessor pp = new BaselinePreprocessor();
        BaselineFeatureExtractor fe = new BaselineFeatureExtractor();
        BaselinePostprocessor po = new BaselinePostprocessor();
        JointGMMTransformerParams pa = new JointGMMTransformerParams();
        pa.isDisplayProcessingFrameCount = true;
        pa.inputFolder = inputFolder;
        pa.outputBaseFolder = outputBaseFolder;
        if (!isContextualGMMs) {
            pa.jointGmmFile = String.valueOf(baseFile) + "_" + String.valueOf(numComponents[0]) + ".jgs";
        } else {
            pa.jointGmmFile = String.valueOf(baseFile) + "_context" + String.valueOf(contextClassificationType);
            int i = 0;
            while (i < numComponents.length) {
                pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + "_" + String.valueOf(numComponents[i]);
                ++i;
            }
            pa.jointGmmFile = String.valueOf(pa.jointGmmFile) + ".jgs";
        }
        pa.pitchMappingFile = String.valueOf(baseFile) + PitchMappingFile.DEFAULT_EXTENSION;
        pa.outputFolderInfoString = outputFolderInfoString;
        pa.isForcedAnalysis = false;
        pa.isSourceVocalTractSpectrumFromModel = isSourceVocalTractSpectrumFromModel;
        pa.isVocalTractTransformation = true;
        pa.isResynthesizeVocalTractFromSourceModel = false;
        pa.isVocalTractMatchUsingTargetModel = false;
        pa.isSeparateProsody = true;
        pa.isSaveVocalTractOnlyVersion = false;
        pa.isFixedRateVocalTractConversion = true;
        pa.prosodyParams.pitchStatisticsType = PitchStatistics.STATISTICS_IN_HERTZ;
        pa.prosodyParams.durationTransformationMethod = 0;
        pa.prosodyParams.pitchTransformationMethod = 0;
        pa.prosodyParams.isUseInputMeanPitch = false;
        pa.prosodyParams.isUseInputStdDevPitch = false;
        pa.prosodyParams.isUseInputRangePitch = false;
        pa.prosodyParams.isUseInputInterceptPitch = false;
        pa.prosodyParams.isUseInputSlopePitch = false;
        pa.isTemporalSmoothing = isTemporalSmoothing;
        pa.smoothingNumNeighbours = smoothingNumNeighbours;
        pa.smoothingMethod = 1;
        pa.isPitchFromTargetFile = isPitchFromTargetFile;
        pa.pitchFromTargetMethod = pitchFromTargetMethod;
        pa.isDurationFromTargetFile = isDurationFromTargetFile;
        pa.durationFromTargetMethod = durationFromTargetMethod;
        pa.isEnergyFromTargetFile = isEnergyFromTargetFile;
        pa.isLsfsFromTargetFile = isLsfsFromTargetFile;
        pa.targetAlignmentFileType = targetAlignmentFileType;
        JointGMMTransformer t = new JointGMMTransformer(pp, fe, po, pa);
        t.run();
    }
}

