/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.adaptation.prosody;

import marytts.signalproc.adaptation.prosody.PitchStatistics;

public class PitchStatisticsCollection {
    public PitchStatistics[] entries;

    public PitchStatisticsCollection() {
        this(0);
    }

    public PitchStatisticsCollection(int numEntries) {
        this.allocate(numEntries);
    }

    public PitchStatisticsCollection(PitchStatisticsCollection existing) {
        this.allocate(existing.entries.length);
        int i = 0;
        while (i < existing.entries.length) {
            this.entries[i] = new PitchStatistics(existing.entries[i]);
            ++i;
        }
    }

    public void allocate(int numEntries) {
        this.entries = null;
        if (numEntries > 0) {
            this.entries = new PitchStatistics[numEntries];
        }
    }

    public PitchStatistics getGlobalStatisticsSourceHz() {
        return this.getGlobalStatistics(PitchStatistics.STATISTICS_IN_HERTZ, true);
    }

    public PitchStatistics getGlobalStatisticsTargetHz() {
        return this.getGlobalStatistics(PitchStatistics.STATISTICS_IN_HERTZ, false);
    }

    public PitchStatistics getGlobalStatisticsSourceLogHz() {
        return this.getGlobalStatistics(PitchStatistics.STATISTICS_IN_LOGHERTZ, true);
    }

    public PitchStatistics getGlobalStatisticsTargetLogHz() {
        return this.getGlobalStatistics(PitchStatistics.STATISTICS_IN_LOGHERTZ, false);
    }

    public PitchStatistics getGlobalStatistics(int statisticsType, boolean isSource) {
        PitchStatistics p = null;
        PitchStatisticsCollection c = this.getStatistics(true, statisticsType, isSource);
        if (c != null) {
            p = new PitchStatistics(c.entries[0]);
        }
        return p;
    }

    public PitchStatisticsCollection getLocalStatisticsSourceHz() {
        return this.getLocalStatistics(PitchStatistics.STATISTICS_IN_HERTZ, true);
    }

    public PitchStatisticsCollection getLocalStatisticsTargetHz() {
        return this.getLocalStatistics(PitchStatistics.STATISTICS_IN_HERTZ, false);
    }

    public PitchStatisticsCollection getLocalStatisticsSourceLogHz() {
        return this.getLocalStatistics(PitchStatistics.STATISTICS_IN_LOGHERTZ, true);
    }

    public PitchStatisticsCollection getLocalStatisticsTargetLogHz() {
        return this.getLocalStatistics(PitchStatistics.STATISTICS_IN_LOGHERTZ, false);
    }

    public PitchStatisticsCollection getLocalStatistics(int statisticsType, boolean isSource) {
        return this.getStatistics(false, statisticsType, isSource);
    }

    public PitchStatisticsCollection getStatistics(boolean isGlobal, int statisticsType, boolean isSource) {
        PitchStatisticsCollection c = null;
        if (this.entries != null) {
            int total = 0;
            int i = 0;
            while (i < this.entries.length) {
                if (this.entries[i].isGlobal == isGlobal && this.entries[i].type == statisticsType && this.entries[i].isSource == isSource) {
                    ++total;
                }
                ++i;
            }
            if (total > 0) {
                c = new PitchStatisticsCollection(total);
                int count = 0;
                i = 0;
                while (i < this.entries.length) {
                    if (this.entries[i].isGlobal == isGlobal && this.entries[i].type == statisticsType && this.entries[i].isSource == isSource && count < total) {
                        c.entries[count] = new PitchStatistics(this.entries[i]);
                        ++count;
                    }
                    ++i;
                }
            }
        }
        return c;
    }
}

