/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.util.Arrays;
import marytts.signalproc.analysis.F0Tracker;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.window.BlackmanWindow;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class F0TrackerAutocorrelationDP
extends F0Tracker {
    @Override
    protected DoubleDataSource preprocess(DoubleDataSource signal) {
        double CENTERCLIPPING_THRESHOLD = 0.2;
        double[] signalData = signal.getAllData();
        double mean = MathUtils.mean(signalData);
        int i = 0;
        while (i < signalData.length) {
            int n = i++;
            signalData[n] = signalData[n] - mean;
        }
        double maxAmplitude = MathUtils.absMax(signalData);
        double cutoff = maxAmplitude * CENTERCLIPPING_THRESHOLD;
        int i2 = 0;
        while (i2 < signalData.length) {
            if (Math.abs(signalData[i2]) < cutoff) {
                signalData[i2] = 0.0;
            }
            ++i2;
        }
        return new BufferedDoubleDataSource(signalData);
    }

    @Override
    protected FrameBasedAnalyser getCandidateEstimator(DoubleDataSource preprocessedSignal, int samplingRate) {
        int windowLength = 3 * samplingRate / 70;
        if (windowLength % 2 == 0) {
            ++windowLength;
        }
        BlackmanWindow window = new BlackmanWindow(windowLength);
        int windowShift = windowLength / 2;
        return new CandidateEstimator(preprocessedSignal, window, windowShift, samplingRate);
    }

    @Override
    protected F0Tracker.TransitionCost getTransitionCost() {
        return null;
    }

    public class CandidateEstimator
    extends F0Tracker.CandidateEstimator {
        public static final int NCANDIDATES = 15;
        protected int minF0;
        protected int maxF0;
        protected double[] correlationInput;

        public CandidateEstimator(DoubleDataSource signal, Window window, int frameShift, int samplingRate, int minF0, int maxF0) {
            this(signal, window, frameShift, samplingRate);
            this.minF0 = minF0;
            this.maxF0 = maxF0;
        }

        public CandidateEstimator(DoubleDataSource signal, Window window, int frameShift, int samplingRate) {
            super(signal, window, frameShift, samplingRate, 15);
            this.correlationInput = new double[MathUtils.closestPowerOfTwoAbove(2 * window.getLength())];
            this.minF0 = 70;
            this.maxF0 = 700;
        }

        @Override
        protected void findCandidates(F0Tracker.F0Candidate[] candidates, double[] frame) {
            int peak;
            System.arraycopy(frame, 0, this.correlationInput, 0, frame.length);
            Arrays.fill(this.correlationInput, frame.length, this.correlationInput.length, 0.0);
            double[] acf = FFT.autoCorrelate(this.correlationInput);
            int valley = MathUtils.findNextValleyLocation(acf, 0);
            double deltaT = 1.0 / (double)this.samplingRate;
            while ((peak = MathUtils.findNextPeakLocation(acf, valley)) != acf.length - 1) {
                double f0 = 1.0 / ((double)peak * deltaT);
                if (f0 >= (double)this.minF0 && f0 <= (double)this.maxF0) {
                    this.addCandidate(candidates, new F0Tracker.F0Candidate(f0, acf[peak]));
                }
                valley = MathUtils.findNextValleyLocation(acf, peak);
            }
        }
    }
}

