/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.File;
import java.io.FileReader;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.Defaults;
import marytts.signalproc.analysis.FrameBasedAnalyser;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.analysis.PitchFrameAnalyser;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.text.ESTTextfileDoubleDataSource;

public class LpcPitchSynchronousAnalyser
extends PitchFrameAnalyser {
    public static int lpOrder = 0;

    public LpcPitchSynchronousAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate) {
        super(signal, pitchmarks, windowType, samplingRate);
    }

    public LpcPitchSynchronousAnalyser(DoubleDataSource signal, DoubleDataSource pitchmarks, int windowType, int samplingRate, int framePeriods, int shiftPeriods) {
        super(signal, pitchmarks, windowType, samplingRate, framePeriods, shiftPeriods);
    }

    @Override
    public Object analyse(double[] frame) {
        int expectedFrameLength = 0;
        int i = 0;
        while (i < this.periodLengths.length) {
            expectedFrameLength += this.periodLengths[i];
            ++i;
        }
        if (frame.length != expectedFrameLength) {
            System.err.println("Expected frame of length " + expectedFrameLength + "(" + this.periodLengths.length + " periods)" + ", got " + frame.length);
        }
        return LpcAnalyser.calcLPC(frame, lpOrder);
    }

    public static void main(String[] args) throws Exception {
        File audioFile = new File(args[0]);
        File pitchmarkFile = new File(args[1]);
        AudioInputStream ais = AudioSystem.getAudioInputStream(audioFile);
        int samplingRate = (int)ais.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(ais);
        ESTTextfileDoubleDataSource pitchmarks = new ESTTextfileDoubleDataSource(new FileReader(pitchmarkFile));
        int windowType = Defaults.getWindowType();
        Defaults.getFFTSize();
        Integer.getInteger("signalproc.lpcorder", 24).intValue();
        LpcPitchSynchronousAnalyser pla = new LpcPitchSynchronousAnalyser((DoubleDataSource)signal, (DoubleDataSource)pitchmarks, windowType, samplingRate, 2, 1);
        FrameBasedAnalyser.FrameAnalysisResult[] far = pla.analyseAllFrames();
        int i = 0;
        while (i < far.length) {
            LpcAnalyser.LpCoeffs coeffs = (LpcAnalyser.LpCoeffs)far[i].get();
            System.out.print(String.valueOf(far[i].getStartTime()) + ": gain " + coeffs.getGain() + ", coffs: ");
            int j = 0;
            while (j < coeffs.getOrder()) {
                System.out.print(String.valueOf(coeffs.getA(j)) + "  ");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

