/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.filter;

import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.BlockwiseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;
import marytts.util.math.FFT;
import marytts.util.math.MathUtils;

public class FIRFilter
implements InlineDataProcessor {
    protected double[] transformedIR;
    protected int impulseResponseLength;
    protected int sliceLength;
    protected double[] denumeratorCoefficients;

    protected FIRFilter() {
    }

    public FIRFilter(double[] impulseResponse) {
        int sliceLen = MathUtils.closestPowerOfTwoAbove(2 * impulseResponse.length) - impulseResponse.length;
        this.initialise(impulseResponse, sliceLen);
    }

    public FIRFilter(double[] impulseResponse, int len) {
        this.initialise(impulseResponse, len);
    }

    protected void initialise(double[] impulseResponse, int sliceLen) {
        this.denumeratorCoefficients = new double[impulseResponse.length];
        System.arraycopy(impulseResponse, 0, this.denumeratorCoefficients, 0, impulseResponse.length);
        if (!MathUtils.isPowerOfTwo(impulseResponse.length + sliceLen)) {
            throw new IllegalArgumentException("Impulse response length plus slice length must be a power of two");
        }
        this.impulseResponseLength = impulseResponse.length;
        this.sliceLength = sliceLen;
        this.transformedIR = new double[sliceLen + impulseResponse.length];
        System.arraycopy(impulseResponse, 0, this.transformedIR, 0, impulseResponse.length);
        FFT.realTransform(this.transformedIR, false);
    }

    public DoubleDataSource apply(DoubleDataSource signal) {
        return new FIROutput(signal);
    }

    public double[] apply(double[] signal) {
        return new FIROutput(new BufferedDoubleDataSource(signal)).getAllData();
    }

    @Override
    public void applyInline(double[] data, int off, int len) {
        double[] dataOut = this.apply(data);
        System.arraycopy(dataOut, 0, data, 0, len);
    }

    public int getImpulseResponseLength() {
        return this.impulseResponseLength;
    }

    public double[] getDenumeratorCoefficients() {
        return this.denumeratorCoefficients;
    }

    public class FIROutput
    extends BlockwiseDoubleDataSource {
        protected FrameProvider frameProvider;
        protected int nTailCutoff;

        public FIROutput(DoubleDataSource inputSource) {
            super(null, FIRFilter.this.sliceLength);
            int frameLength = FIRFilter.this.sliceLength + FIRFilter.this.impulseResponseLength;
            assert (MathUtils.isPowerOfTwo(frameLength));
            BufferedDoubleDataSource padding = new BufferedDoubleDataSource(new double[FIRFilter.this.impulseResponseLength]);
            SequenceDoubleDataSource paddedSource = new SequenceDoubleDataSource(new DoubleDataSource[]{padding, inputSource});
            this.frameProvider = new FrameProvider(paddedSource, null, frameLength, FIRFilter.this.sliceLength, 1, false);
            int nHeadCutoff = FIRFilter.this.impulseResponseLength / 2;
            this.nTailCutoff = FIRFilter.this.impulseResponseLength - nHeadCutoff;
            this.getData(nHeadCutoff);
        }

        @Override
        public boolean hasMoreData() {
            return this.currentlyInBuffer() > 0 || this.frameProvider.hasMoreData();
        }

        @Override
        public int getData(double[] target, int targetPos, int length) {
            int toRead = length + this.nTailCutoff;
            if (this.currentlyInBuffer() < toRead) {
                this.readIntoBuffer(toRead - this.currentlyInBuffer());
            }
            int toDeliver = length;
            if (this.currentlyInBuffer() < toRead) {
                toDeliver = this.currentlyInBuffer() - this.nTailCutoff;
                this.writePos -= this.nTailCutoff;
            }
            System.arraycopy(this.buf, this.readPos, target, targetPos, toDeliver);
            this.readPos += toDeliver;
            assert (this.readPos <= this.writePos);
            return toDeliver;
        }

        @Override
        protected int readBlock(double[] target, int targetPos) {
            double[] frame = this.frameProvider.getNextFrame();
            if (frame == null) {
                return 0;
            }
            assert (this.blockSize <= this.frameProvider.getFrameLengthSamples());
            assert (this.blockSize == this.frameProvider.getFrameShiftSamples());
            double[] convResult = FFT.convolve_FD(frame, FIRFilter.this.transformedIR);
            int toCopy = this.blockSize;
            if (this.frameProvider.validSamplesInFrame() < this.blockSize) {
                toCopy = this.frameProvider.validSamplesInFrame();
            }
            System.arraycopy(convResult, FIRFilter.this.impulseResponseLength, target, targetPos, toCopy);
            return toCopy;
        }
    }
}

