/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.File;
import java.util.Arrays;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import marytts.signalproc.analysis.LpcAnalyser;
import marytts.signalproc.process.FrameOverlapAddSource;
import marytts.signalproc.process.FrameProvider;
import marytts.signalproc.process.LPCAnalysisResynthesis;
import marytts.signalproc.window.Window;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;
import marytts.util.data.SequenceDoubleDataSource;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.data.audio.DDSAudioInputStream;

public class LPCCrossSynthesis
extends LPCAnalysisResynthesis {
    protected FrameProvider newResidualAudioFrames;

    public LPCCrossSynthesis(FrameProvider newResidualAudioFrames, int p) {
        super(p);
        this.newResidualAudioFrames = newResidualAudioFrames;
    }

    @Override
    protected void processLPC(LpcAnalyser.LpCoeffs coeffs, double[] residual) {
        double gain = coeffs.getGain();
        double[] frame = this.newResidualAudioFrames.getNextFrame();
        assert (frame.length == residual.length);
        int excP = 3;
        LpcAnalyser.LpCoeffs newCoeffs = LpcAnalyser.calcLPC(frame, excP);
        double newResidualGain = newCoeffs.getGain();
        double gainFactor = gain / newResidualGain;
        Arrays.fill(residual, 0.0);
        int n = 0;
        while (n < residual.length) {
            int i = 0;
            while (i <= excP && i <= n) {
                int n2 = n;
                residual[n2] = residual[n2] + newCoeffs.getOneMinusA(i) * frame[n - i];
                ++i;
            }
            int n3 = n++;
            residual[n3] = residual[n3] * gainFactor;
        }
    }

    public static void main(String[] args) throws Exception {
        long startTime = System.currentTimeMillis();
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        AudioInputStream newResidualAudio = AudioSystem.getAudioInputStream(new File(args[1]));
        AudioDoubleDataSource newResidual = new AudioDoubleDataSource(newResidualAudio);
        int frameLength = Integer.getInteger("signalproc.lpcanalysisresynthesis.framelength", 512);
        int predictionOrder = Integer.getInteger("signalproc.lpcanalysisresynthesis.predictionorder", 20);
        BufferedDoubleDataSource padding1 = new BufferedDoubleDataSource(new double[3 * frameLength / 4]);
        SequenceDoubleDataSource paddedExcitation = new SequenceDoubleDataSource(new DoubleDataSource[]{padding1, newResidual});
        FrameProvider newResidualAudioFrames = new FrameProvider(paddedExcitation, Window.get(3, frameLength, 0.5), frameLength, frameLength / 4, samplingRate, true);
        FrameOverlapAddSource foas = new FrameOverlapAddSource(signal, 3, false, frameLength, samplingRate, new LPCCrossSynthesis(newResidualAudioFrames, predictionOrder));
        DDSAudioInputStream outputAudio = new DDSAudioInputStream(new BufferedDoubleDataSource(foas), inputAudio.getFormat());
        String outFileName = String.valueOf(args[0].substring(0, args[0].length() - 4)) + "_" + args[1].substring(args[1].lastIndexOf("\\") + 1, args[1].length() - 4) + "_lpcCrossSynth.wav";
        AudioSystem.write((AudioInputStream)outputAudio, AudioFileFormat.Type.WAVE, new File(outFileName));
        long endTime = System.currentTimeMillis();
        System.out.println("LPC cross synthesis took " + (endTime - startTime) + " ms");
    }
}

