/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.util.Arrays;
import marytts.signalproc.process.TDPSOLAInstants;
import marytts.util.math.ArrayUtils;
import marytts.util.math.MathUtils;

public class TDPSOLAProcessor {
    public static TDPSOLAInstants transformAnalysisInstants(float[] analysisInstants, int samplingRateInHz, boolean[] vuvs, float[] tScales, float[] pScales) {
        TDPSOLAInstants synthesisInstants = null;
        int numfrm = analysisInstants.length;
        float[] frmSizesInSeconds = new float[numfrm];
        Arrays.fill(frmSizesInSeconds, 0.0f);
        float[] newFrmSizesInSeconds = new float[numfrm];
        Arrays.fill(newFrmSizesInSeconds, 0.0f);
        float[] newPeriodsInSeconds = new float[numfrm];
        Arrays.fill(newPeriodsInSeconds, 0.0f);
        float[] localDurDiffs = new float[numfrm];
        Arrays.fill(localDurDiffs, 0.0f);
        int i = 0;
        while (i < numfrm - 1) {
            frmSizesInSeconds[i] = analysisInstants[i + 1] - analysisInstants[i];
            newFrmSizesInSeconds[i] = vuvs[i] ? frmSizesInSeconds[i] / pScales[i] : frmSizesInSeconds[i];
            newPeriodsInSeconds[i] = newFrmSizesInSeconds[i];
            localDurDiffs[i] = frmSizesInSeconds[i] * tScales[i] - newFrmSizesInSeconds[i];
            float cfr_ignored_0 = newPeriodsInSeconds[i];
            ++i;
        }
        int[] repeatSkipCounts = new int[numfrm];
        Arrays.fill(repeatSkipCounts, 0);
        i = 0;
        while (i < numfrm) {
            if (localDurDiffs[i] < -0.1f * newPeriodsInSeconds[i]) {
                int n = i;
                repeatSkipCounts[n] = repeatSkipCounts[n] - 1;
                if (i < numfrm - 1) {
                    int n2 = i + 1;
                    localDurDiffs[n2] = localDurDiffs[n2] + (localDurDiffs[i] + newPeriodsInSeconds[i]);
                    localDurDiffs[i] = 0.0f;
                }
            } else if ((double)localDurDiffs[i] > 0.1 * (double)newPeriodsInSeconds[i]) {
                while ((double)localDurDiffs[i] > 0.1 * (double)newPeriodsInSeconds[i] && (double)newPeriodsInSeconds[i] > 1.0E-10) {
                    int n = i;
                    repeatSkipCounts[n] = repeatSkipCounts[n] + 1;
                    int n3 = i;
                    localDurDiffs[n3] = localDurDiffs[n3] - newPeriodsInSeconds[i];
                    float cfr_ignored_1 = newPeriodsInSeconds[i];
                }
                if (i < numfrm - 1) {
                    int n = i + 1;
                    localDurDiffs[n] = localDurDiffs[n] + localDurDiffs[i];
                    localDurDiffs[i] = 0.0f;
                }
            }
            ++i;
        }
        localDurDiffs[numfrm - 1] = MathUtils.sum(localDurDiffs);
        while (localDurDiffs[numfrm - 1] > 0.0f && (double)newPeriodsInSeconds[numfrm - 1] > 1.0E-10) {
            int n = numfrm - 1;
            repeatSkipCounts[n] = repeatSkipCounts[n] + 1;
            int n4 = numfrm - 1;
            localDurDiffs[n4] = localDurDiffs[n4] - newPeriodsInSeconds[numfrm - 1];
            float cfr_ignored_2 = newPeriodsInSeconds[numfrm - 1];
        }
        int numSynthesisInstants = MathUtils.sum(repeatSkipCounts) + repeatSkipCounts.length;
        if (numSynthesisInstants > 0) {
            synthesisInstants = new TDPSOLAInstants(numSynthesisInstants);
            float synthSt = analysisInstants[0];
            boolean bLastFrame = false;
            boolean bBroke = false;
            int synthesisFrameCounter = 0;
            i = 0;
            while (i < numfrm) {
                if (bBroke) break;
                if (repeatSkipCounts[i] > -1) {
                    int j = 1;
                    while (j <= repeatSkipCounts[i] + 1) {
                        synthesisInstants.analysisInstantsInSeconds[synthesisFrameCounter] = analysisInstants[i];
                        synthesisInstants.synthesisInstantsInSeconds[synthesisFrameCounter] = synthSt;
                        ++synthesisFrameCounter;
                        bLastFrame = false;
                        if (i == numfrm - 1) {
                            if (j == repeatSkipCounts[i] + 1) {
                                bLastFrame = true;
                            }
                        } else {
                            boolean bAll = true;
                            int k = i + 1;
                            while (k <= numfrm) {
                                if (repeatSkipCounts[k - 1] != -1) {
                                    bAll = false;
                                    break;
                                }
                                ++k;
                            }
                            if (bAll) {
                                bLastFrame = true;
                            }
                        }
                        synthSt = i < numfrm - 1 ? (vuvs[i] ? (synthSt += (analysisInstants[i + 1] - analysisInstants[i]) / pScales[i]) : (synthSt += analysisInstants[i + 1] - analysisInstants[i])) : (vuvs[i] ? (synthSt += (analysisInstants[i] - analysisInstants[i - 1]) / pScales[i]) : (synthSt += analysisInstants[i] - analysisInstants[i - 1]));
                        if (bLastFrame) {
                            bBroke = true;
                            break;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (synthesisInstants != null) {
            synthesisInstants.repeatSkipCounts = ArrayUtils.copy(repeatSkipCounts);
        }
        return synthesisInstants;
    }
}

