/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.synthesis;

import java.util.Arrays;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmPlusTransientsSpeechSignal;
import marytts.signalproc.window.HammingWindow;
import marytts.util.signal.SignalProcUtils;

public class TransientPartSynthesizer {
    public static double[] synthesize(HntmPlusTransientsSpeechSignal hnmSignal, HntmAnalyzerParams analysisParams) {
        int outputLen = SignalProcUtils.time2sample(hnmSignal.originalDurationInSeconds, hnmSignal.samplingRateInHz);
        double[] transientPart = new double[outputLen];
        Arrays.fill(transientPart, 0.0);
        if (hnmSignal.transients != null) {
            int ws = SignalProcUtils.time2sample(2.0f * analysisParams.overlapBetweenTransientAndNontransientSectionsInSeconds, hnmSignal.samplingRateInHz);
            if (ws % 2 == 0) {
                ++ws;
            }
            HammingWindow win = new HammingWindow(ws);
            win.normalizePeakValue(1.0f);
            int winMidInd = (ws - 1) / 2;
            int i = 0;
            while (i < hnmSignal.transients.segments.length) {
                if (hnmSignal.transients.segments[i] != null && hnmSignal.transients.segments[i].waveform != null && hnmSignal.transients.segments[i].waveform.length > 0 && hnmSignal.transients.segments[i].startTime >= 0.0f) {
                    int startInd = Math.min(SignalProcUtils.time2sample(hnmSignal.transients.segments[i].startTime, hnmSignal.samplingRateInHz), outputLen - 1);
                    int windowLeftEndInd = Math.min(startInd + winMidInd, outputLen - 1);
                    int endInd = Math.min(SignalProcUtils.time2sample(hnmSignal.transients.segments[i].startTime, hnmSignal.samplingRateInHz) + hnmSignal.transients.segments[i].waveform.length - 1, outputLen - 1);
                    int windowRightStartInd = endInd - winMidInd;
                    int j = startInd;
                    while (j <= windowLeftEndInd) {
                        transientPart[j] = (double)hnmSignal.transients.segments[i].waveform[j - startInd] * win.value(j - startInd);
                        ++j;
                    }
                    j = windowLeftEndInd + 1;
                    while (j < windowRightStartInd) {
                        transientPart[j] = hnmSignal.transients.segments[i].waveform[j - startInd];
                        ++j;
                    }
                    j = windowRightStartInd;
                    while (j <= endInd) {
                        transientPart[j] = (double)hnmSignal.transients.segments[i].waveform[j - startInd] * win.value(j - endInd + ws - 1);
                        ++j;
                    }
                }
                ++i;
            }
        }
        return transientPart;
    }
}

