/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import marytts.util.data.BaseDoubleDataSource;
import marytts.util.math.MathUtils;

public class NoiseDoubleDataSource
extends BaseDoubleDataSource {
    protected long n;
    protected double amplitude;

    public NoiseDoubleDataSource(long n, double dB) {
        this.n = n;
        this.dataLength = n;
        if (dB > 0.0) {
            throw new IllegalArgumentException("Energy must be non-positive");
        }
        this.amplitude = 32767.0 * Math.sqrt(MathUtils.db2linear(dB));
    }

    @Override
    public boolean hasMoreData() {
        return this.n > 0L;
    }

    @Override
    public int available() {
        return (int)this.n;
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (target.length - targetPos < length) {
            throw new IllegalArgumentException("Target array cannot hold enough data (" + (target.length - targetPos) + " left, but " + length + " requested)");
        }
        int toCopy = (int)Math.min((long)length, this.n);
        int i = targetPos;
        while (i < targetPos + toCopy) {
            target[i] = 2.0 * (0.5 - Math.random()) * this.amplitude;
            ++i;
        }
        this.n -= (long)toCopy;
        return toCopy;
    }
}

