/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import marytts.util.data.BaseDoubleDataSource;
import marytts.util.data.BlockwiseDoubleDataSource;
import marytts.util.data.BufferedDoubleDataSource;
import marytts.util.data.DoubleDataSource;

public class SequenceDoubleDataSource
extends BaseDoubleDataSource {
    protected LinkedList sources = new LinkedList();

    public SequenceDoubleDataSource(DoubleDataSource[] inputSources) {
        this.dataLength = 0L;
        int i = 0;
        while (i < inputSources.length) {
            if (this.dataLength != -1L) {
                long dl = inputSources[i].getDataLength();
                this.dataLength = dl == -1L ? -1L : (this.dataLength += dl);
            }
            if (inputSources[i] instanceof BlockwiseDoubleDataSource) {
                this.sources.add(new BufferedDoubleDataSource(inputSources[i]));
            } else {
                this.sources.add(inputSources[i]);
            }
            ++i;
        }
    }

    public SequenceDoubleDataSource(List inputSources) {
        this(inputSources.toArray(new DoubleDataSource[0]));
    }

    @Override
    public boolean hasMoreData() {
        while (!this.sources.isEmpty() && !((DoubleDataSource)this.sources.getFirst()).hasMoreData()) {
            this.sources.removeFirst();
        }
        return !this.sources.isEmpty();
    }

    @Override
    public int available() {
        int available = 0;
        Iterator it = this.sources.iterator();
        while (it.hasNext()) {
            available += ((DoubleDataSource)it.next()).available();
        }
        return available;
    }

    @Override
    public int getData(double[] target, int targetPos, int length) {
        if (target.length - targetPos < length) {
            throw new IllegalArgumentException("Target array cannot hold enough data (" + (target.length - targetPos) + " left, but " + length + " requested)");
        }
        int copied = 0;
        while (!this.sources.isEmpty() && copied < length) {
            DoubleDataSource source = (DoubleDataSource)this.sources.getFirst();
            int read = source.getData(target, targetPos + copied, length - copied);
            if (read < length - copied) {
                assert (!source.hasMoreData());
                this.sources.removeFirst();
            }
            copied += read;
        }
        return copied;
    }
}

