/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.audio;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class MonoAudioInputStream
extends AudioInputStream {
    protected int inputChannels;
    protected int inputMode;
    protected AudioFormat newFormat;

    public MonoAudioInputStream(AudioInputStream input) {
        this(input, 3);
    }

    public MonoAudioInputStream(AudioInputStream input, int inputMode) {
        super(input, input.getFormat(), input.getFrameLength());
        this.newFormat = new AudioFormat(input.getFormat().getEncoding(), input.getFormat().getSampleRate(), input.getFormat().getSampleSizeInBits(), 1, input.getFormat().getFrameSize() / input.getFormat().getChannels(), input.getFormat().getFrameRate(), input.getFormat().isBigEndian());
        this.inputChannels = input.getFormat().getChannels();
        if (this.inputChannels < 2) {
            throw new IllegalArgumentException("expected more than one input channel!");
        }
        this.inputMode = inputMode;
        if (inputMode == 0) {
            throw new IllegalArgumentException("expected non-mono input mode");
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int sampleSizeInBytes;
        int outputFrameSize = sampleSizeInBytes = this.frameSize / this.inputChannels;
        int nFrames = len / outputFrameSize;
        boolean bigEndian = this.getFormat().isBigEndian();
        byte[] inputBytes = new byte[nFrames * this.frameSize];
        int nInputBytes = super.read(inputBytes, 0, inputBytes.length);
        if (nInputBytes <= 0) {
            return nInputBytes;
        }
        if (this.inputMode == 3) {
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                byte lobyte;
                byte hibyte;
                int sample = 0;
                int c = 0;
                while (c < this.inputChannels) {
                    byte lobyte2;
                    if (sampleSizeInBytes == 1) {
                        sample += inputBytes[i] << 8;
                    } else if (sampleSizeInBytes == 2) {
                        if (!bigEndian) {
                            lobyte2 = inputBytes[i];
                            hibyte = inputBytes[i + 1];
                        } else {
                            lobyte2 = inputBytes[i + 1];
                            hibyte = inputBytes[i];
                        }
                        sample += hibyte << 8 | lobyte2 & 0xFF;
                    } else {
                        byte hibyte2;
                        byte midbyte;
                        assert (sampleSizeInBytes == 3) : "Unsupported sample size in bytes: " + sampleSizeInBytes;
                        if (!bigEndian) {
                            lobyte2 = inputBytes[i];
                            midbyte = inputBytes[i + 1];
                            hibyte2 = inputBytes[i + 2];
                        } else {
                            lobyte2 = inputBytes[i + 2];
                            midbyte = inputBytes[i + 1];
                            hibyte2 = inputBytes[i];
                        }
                        sample += hibyte2 << 16 | (midbyte & 0xFF) << 8 | lobyte2 & 0xFF;
                    }
                    ++c;
                }
                sample /= this.inputChannels;
                if (sampleSizeInBytes == 1) {
                    b[j] = (byte)(sample >> 8 & 0xFF);
                } else if (sampleSizeInBytes == 2) {
                    lobyte = (byte)(sample & 0xFF);
                    byte hibyte3 = (byte)(sample >> 8);
                    if (!bigEndian) {
                        b[j] = lobyte;
                        b[j + 1] = hibyte3;
                    } else {
                        b[j] = hibyte3;
                        b[j + 1] = lobyte;
                    }
                } else {
                    assert (sampleSizeInBytes == 3) : "Unsupported sample size in bytes: " + sampleSizeInBytes;
                    lobyte = (byte)(sample & 0xFF);
                    byte midbyte = (byte)(sample >> 8 & 0xFF);
                    hibyte = (byte)(sample >> 16);
                    if (!bigEndian) {
                        b[j] = lobyte;
                        b[j + 1] = midbyte;
                        b[j + 2] = hibyte;
                    } else {
                        b[j] = hibyte;
                        b[j + 1] = midbyte;
                        b[j + 2] = lobyte;
                    }
                }
                i += this.frameSize;
                j += outputFrameSize;
            }
        } else if (this.inputMode == 1) {
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                int k = 0;
                while (k < sampleSizeInBytes) {
                    b[j + k] = inputBytes[i + k];
                    ++k;
                }
                i += this.frameSize;
                j += outputFrameSize;
            }
        } else {
            assert (this.inputMode == 2) : "unexpected input mode: " + this.inputMode;
            int i = 0;
            int j = off;
            while (i < nInputBytes) {
                int k = 0;
                while (k < sampleSizeInBytes) {
                    b[j + k] = inputBytes[i + k + sampleSizeInBytes];
                    ++k;
                }
                i += this.frameSize;
                j += outputFrameSize;
            }
        }
        return nInputBytes / this.inputChannels;
    }

    @Override
    public long skip(long n) throws IOException {
        return super.skip(n * (long)this.inputChannels) / (long)this.inputChannels;
    }

    @Override
    public int available() throws IOException {
        int av = super.available();
        if (av <= 0) {
            return av;
        }
        return av / this.inputChannels;
    }

    @Override
    public AudioFormat getFormat() {
        return this.newFormat;
    }
}

