/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import marytts.util.data.text.PraatTier;
import marytts.util.dom.DomUtils;
import marytts.util.string.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class PraatPitchTier
implements PraatTier {
    protected static final String FIRSTLINE = "File type = \"ooTextFile\"";
    protected static final String SECONDLINE = "Object class = \"PitchTier\"";
    protected double xmin;
    protected double xmax;
    protected int numTargets;
    protected PitchTarget[] targets;

    public PraatPitchTier(Reader input) throws IOException {
        try (BufferedReader lineReader = new BufferedReader(input);){
            String filetype = lineReader.readLine();
            if (!filetype.equals(FIRSTLINE)) {
                throw new IllegalArgumentException("First line expected to be 'File type = \"ooTextFile\"' but was '" + filetype + "'");
            }
            String subtype = lineReader.readLine();
            if (!subtype.equals(SECONDLINE)) {
                throw new IllegalArgumentException("Second line expected to be 'Object class = \"PitchTier\"' but was '" + subtype + "'");
            }
            lineReader.readLine();
            String xminLine = lineReader.readLine();
            String xmaxLine = lineReader.readLine();
            String numTargetsLine = lineReader.readLine();
            try {
                this.xmin = Double.parseDouble(xminLine);
                this.xmax = Double.parseDouble(xmaxLine);
                this.numTargets = Integer.parseInt(numTargetsLine);
            }
            catch (NumberFormatException numberFormatException) {
                String[] fields = xminLine.split("\\s+");
                this.xmin = Double.parseDouble(fields[fields.length - 1]);
                fields = xmaxLine.split("\\s+");
                this.xmax = Double.parseDouble(fields[fields.length - 1]);
                fields = numTargetsLine.split("\\s+");
                this.numTargets = Integer.parseInt(fields[fields.length - 1]);
            }
            this.targets = new PitchTarget[this.numTargets];
            int i = 0;
            while (i < this.numTargets) {
                String timeLine = lineReader.readLine();
                String freqLine = lineReader.readLine();
                try {
                    double time = Double.parseDouble(timeLine);
                    double freq = Double.parseDouble(freqLine);
                    this.targets[i] = new PitchTarget(time, freq);
                }
                catch (NumberFormatException numberFormatException) {
                    timeLine = freqLine;
                    freqLine = lineReader.readLine();
                    String[] fields = timeLine.split("\\s+");
                    double time = Double.parseDouble(fields[fields.length - 1]);
                    fields = freqLine.split("\\s+");
                    double freq = Double.parseDouble(fields[fields.length - 1]);
                    this.targets[i] = new PitchTarget(time, freq);
                }
                ++i;
            }
        }
    }

    public PraatPitchTier(double xmin, double[] frames, double step) {
        this.xmin = xmin;
        this.xmax = xmin + (double)(frames.length - 1) * step;
        this.importFrames(frames, step);
    }

    public PraatPitchTier(Document acoustparams) {
        this(PraatPitchTier.computePitchTargets(acoustparams));
    }

    private static PitchTarget[] computePitchTargets(Document acoustparams) {
        ArrayList<PitchTarget> targets = new ArrayList<PitchTarget>();
        String PHONE = "ph";
        String A_PHONE_DURATION = "d";
        String A_F0 = "f0";
        String BOUNDARY = "boundary";
        String A_BOUNDARY_DURATION = "duration";
        NodeIterator it = DomUtils.createNodeIterator((Node)acoustparams, (String[])new String[]{PHONE, BOUNDARY});
        Element e = null;
        double startTime = 0.0;
        double endTime = 0.0;
        double duration = 0.0;
        while ((e = (Element)it.nextNode()) != null) {
            startTime = endTime;
            if (!e.getTagName().equals(PHONE)) {
                duration = 0.001 * Double.parseDouble(e.getAttribute(A_BOUNDARY_DURATION));
                endTime = startTime + duration;
                continue;
            }
            duration = 0.001 * Double.parseDouble(e.getAttribute(A_PHONE_DURATION));
            endTime = startTime + duration;
            assert (e.getTagName().equals(PHONE));
            assert (startTime < endTime) : "for phone '" + e.getAttribute("p") + "', startTime " + startTime + " is not less than endTime " + endTime;
            String f0String = e.getAttribute(A_F0).trim();
            if (f0String.isEmpty()) continue;
            int[] localF0Targets = StringUtils.parseIntPairs((String)f0String);
            int i = 0;
            int len = localF0Targets.length / 2;
            while (i < len) {
                int percent = localF0Targets[2 * i];
                int hertz = localF0Targets[2 * i + 1];
                double time = startTime + 0.01 * (double)percent * (endTime - startTime);
                targets.add(new PitchTarget(time, hertz));
                ++i;
            }
        }
        return targets.toArray(new PitchTarget[0]);
    }

    public PraatPitchTier(PitchTarget[] targets) {
        this.targets = targets;
        this.numTargets = targets.length;
        this.xmin = targets[0].time;
        this.xmax = targets[targets.length - 1].time;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public double getXmax() {
        return this.xmax;
    }

    public void setXmax(double value) {
        this.xmax = value;
    }

    @Override
    public double getXmin() {
        return this.xmin;
    }

    public void setXmin(double value) {
        this.xmin = value;
    }

    public int getNumTargets() {
        return this.numTargets;
    }

    public PitchTarget[] getPitchTargets() {
        return this.targets;
    }

    public void writeTo(Writer out) {
        try (PrintWriter pw = new PrintWriter(out);){
            pw.println(FIRSTLINE);
            pw.println(SECONDLINE);
            pw.println();
            pw.println(this.xmin);
            pw.println(this.xmax);
            pw.println(this.numTargets);
            int i = 0;
            while (i < this.numTargets) {
                pw.println(this.targets[i].time);
                pw.println(this.targets[i].frequency);
                ++i;
            }
        }
    }

    public double[] toFrames(double step) {
        int numFrames = (int)((this.xmax - this.xmin) / step) + 1;
        assert (this.xmin + (double)(numFrames - 1) * step <= this.xmax);
        double[] frames = new double[numFrames];
        double t = this.xmin;
        int i = 0;
        while (i < frames.length) {
            frames[i] = this.getFrequency(t);
            t += step;
            ++i;
        }
        return frames;
    }

    public double getFrequency(double time) {
        PitchTarget prev = null;
        PitchTarget current = null;
        int j = 0;
        while (j < this.targets.length) {
            if (time <= this.targets[j].time) {
                current = this.targets[j];
                if (j <= 0) break;
                prev = this.targets[j - 1];
                break;
            }
            ++j;
        }
        if (current == null) {
            return Double.NaN;
        }
        if (Math.abs(time - current.time) < 1.0E-7) {
            return current.frequency;
        }
        if (prev == null) {
            return Double.NaN;
        }
        assert (prev != null);
        double deltaT = current.time - prev.time;
        double deltaF = current.frequency - prev.frequency;
        return prev.frequency + (time - prev.time) / deltaT * deltaF;
    }

    protected void importFrames(double[] frames, double step) {
        ArrayList<PitchTarget> newTargets = new ArrayList<PitchTarget>();
        double t = this.xmin;
        int i = 0;
        while (i < frames.length) {
            if (!Double.isNaN(frames[i])) {
                newTargets.add(new PitchTarget(t, frames[i]));
            }
            t += step;
            ++i;
        }
        this.targets = newTargets.toArray(new PitchTarget[0]);
        this.numTargets = this.targets.length;
    }

    public boolean equals(Object otherObj) {
        if (this == otherObj) {
            return true;
        }
        if (!(otherObj instanceof PraatPitchTier)) {
            return false;
        }
        PraatPitchTier other = (PraatPitchTier)otherObj;
        if (this.xmin == other.xmin && this.xmax == other.xmax && this.numTargets == other.numTargets) {
            return Arrays.equals(this.targets, other.targets);
        }
        return false;
    }

    public int hashCode() {
        int hash = 31 + Integer.parseInt(Double.toString(this.xmin + this.xmax)) + this.numTargets + Arrays.hashCode(this.targets);
        return hash;
    }

    public static class PitchTarget {
        public final double time;
        public final double frequency;

        public PitchTarget(double time, double frequency) {
            this.time = time;
            this.frequency = frequency;
        }

        public boolean equals(Object otherObj) {
            if (this == otherObj) {
                return true;
            }
            if (!(otherObj instanceof PitchTarget)) {
                return false;
            }
            PitchTarget other = (PitchTarget)otherObj;
            return this.time == other.time && this.frequency == other.frequency;
        }

        public int hashCode() {
            int hash = 31 + Integer.parseInt(Double.toString(this.time + this.frequency));
            return hash;
        }
    }
}

