/*
 * Decompiled with CFR 0.152.
 */
package marytts.util.data.text;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.signalproc.analysis.Label;
import marytts.signalproc.analysis.Labels;

public class XwavesLabelfileReader {
    protected BufferedReader reader;
    protected Double[] times;
    protected String[] labels;
    protected String[] header;

    public XwavesLabelfileReader(String filename) throws IOException {
        this(new FileReader(filename));
    }

    public XwavesLabelfileReader(Reader reader) throws IOException {
        this.reader = new BufferedReader(reader);
        this.parseLabels();
        reader.close();
    }

    private void parseLabels() throws IOException {
        String line;
        boolean headerComplete = false;
        ArrayList<Double> timesList = new ArrayList<Double>();
        ArrayList<String> labelsList = new ArrayList<String>();
        ArrayList<String> headersList = new ArrayList<String>();
        Pattern linePattern = Pattern.compile("^\\s*(\\d+(?:\\.\\d+)?)\\s+.+?\\s+?(.*)$");
        boolean matches = false;
        String timeStr = null;
        String label = null;
        while ((line = this.reader.readLine()) != null) {
            Matcher lineMatcher = linePattern.matcher(line);
            matches = lineMatcher.matches();
            if (matches) {
                headerComplete = true;
                timeStr = lineMatcher.group(1);
                label = lineMatcher.group(2);
                double time = Double.parseDouble(timeStr);
                timesList.add(time);
                labelsList.add(label);
                continue;
            }
            if (!headerComplete) {
                if (line.trim().startsWith("#")) {
                    headerComplete = true;
                    continue;
                }
                headersList.add(line);
                continue;
            }
            System.err.println("Malformed line found outside of header:\n" + line);
            throw new IOException();
        }
        assert (timesList.size() == labelsList.size()) : "";
        this.times = new Double[timesList.size()];
        int t = 0;
        while (t < timesList.size()) {
            this.times[t] = (Double)timesList.get(t);
            ++t;
        }
        this.labels = labelsList.toArray(new String[0]);
        this.header = headersList.toArray(new String[0]);
    }

    public Double[] getTimes() {
        return this.times;
    }

    public String[] getLabelSymbols() {
        return this.labels;
    }

    public Labels getLabels() {
        Label[] items = new Label[this.labels.length];
        assert (this.times.length == this.labels.length);
        int i = 0;
        while (i < items.length) {
            items[i] = new Label(this.times[i], this.labels[i]);
            ++i;
        }
        return new Labels(items);
    }

    public String[] getHeader() {
        return this.header;
    }
}

