/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.community.store.embedding.alloydb;

import dev.langchain4j.community.store.embedding.alloydb.MetadataColumn;
import dev.langchain4j.internal.ValidationUtils;
import java.util.List;

public class EmbeddingStoreConfig {
    private final String tableName;
    private final Integer vectorSize;
    private final String schemaName;
    private final String contentColumn;
    private final String embeddingColumn;
    private final String idColumn;
    private final List<MetadataColumn> metadataColumns;
    private final String metadataJsonColumn;
    private final Boolean overwriteExisting;
    private final Boolean storeMetadata;

    private EmbeddingStoreConfig(Builder builder) {
        ValidationUtils.ensureNotBlank((String)builder.tableName, (String)"tableName");
        ValidationUtils.ensureGreaterThanZero((Integer)builder.vectorSize, (String)"vectorSize");
        this.contentColumn = builder.contentColumn;
        this.embeddingColumn = builder.embeddingColumn;
        this.idColumn = builder.idColumn;
        this.metadataColumns = builder.metadataColumns;
        this.metadataJsonColumn = builder.metadataJsonColumn;
        this.overwriteExisting = builder.overwriteExisting;
        this.schemaName = builder.schemaName;
        this.storeMetadata = builder.storeMetadata;
        this.tableName = builder.tableName;
        this.vectorSize = builder.vectorSize;
    }

    public String getTableName() {
        return this.tableName;
    }

    public Integer getVectorSize() {
        return this.vectorSize;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getContentColumn() {
        return this.contentColumn;
    }

    public String getEmbeddingColumn() {
        return this.embeddingColumn;
    }

    public String getIdColumn() {
        return this.idColumn;
    }

    public List<MetadataColumn> getMetadataColumns() {
        return this.metadataColumns;
    }

    public String getMetadataJsonColumn() {
        return this.metadataJsonColumn;
    }

    public Boolean getOverwriteExisting() {
        return this.overwriteExisting;
    }

    public Boolean getStoreMetadata() {
        return this.storeMetadata;
    }

    public static Builder builder(String tableName, Integer vectorSize) {
        return new Builder(tableName, vectorSize);
    }

    public static class Builder {
        private final String tableName;
        private final Integer vectorSize;
        private String schemaName = "public";
        private String contentColumn = "content";
        private String embeddingColumn = "embedding";
        private String idColumn = "langchain4j_id";
        private List<MetadataColumn> metadataColumns;
        private String metadataJsonColumn = "langchain4j_metadata";
        private Boolean overwriteExisting = false;
        private Boolean storeMetadata = true;

        public Builder(String tableName, Integer vectorSize) {
            this.tableName = tableName;
            this.vectorSize = vectorSize;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder contentColumn(String contentColumn) {
            this.contentColumn = contentColumn;
            return this;
        }

        public Builder embeddingColumn(String embeddingColumn) {
            this.embeddingColumn = embeddingColumn;
            return this;
        }

        public Builder idColumn(String idColumn) {
            this.idColumn = idColumn;
            return this;
        }

        public Builder metadataColumns(List<MetadataColumn> metadataColumns) {
            this.metadataColumns = metadataColumns;
            return this;
        }

        public Builder metadataJsonColumn(String metadataJsonColumn) {
            this.metadataJsonColumn = metadataJsonColumn;
            return this;
        }

        public Builder overwriteExisting(Boolean overwriteExisting) {
            this.overwriteExisting = overwriteExisting;
            return this;
        }

        public Builder storeMetadata(Boolean storeMetadata) {
            this.storeMetadata = storeMetadata;
            return this;
        }

        public EmbeddingStoreConfig build() {
            return new EmbeddingStoreConfig(this);
        }
    }
}

