/*
 * Decompiled with CFR 0.152.
 */
package com.gm.sm2;

import com.gm.sm2.SM2Constants;
import java.math.BigInteger;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.encoders.Hex;

public class SM2SignResult {
    private byte[] a;
    private byte[] b;

    public SM2SignResult() {
    }

    public SM2SignResult(byte[] byArray, byte[] byArray2) {
        this.a = byArray;
        this.b = byArray2;
    }

    public byte[] getSignR() {
        return this.a;
    }

    public byte[] getSignS() {
        return this.b;
    }

    public byte[] mergeRS() {
        byte[] byArray = new byte[this.a.length + this.b.length];
        System.arraycopy(this.a, 0, byArray, 0, this.a.length);
        System.arraycopy(this.b, 0, byArray, this.a.length, this.b.length);
        return byArray;
    }

    public byte[] encodeStandardDSA() throws Exception {
        return this.a((DSAEncoding)StandardDSAEncoding.INSTANCE);
    }

    public byte[] encodePlainDSA() throws Exception {
        return this.a((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public void decodeStandardDSA(byte[] byArray) throws Exception {
        this.a((DSAEncoding)StandardDSAEncoding.INSTANCE, byArray);
    }

    public void decodePlainDSA(byte[] byArray) throws Exception {
        this.a((DSAEncoding)PlainDSAEncoding.INSTANCE, byArray);
    }

    private byte[] a(DSAEncoding dSAEncoding) throws Exception {
        BigInteger bigInteger = new BigInteger(Hex.toHexString((byte[])this.getSignR()), 16);
        BigInteger bigInteger2 = new BigInteger(Hex.toHexString((byte[])this.getSignS()), 16);
        return dSAEncoding.encode(SM2Constants.SM2_ECC_N, bigInteger, bigInteger2);
    }

    private void a(DSAEncoding dSAEncoding, byte[] byArray) throws Exception {
        BigInteger[] bigIntegerArray = dSAEncoding.decode(SM2Constants.SM2_ECC_N, byArray);
        this.a = bigIntegerArray[0].toByteArray();
        this.b = bigIntegerArray[1].toByteArray();
    }
}

