/*
 * Decompiled with CFR 0.152.
 */
package fish.payara.arquillian.container.payara.managed;

import fish.payara.arquillian.container.payara.CommonPayaraConfiguration;
import fish.payara.arquillian.container.payara.PayaraVersion;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;

public class PayaraMicroContainerConfiguration
extends CommonPayaraConfiguration {
    private String microJar = PayaraMicroContainerConfiguration.getConfigurableVariable("payara.microJar", "MICRO_JAR", null);
    private PayaraVersion microVersion = null;
    private boolean enterprise = false;
    private int startupTimeoutInSeconds = Integer.parseInt(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.startupTimeoutInSeconds", "MICRO_STARTUP_TIMEOUT_IN_SECONDS", "180"));
    private boolean clusterEnabled = Boolean.parseBoolean(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.clusterEnabled", "MICRO_CLUSTER_ENABLED", "false"));
    private boolean randomHttpPort = Boolean.parseBoolean(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.randomHttpPort", "MICRO_RANDOM_HTTP_PORT", "true"));
    private boolean autoBindHttp = Boolean.parseBoolean(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.autoBindHttp", "MICRO_AUTOBIND_HTTP", "true"));
    private boolean outputToConsole = Boolean.parseBoolean(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.consoleOutput", "MICRO_CONSOLE_OUTPUT", "true"));
    private String cmdOptions = PayaraMicroContainerConfiguration.getConfigurableVariable("payara.cmdOptions", "MICRO_CMD_OPTIONS", null);
    private String extraMicroOptions = PayaraMicroContainerConfiguration.getConfigurableVariable("payara.extraMicroOptions", "EXTRA_MICRO_OPTIONS", null);
    private boolean microOnClasspath;
    private final String ZIP_ENTRY_FILE_DIR = "MICRO-INF/domain/branding/glassfish-version.properties";

    public PayaraMicroContainerConfiguration() {
        this.debug = Boolean.parseBoolean(PayaraMicroContainerConfiguration.getConfigurableVariable("payara.debug", "MICRO_DEBUG", "false"));
    }

    public String getMicroJar() {
        URL microUrl;
        if (this.microJar == null && (microUrl = ((Object)((Object)this)).getClass().getClassLoader().getResource("fish/payara/micro/PayaraMicro.class")) != null && microUrl.getProtocol().equals("jar") && microUrl.getPath().startsWith("file:")) {
            String path = microUrl.getPath();
            this.microOnClasspath = true;
            this.microJar = path.substring(5, path.indexOf(33));
        }
        return this.microJar;
    }

    boolean isMicroOnClasspath() {
        return this.microOnClasspath;
    }

    public File getMicroJarFile() {
        return new File(this.getMicroJar());
    }

    public PayaraVersion getMicroVersion() {
        return this.microVersion;
    }

    public void setMicroJar(String microJar) {
        this.microJar = microJar;
    }

    public boolean isClusterEnabled() {
        return this.clusterEnabled;
    }

    public void setClusterEnabled(boolean clusterEnabled) {
        this.clusterEnabled = clusterEnabled;
    }

    public void setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public void setRandomHttpPort(boolean randomHttpPort) {
        this.randomHttpPort = randomHttpPort;
    }

    public boolean isRandomHttpPort() {
        return this.randomHttpPort;
    }

    public boolean isAutoBindHttp() {
        return this.autoBindHttp;
    }

    public void setAutoBindHttp(boolean autoBindHttp) {
        this.autoBindHttp = autoBindHttp;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public void setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
    }

    public String getCmdOptions() {
        return this.cmdOptions;
    }

    public void setCmdOptions(String cmdOptions) {
        this.cmdOptions = cmdOptions;
    }

    public String getExtraMicroOptions() {
        return this.extraMicroOptions;
    }

    public void setExtraMicroOptions(String extraMicroOptions) {
        this.extraMicroOptions = extraMicroOptions;
    }

    public boolean isEnterprise() {
        return this.enterprise;
    }

    public void validate() throws ConfigurationException {
        Validate.notNull((Object)this.getMicroJar(), (String)"The property payara.microJar must be specified or the MICRO_JAR environment variable must be set");
        if (!this.getMicroJarFile().isFile()) {
            throw new IllegalArgumentException("Could not locate the Payara Micro Jar file " + this.getMicroJar());
        }
        try (JarFile microJarFile = new JarFile(this.getMicroJarFile());){
            ZipEntry pomProperties = microJarFile.getEntry("MICRO-INF/domain/branding/glassfish-version.properties");
            Properties microProperties = new Properties();
            microProperties.load(microJarFile.getInputStream(pomProperties));
            this.microVersion = PayaraVersion.buildVersionFromBrandingProperties((String)microProperties.getProperty("major_version"), (String)microProperties.getProperty("minor_version"), (String)microProperties.getProperty("update_version"), (String)microProperties.getProperty("payara_version"), (String)microProperties.getProperty("payara_update_version"));
            this.enterprise = microProperties.getProperty("product_name").contains("Enterprise");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to find Payara Micro Version. Please check the file is a valid Payara Micro Jar.", e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Unable to find Payara Micro Version. Please check the file is a valid Payara Micro Jar.\nProperties File Used: MICRO-INF/domain/branding/glassfish-version.properties", e);
        }
        Validate.notNull((Object)this.getMicroVersion(), (String)"Unable to find Payara Micro Jar version. Please check the file is a valid Payara Micro Jar.");
        if (this.cmdOptions != null) {
            this.cmdOptions = this.escapePaths(this.cmdOptions);
        }
        if (this.extraMicroOptions != null) {
            this.extraMicroOptions = this.escapePaths(this.extraMicroOptions);
        }
    }

    private String escapePaths(String input) {
        Pattern pathPattern = Pattern.compile("((?>[\\/\\\\]|\\\\ )[\\w ]+) ([^-])");
        Matcher matcher = pathPattern.matcher(input);
        String output = input;
        while (matcher.find()) {
            output = matcher.replaceAll("$1\\\\ $2");
            matcher = pathPattern.matcher(output);
        }
        return output;
    }

    private static String getConfigurableVariable(String systemPropertyName, String environmentVariableName, String defaultValue) {
        String systemProperty = System.getProperty(systemPropertyName);
        String environmentProperty = System.getenv(environmentVariableName);
        if (systemProperty == null || systemProperty.isEmpty()) {
            if (environmentProperty == null || environmentProperty.isEmpty()) {
                if (defaultValue == null || defaultValue.isEmpty()) {
                    return null;
                }
                return defaultValue;
            }
            return environmentProperty;
        }
        return systemProperty;
    }
}

