/*
 * Decompiled with CFR 0.152.
 */
package fr.delthas.javamp3;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

final class Decoder {
    private static final float INV_SQUARE_2 = 0.70710677f;
    private static final int[] BITRATE_LAYER_I;
    private static final int[] BITRATE_LAYER_II;
    private static final int[] BITRATE_LAYER_III;
    private static final int[] SAMPLING_FREQUENCY;
    private static final float[] SCALEFACTORS;
    private static final int[] SCALEFACTOR_SIZES_LAYER_III;
    private static final int[] SCALEFACTOR_BAND_INDICES_LAYER_III;
    private static final float[] CS_ALIASING_LAYER_III;
    private static final float[] CA_ALIASING_LAYER_III;
    private static final float[] POWTAB_LAYER_III;
    private static final float[] IS_RATIOS_LAYER_III;
    private static final float[] IMDCT_WINDOW_LAYER_III;
    private static final float[] PRE_FRACTOR_LAYER_I;
    private static final float[] NIK_COEFFICIENTS;
    private static final float[] SYNTH_WINDOW_TABLE_LAYER_III;
    private static final float[] DI_COEFFICIENTS;
    private static final int[] SHIFT_ENDIANESS;
    private static final int[] SB_LIMIT;
    private static final int[][] NBAL;
    private static final int[][][] QUANTIZATION_INDEX_LAYER_II;
    private static final int[] NLEVELS;
    private static final float[] C_LAYER_II;
    private static final float[] D_LAYER_II;
    private static final boolean[] GROUPING_LAYER_II;
    private static final int[] BITS_LAYER_II;
    private static final int[] HUFFMAN_TABLE_LAYER_III;
    private static final int[] HUFFMAN_TABLE_OFFSET_LAYER_III;
    private static final int[] HUFFMAN_TREELEN_LAYER_III;
    private static final int[] HUFFMAN_LINBITS_LAYER_III;
    private static final float[] REQUANTIZE_LONG_PRETAB_LAYER_III;
    private static final float[] COS_12_LAYER_III;
    private static final float[] COS_36_LAYER_III;

    private Decoder() {
        throw new IllegalStateException("This class cannot be instantiated!");
    }

    public static SoundData init(InputStream in) throws IOException {
        SoundData soundData = new SoundData();
        soundData.buffer = new Buffer(in);
        ((SoundData)soundData).buffer.lastByte = ((SoundData)soundData).buffer.in.read();
        if (!Decoder.decodeFrame(soundData)) {
            return null;
        }
        return soundData;
    }

    public static boolean decodeFrame(SoundData soundData) throws IOException {
        int bound;
        block33: {
            if (((SoundData)soundData).buffer.lastByte == -1) {
                return false;
            }
            while (true) {
                int read = ((SoundData)soundData).buffer.lastByte;
                ((SoundData)soundData).buffer.lastByte = ((SoundData)soundData).buffer.in.read();
                if (((SoundData)soundData).buffer.lastByte == -1) {
                    return false;
                }
                if (read != 255) continue;
                if (((SoundData)soundData).buffer.lastByte >>> 4 == 15) break block33;
                ((SoundData)soundData).buffer.lastByte = ((SoundData)soundData).buffer.in.read();
                if (((SoundData)soundData).buffer.lastByte == -1) break;
            }
            return false;
        }
        ((SoundData)soundData).buffer.current = 4;
        int id = Decoder.read(soundData.buffer, 1);
        int layer = Decoder.read(soundData.buffer, 2);
        int protectionBit = Decoder.read(soundData.buffer, 1);
        int bitrateIndex = Decoder.read(soundData.buffer, 4);
        int samplingFrequency = Decoder.read(soundData.buffer, 2);
        int paddingBit = Decoder.read(soundData.buffer, 1);
        int privateBit = Decoder.read(soundData.buffer, 1);
        int mode = Decoder.read(soundData.buffer, 2);
        int modeExtension = Decoder.read(soundData.buffer, 2);
        Decoder.read(soundData.buffer, 4);
        if (soundData.frequency == -1) {
            soundData.frequency = SAMPLING_FREQUENCY[samplingFrequency];
        }
        if (soundData.stereo == -1) {
            soundData.stereo = mode == 3 ? 0 : 1;
            if (layer == 1) {
                if (mode == 3) {
                    SoundData.access$102(soundData, new byte[1024]);
                    SoundData.access$202(soundData, new float[576]);
                    SoundData.access$302(soundData, new float[1024]);
                } else {
                    SoundData.access$102(soundData, new byte[2048]);
                    SoundData.access$202(soundData, new float[1152]);
                    SoundData.access$302(soundData, new float[2048]);
                }
                soundData.mainDataReader = new MainDataReader(soundData.mainData);
            } else if (mode == 3) {
                SoundData.access$502(soundData, new int[]{64});
                SoundData.access$602(soundData, new float[1024]);
            } else {
                SoundData.access$502(soundData, new int[]{64, 64});
                SoundData.access$602(soundData, new float[2048]);
            }
        }
        int n = modeExtension == 0 ? 4 : (modeExtension == 1 ? 8 : (modeExtension == 2 ? 12 : (bound = modeExtension == 3 ? 16 : -1)));
        if (protectionBit == 0) {
            Decoder.read(soundData.buffer, 16);
        }
        if (layer == 3) {
            float[] sampleDecoded = null;
            if (mode == 3) {
                sampleDecoded = Decoder.samples_I(soundData.buffer, 1, -1);
            } else if (mode == 0 || mode == 2) {
                sampleDecoded = Decoder.samples_I(soundData.buffer, 2, -1);
            } else if (mode == 1) {
                sampleDecoded = Decoder.samples_I(soundData.buffer, 2, bound);
            }
            if (mode == 3) {
                Decoder.synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 1);
            } else {
                Decoder.synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 2);
            }
        } else if (layer == 2) {
            float[] sampleDecoded = null;
            int bitrate = BITRATE_LAYER_II[bitrateIndex];
            if (mode == 3) {
                sampleDecoded = Decoder.samples_II(soundData.buffer, 1, -1, bitrate, soundData.frequency);
            } else if (mode == 0 || mode == 2) {
                sampleDecoded = Decoder.samples_II(soundData.buffer, 2, -1, bitrate, soundData.frequency);
            } else if (mode == 1) {
                sampleDecoded = Decoder.samples_II(soundData.buffer, 2, bound, bitrate, soundData.frequency);
            }
            if (mode == 3) {
                Decoder.synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 1);
            } else {
                Decoder.synth(soundData, sampleDecoded, soundData.synthOffset, soundData.synthBuffer, 2);
            }
        } else if (layer == 1) {
            int frameSize = 144 * BITRATE_LAYER_III[bitrateIndex] / SAMPLING_FREQUENCY[samplingFrequency] + paddingBit;
            if (frameSize > 2000) {
                System.err.println("Frame too large! " + frameSize);
            }
            Decoder.samples_III(soundData.buffer, soundData.stereo == 1 ? 2 : 1, soundData.mainDataReader, frameSize, samplingFrequency, mode, modeExtension, soundData.store, soundData.v, soundData);
        }
        if (((SoundData)soundData).buffer.current != 0) {
            Decoder.read(soundData.buffer, 8 - ((SoundData)soundData).buffer.current);
        }
        return true;
    }

    private static void samples_III(Buffer buffer, int stereo, MainDataReader mainDataReader, int frameSize, int samplingFrequency, int mode, int modeExtension, float[] store, float[] v, SoundData soundData) throws IOException {
        int ch;
        int gr;
        int[] scfsi = new int[stereo * 4];
        int[] part2_3_length = new int[stereo * 2];
        int[] big_values = new int[stereo * 2];
        int[] global_gain = new int[stereo * 2];
        int[] scalefac_compress = new int[stereo * 2];
        int[] win_switch_flag = new int[stereo * 2];
        int[] block_type = new int[stereo * 2];
        int[] mixed_block_flag = new int[stereo * 2];
        int[] table_select = new int[stereo * 2 * 3];
        int[] subblock_gain = new int[stereo * 2 * 3];
        int[] region0_count = new int[stereo * 2];
        int[] region1_count = new int[stereo * 2];
        int[] preflag = new int[stereo * 2];
        int[] scalefac_scale = new int[stereo * 2];
        int[] count1table_select = new int[stereo * 2];
        int[] count1 = new int[stereo * 2];
        int[] scalefac_l = new int[stereo * 2 * 21];
        int[] scalefac_s = new int[stereo * 2 * 12 * 3];
        float[] is = new float[stereo * 2 * 576];
        int mainDataBegin = Decoder.read(buffer, 9);
        Decoder.read(buffer, stereo == 1 ? 5 : 3);
        for (int ch2 = 0; ch2 < stereo; ++ch2) {
            for (int scaleband = 0; scaleband < 4; ++scaleband) {
                scfsi[ch2 * 4 + scaleband] = Decoder.read(buffer, 1);
            }
        }
        for (int gr2 = 0; gr2 < 2; ++gr2) {
            for (int ch3 = 0; ch3 < stereo; ++ch3) {
                int region;
                part2_3_length[ch3 * 2 + gr2] = Decoder.read(buffer, 12);
                big_values[ch3 * 2 + gr2] = Decoder.read(buffer, 9);
                global_gain[ch3 * 2 + gr2] = Decoder.read(buffer, 8);
                scalefac_compress[ch3 * 2 + gr2] = Decoder.read(buffer, 4);
                win_switch_flag[ch3 * 2 + gr2] = Decoder.read(buffer, 1);
                if (win_switch_flag[ch3 * 2 + gr2] == 1) {
                    block_type[ch3 * 2 + gr2] = Decoder.read(buffer, 2);
                    mixed_block_flag[ch3 * 2 + gr2] = Decoder.read(buffer, 1);
                    for (region = 0; region < 2; ++region) {
                        table_select[ch3 * 2 * 3 + gr2 * 3 + region] = Decoder.read(buffer, 5);
                    }
                    for (int window = 0; window < 3; ++window) {
                        subblock_gain[ch3 * 2 * 3 + gr2 * 3 + window] = Decoder.read(buffer, 3);
                    }
                    region0_count[ch3 * 2 + gr2] = block_type[ch3 * 2 + gr2] == 2 && mixed_block_flag[ch3 * 2 + gr2] == 0 ? 8 : 7;
                    region1_count[ch3 * 2 + gr2] = 20 - region0_count[ch3 * 2 + gr2];
                } else {
                    for (region = 0; region < 3; ++region) {
                        table_select[ch3 * 2 * 3 + gr2 * 3 + region] = Decoder.read(buffer, 5);
                    }
                    region0_count[ch3 * 2 + gr2] = Decoder.read(buffer, 4);
                    region1_count[ch3 * 2 + gr2] = Decoder.read(buffer, 3);
                    block_type[ch3 * 2 + gr2] = 0;
                }
                preflag[ch3 * 2 + gr2] = Decoder.read(buffer, 1);
                scalefac_scale[ch3 * 2 + gr2] = Decoder.read(buffer, 1);
                count1table_select[ch3 * 2 + gr2] = Decoder.read(buffer, 1);
            }
        }
        System.arraycopy(mainDataReader.array, mainDataReader.top - mainDataBegin, mainDataReader.array, 0, mainDataBegin);
        int mainDataSize = frameSize - (stereo == 2 ? 32 : 17) - 4;
        Decoder.readInto(buffer, mainDataReader.array, mainDataBegin, mainDataSize);
        mainDataReader.index = 0;
        mainDataReader.current = 0;
        mainDataReader.top = mainDataBegin + mainDataSize;
        for (gr = 0; gr < 2; ++gr) {
            for (ch = 0; ch < stereo; ++ch) {
                int table_num;
                int is_pos;
                int region_2_start;
                int region_1_start;
                int sfb;
                int part_2_start = mainDataReader.index * 8 + mainDataReader.current;
                int slen1 = SCALEFACTOR_SIZES_LAYER_III[scalefac_compress[ch * 2 + gr] * 2];
                int slen2 = SCALEFACTOR_SIZES_LAYER_III[scalefac_compress[ch * 2 + gr] * 2 + 1];
                if (win_switch_flag[ch * 2 + gr] != 0 && block_type[ch * 2 + gr] == 2) {
                    int win;
                    int nbits;
                    if (mixed_block_flag[ch * 2 + gr] != 0) {
                        for (sfb = 0; sfb < 8; ++sfb) {
                            scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = Decoder.read(mainDataReader, slen1);
                        }
                        for (sfb = 3; sfb < 12; ++sfb) {
                            nbits = sfb < 6 ? slen1 : slen2;
                            for (win = 0; win < 3; ++win) {
                                scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win] = Decoder.read(mainDataReader, nbits);
                            }
                        }
                    } else {
                        for (sfb = 0; sfb < 12; ++sfb) {
                            nbits = sfb < 6 ? slen1 : slen2;
                            for (win = 0; win < 3; ++win) {
                                scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win] = Decoder.read(mainDataReader, nbits);
                            }
                        }
                    }
                } else {
                    if (scfsi[ch * 4 + 0] == 0 || gr == 0) {
                        for (sfb = 0; sfb < 6; ++sfb) {
                            scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = Decoder.read(mainDataReader, slen1);
                        }
                    } else if (scfsi[ch * 4 + 0] == 1 && gr == 1) {
                        for (sfb = 0; sfb < 6; ++sfb) {
                            scalefac_l[ch * 2 * 21 + 21 + sfb] = scalefac_l[ch * 2 * 21 + 0 + sfb];
                        }
                    }
                    if (scfsi[ch * 4 + 1] == 0 || gr == 0) {
                        for (sfb = 6; sfb < 11; ++sfb) {
                            scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = Decoder.read(mainDataReader, slen1);
                        }
                    } else if (scfsi[ch * 4 + 1] == 1 && gr == 1) {
                        for (sfb = 6; sfb < 11; ++sfb) {
                            scalefac_l[ch * 2 * 21 + 21 + sfb] = scalefac_l[ch * 2 * 21 + 0 + sfb];
                        }
                    }
                    if (scfsi[ch * 4 + 2] == 0 || gr == 0) {
                        for (sfb = 11; sfb < 16; ++sfb) {
                            scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = Decoder.read(mainDataReader, slen2);
                        }
                    } else if (scfsi[ch * 4 + 2] == 1 && gr == 1) {
                        for (sfb = 11; sfb < 16; ++sfb) {
                            scalefac_l[ch * 2 * 21 + 21 + sfb] = scalefac_l[ch * 2 * 21 + 0 + sfb];
                        }
                    }
                    if (scfsi[ch * 4 + 3] == 0 || gr == 0) {
                        for (sfb = 16; sfb < 21; ++sfb) {
                            scalefac_l[ch * 2 * 21 + gr * 21 + sfb] = Decoder.read(mainDataReader, slen2);
                        }
                    } else if (scfsi[ch * 4 + 3] == 1 && gr == 1) {
                        for (sfb = 16; sfb < 21; ++sfb) {
                            scalefac_l[ch * 2 * 21 + 21 + sfb] = scalefac_l[ch * 2 * 21 + 0 + sfb];
                        }
                    }
                }
                if (part2_3_length[ch * 2 + gr] == 0) continue;
                int bit_pos_end = part_2_start + part2_3_length[ch * 2 + gr] - 1;
                int[] huffman = new int[4];
                if (win_switch_flag[ch * 2 + gr] == 1 && block_type[ch * 2 + gr] == 2) {
                    region_1_start = 36;
                    region_2_start = 576;
                } else {
                    region_1_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + region0_count[ch * 2 + gr] + 1];
                    region_2_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + region0_count[ch * 2 + gr] + region1_count[ch * 2 + gr] + 2];
                }
                for (is_pos = 0; is_pos < big_values[ch * 2 + gr] * 2; ++is_pos) {
                    table_num = is_pos < region_1_start ? table_select[ch * 2 * 3 + gr * 3 + 0] : (is_pos < region_2_start ? table_select[ch * 2 * 3 + gr * 3 + 1] : table_select[ch * 2 * 3 + gr * 3 + 2]);
                    Decoder.huffman_III(mainDataReader, table_num, huffman);
                    is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[0];
                    is[ch * 2 * 576 + gr * 576 + is_pos] = huffman[1];
                }
                table_num = count1table_select[ch * 2 + gr] + 32;
                for (is_pos = big_values[ch * 2 + gr] * 2; is_pos <= 572 && mainDataReader.index * 8 + mainDataReader.current <= bit_pos_end; ++is_pos) {
                    Decoder.huffman_III(mainDataReader, table_num, huffman);
                    is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[2];
                    if (is_pos >= 576) break;
                    is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[3];
                    if (is_pos >= 576) break;
                    is[ch * 2 * 576 + gr * 576 + is_pos++] = huffman[0];
                    if (is_pos >= 576) break;
                    is[ch * 2 * 576 + gr * 576 + is_pos] = huffman[1];
                }
                if (mainDataReader.index * 8 + mainDataReader.current > bit_pos_end + 1) {
                    is_pos -= 4;
                }
                count1[ch * 2 + gr] = is_pos;
                while (is_pos < 576) {
                    is[ch * 2 * 576 + gr * 576 + is_pos] = 0.0f;
                    ++is_pos;
                }
                mainDataReader.index = (bit_pos_end + 1) / 8;
                mainDataReader.current = (bit_pos_end + 1) % 8;
            }
        }
        if (soundData.samplesBuffer == null) {
            soundData.samplesBuffer = new byte[1152 * stereo * 2];
        }
        for (gr = 0; gr < 2; ++gr) {
            int i;
            block26: for (ch = 0; ch < stereo; ++ch) {
                int j;
                int i2;
                int next_sfb;
                int sfb;
                if (win_switch_flag[ch * 2 + gr] == 1 && block_type[ch * 2 + gr] == 2) {
                    int win_len;
                    if (mixed_block_flag[ch * 2 + gr] != 0) {
                        sfb = 0;
                        next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb + 1];
                        for (i2 = 0; i2 < 36; ++i2) {
                            if (i2 == next_sfb) {
                                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + ++sfb + 1];
                            }
                            Decoder.requantize_long_III(gr, ch, scalefac_scale, preflag, global_gain, scalefac_l, is, i2, sfb);
                        }
                        sfb = 3;
                        next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] * 3;
                        win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb];
                        i = 36;
                        while (i < count1[ch * 2 + gr]) {
                            if (i == next_sfb) {
                                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + ++sfb + 1] * 3;
                                win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb];
                            }
                            for (int win = 0; win < 3; ++win) {
                                for (j = 0; j < win_len; ++j) {
                                    Decoder.requantize_short_III(gr, ch, scalefac_scale, subblock_gain, global_gain, scalefac_s, is, i, sfb, win);
                                    ++i;
                                }
                            }
                        }
                    } else {
                        sfb = 0;
                        next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] * 3;
                        win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb];
                        i = 0;
                        while (i < count1[ch * 2 + gr]) {
                            if (i == next_sfb) {
                                next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + ++sfb + 1] * 3;
                                win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb];
                            }
                            for (int win = 0; win < 3; ++win) {
                                for (j = 0; j < win_len; ++j) {
                                    Decoder.requantize_short_III(gr, ch, scalefac_scale, subblock_gain, global_gain, scalefac_s, is, i, sfb, win);
                                    ++i;
                                }
                            }
                        }
                    }
                } else {
                    sfb = 0;
                    next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb + 1];
                    for (i2 = 0; i2 < count1[ch * 2 + gr]; ++i2) {
                        if (i2 == next_sfb) {
                            next_sfb = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + ++sfb + 1];
                        }
                        Decoder.requantize_long_III(gr, ch, scalefac_scale, preflag, global_gain, scalefac_l, is, i2, sfb);
                    }
                }
                if (win_switch_flag[ch * 2 + gr] != 1 || block_type[ch * 2 + gr] != 2) continue;
                float[] re = new float[576];
                int i3 = 0;
                int sfb2 = 0;
                if (mixed_block_flag[ch * 2 + gr] != 0) {
                    sfb2 = 3;
                    i3 = 36;
                }
                int next_sfb2 = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2 + 1] * 3;
                int win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2 + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2];
                while (i3 < 576) {
                    if (i3 == next_sfb2) {
                        for (j = 0; j < 3 * win_len; ++j) {
                            is[ch * 2 * 576 + gr * 576 + 3 * Decoder.SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2] + j] = re[j];
                        }
                        if (i3 >= count1[ch * 2 + gr]) continue block26;
                        next_sfb2 = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + ++sfb2 + 1] * 3;
                        win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2 + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb2];
                    }
                    for (int win = 0; win < 3; ++win) {
                        for (int j2 = 0; j2 < win_len; ++j2) {
                            re[j2 * 3 + win] = is[ch * 2 * 576 + gr * 576 + i3];
                            ++i3;
                        }
                    }
                }
                for (j = 0; j < 3 * win_len; ++j) {
                    is[ch * 2 * 576 + gr * 576 + 3 * Decoder.SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + 12] + j] = re[j];
                }
            }
            if (mode == 1 && modeExtension != 0) {
                if ((modeExtension & 2) != 0) {
                    int max_pos = count1[0 + gr] > count1[2 + gr] ? count1[0 + gr] : count1[2 + gr];
                    for (int i4 = 0; i4 < max_pos; ++i4) {
                        float left = (is[0 + gr * 576 + i4] + is[1152 + gr * 576 + i4]) * 0.70710677f;
                        float right = (is[0 + gr * 576 + i4] - is[1152 + gr * 576 + i4]) * 0.70710677f;
                        is[0 + gr * 576 + i4] = left;
                        is[1152 + gr * 576 + i4] = right;
                    }
                }
                if ((modeExtension & 1) != 0) {
                    int sfb;
                    if (win_switch_flag[0 + gr] == 1 && block_type[0 + gr] == 2) {
                        if (mixed_block_flag[0 + gr] != 0) {
                            for (sfb = 0; sfb < 8; ++sfb) {
                                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb] < count1[2 + gr]) continue;
                                Decoder.stereo_long_III(is, scalefac_l, gr, sfb, samplingFrequency);
                            }
                            for (sfb = 3; sfb < 12; ++sfb) {
                                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb] * 3 < count1[2 + gr]) continue;
                                Decoder.stereo_short_III(is, scalefac_s, gr, sfb, samplingFrequency);
                            }
                        } else {
                            for (sfb = 0; sfb < 12; ++sfb) {
                                if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb] * 3 < count1[2 + gr]) continue;
                                Decoder.stereo_short_III(is, scalefac_s, gr, sfb, samplingFrequency);
                            }
                        }
                    } else {
                        for (sfb = 0; sfb < 21; ++sfb) {
                            if (SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb] < count1[2 + gr]) continue;
                            Decoder.stereo_long_III(is, scalefac_l, gr, sfb, samplingFrequency);
                        }
                    }
                }
            }
            for (ch = 0; ch < stereo; ++ch) {
                int sb;
                if (win_switch_flag[ch * 2 + gr] != 1 || block_type[ch * 2 + gr] != 2 || mixed_block_flag[ch * 2 + gr] != 0) {
                    int sblim = win_switch_flag[ch * 2 + gr] == 1 && block_type[ch * 2 + gr] == 2 && mixed_block_flag[ch * 2 + gr] == 1 ? 2 : 32;
                    for (int sb2 = 1; sb2 < sblim; ++sb2) {
                        for (int i5 = 0; i5 < 8; ++i5) {
                            int li = 18 * sb2 - 1 - i5;
                            int ui = 18 * sb2 + i5;
                            float lb = is[ch * 2 * 576 + gr * 576 + li] * CS_ALIASING_LAYER_III[i5] - is[ch * 2 * 576 + gr * 576 + ui] * CA_ALIASING_LAYER_III[i5];
                            float ub = is[ch * 2 * 576 + gr * 576 + ui] * CS_ALIASING_LAYER_III[i5] + is[ch * 2 * 576 + gr * 576 + li] * CA_ALIASING_LAYER_III[i5];
                            is[ch * 2 * 576 + gr * 576 + li] = lb;
                            is[ch * 2 * 576 + gr * 576 + ui] = ub;
                        }
                    }
                }
                for (sb = 0; sb < 32; ++sb) {
                    int bt = win_switch_flag[ch * 2 + gr] == 1 && mixed_block_flag[ch * 2 + gr] == 1 && sb < 2 ? 0 : block_type[ch * 2 + gr];
                    float[] rawout = new float[36];
                    int offset = ch * 2 * 576 + gr * 576 + sb * 18;
                    if (bt == 2) {
                        for (int j = 0; j < 3; ++j) {
                            for (int p = 0; p < 12; ++p) {
                                float sum = 0.0f;
                                for (int m = 0; m < 6; ++m) {
                                    sum += is[offset + j + 3 * m] * COS_12_LAYER_III[m * 12 + p];
                                }
                                int n = 6 * j + p + 6;
                                rawout[n] = rawout[n] + sum * IMDCT_WINDOW_LAYER_III[bt * 36 + p];
                            }
                        }
                    } else {
                        for (int p = 0; p < 36; ++p) {
                            float sum = 0.0f;
                            for (int m = 0; m < 18; ++m) {
                                sum += is[offset + m] * COS_36_LAYER_III[m * 36 + p];
                            }
                            rawout[p] = sum * IMDCT_WINDOW_LAYER_III[bt * 36 + p];
                        }
                    }
                    for (int i6 = 0; i6 < 18; ++i6) {
                        is[ch * 2 * 576 + gr * 576 + sb * 18 + i6] = rawout[i6] + store[ch * 32 * 18 + sb * 18 + i6];
                        store[ch * 32 * 18 + sb * 18 + i6] = rawout[i6 + 18];
                    }
                }
                for (sb = 1; sb < 32; sb += 2) {
                    for (int i7 = 1; i7 < 18; i7 += 2) {
                        is[ch * 2 * 576 + gr * 576 + sb * 18 + i7] = -is[ch * 2 * 576 + gr * 576 + sb * 18 + i7];
                    }
                }
                float[] u = new float[512];
                float[] s = new float[32];
                for (int ss = 0; ss < 18; ++ss) {
                    int j;
                    for (i = 1023; i > 63; --i) {
                        v[ch * 1024 + i] = v[ch * 1024 + i - 64];
                    }
                    for (i = 0; i < 32; ++i) {
                        s[i] = is[ch * 2 * 576 + gr * 576 + i * 18 + ss];
                    }
                    for (i = 0; i < 64; ++i) {
                        float sum = 0.0f;
                        for (j = 0; j < 32; ++j) {
                            sum += SYNTH_WINDOW_TABLE_LAYER_III[i * 32 + j] * s[j];
                        }
                        v[ch * 1024 + i] = sum;
                    }
                    for (i = 0; i < 8; ++i) {
                        for (int j3 = 0; j3 < 32; ++j3) {
                            u[i * 64 + j3] = v[ch * 1024 + i * 128 + j3];
                            u[i * 64 + j3 + 32] = v[ch * 1024 + i * 128 + j3 + 96];
                        }
                    }
                    for (i = 0; i < 512; ++i) {
                        int n = i;
                        u[n] = u[n] * DI_COEFFICIENTS[i];
                    }
                    for (i = 0; i < 32; ++i) {
                        float sum = 0.0f;
                        for (j = 0; j < 16; ++j) {
                            sum += u[j * 32 + i];
                        }
                        int samp = (int)(sum * 32767.0f);
                        if (samp > Short.MAX_VALUE) {
                            samp = Short.MAX_VALUE;
                        } else if (samp < -32767) {
                            samp = -32767;
                        }
                        samp &= 0xFFFF;
                        if (stereo > 1) {
                            soundData.samplesBuffer[gr * 18 * 32 * 2 * 2 + ss * 32 * 2 * 2 + i * 2 * 2 + ch * 2] = (byte)samp;
                            soundData.samplesBuffer[gr * 18 * 32 * 2 * 2 + ss * 32 * 2 * 2 + i * 2 * 2 + ch * 2 + 1] = (byte)(samp >>> 8);
                            continue;
                        }
                        soundData.samplesBuffer[gr * 18 * 32 * 2 + ss * 32 * 2 + i * 2] = (byte)samp;
                        soundData.samplesBuffer[gr * 18 * 32 * 2 + ss * 32 * 2 + i * 2 + 1] = (byte)(samp >>> 8);
                    }
                }
            }
        }
    }

    private static void stereo_short_III(float[] is, int[] scalefac_s, int gr, int sfb, int samplingFrequency) {
        int win_len = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb + 1] - SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb];
        for (int win = 0; win < 3; ++win) {
            float is_ratio_r;
            float is_ratio_l;
            int is_pos = scalefac_s[0 + gr * 12 * 3 + sfb * 3 + win];
            if (is_pos == 7) continue;
            int sfb_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 23 + sfb] * 3 + win_len * win;
            int sfb_stop = sfb_start + win_len;
            if (is_pos == 6) {
                is_ratio_l = 1.0f;
                is_ratio_r = 0.0f;
            } else {
                is_ratio_l = IS_RATIOS_LAYER_III[is_pos] / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
                is_ratio_r = 1.0f / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
            }
            for (int i = sfb_start; i < sfb_stop; ++i) {
                int n = 0 + gr * 576 + i;
                is[n] = is[n] * is_ratio_l;
                int n2 = 1152 + gr * 576 + i;
                is[n2] = is[n2] * is_ratio_r;
            }
        }
    }

    private static void stereo_long_III(float[] is, int[] scalefac_l, int gr, int sfb, int samplingFrequency) {
        int is_pos = scalefac_l[0 + gr * 21 + sfb];
        if (is_pos != 7) {
            float is_ratio_r;
            float is_ratio_l;
            int sfb_start = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb];
            int sfb_stop = SCALEFACTOR_BAND_INDICES_LAYER_III[samplingFrequency * 37 + 0 + sfb + 1];
            if (is_pos == 6) {
                is_ratio_l = 1.0f;
                is_ratio_r = 0.0f;
            } else {
                is_ratio_l = IS_RATIOS_LAYER_III[is_pos] / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
                is_ratio_r = 1.0f / (1.0f + IS_RATIOS_LAYER_III[is_pos]);
            }
            for (int i = sfb_start; i < sfb_stop; ++i) {
                int n = 0 + gr * 576 + i;
                is[n] = is[n] * is_ratio_l;
                int n2 = 1152 + gr * 576 + i;
                is[n2] = is[n2] * is_ratio_r;
            }
        }
    }

    private static void requantize_short_III(int gr, int ch, int[] scalefac_scale, int[] subblock_gain, int[] global_gain, int[] scalefac_s, float[] is, int is_pos, int sfb, int win) {
        float sf_mult = scalefac_scale[ch * 2 + gr] != 0 ? 1.0f : 0.5f;
        float tmp1 = sfb < 12 ? (float)Math.pow(2.0, -(sf_mult * (float)scalefac_s[ch * 2 * 12 * 3 + gr * 12 * 3 + sfb * 3 + win])) : 1.0f;
        float tmp2 = (float)Math.pow(2.0, 0.25f * ((float)global_gain[ch * 2 + gr] - 210.0f - 8.0f * (float)subblock_gain[ch * 2 * 3 + gr * 3 + win]));
        float tmp3 = (double)is[ch * 2 * 576 + gr * 576 + is_pos] < 0.0 ? -POWTAB_LAYER_III[(int)(-is[ch * 2 * 576 + gr * 576 + is_pos])] : POWTAB_LAYER_III[(int)is[ch * 2 * 576 + gr * 576 + is_pos]];
        is[ch * 2 * 576 + gr * 576 + is_pos] = tmp1 * tmp2 * tmp3;
    }

    private static void requantize_long_III(int gr, int ch, int[] scalefac_scale, int[] preflag, int[] global_gain, int[] scalefac_l, float[] is, int is_pos, int sfb) {
        float tmp1;
        float sf_mult;
        float f = sf_mult = scalefac_scale[ch * 2 + gr] != 0 ? 1.0f : 0.5f;
        if (sfb < 21) {
            float pf_x_pt = (float)preflag[ch * 2 + gr] * REQUANTIZE_LONG_PRETAB_LAYER_III[sfb];
            tmp1 = (float)Math.pow(2.0, -(sf_mult * ((float)scalefac_l[ch * 2 * 21 + gr * 21 + sfb] + pf_x_pt)));
        } else {
            tmp1 = 1.0f;
        }
        float tmp2 = (float)Math.pow(2.0, 0.25f * (float)(global_gain[ch * 2 + gr] - 210));
        float tmp3 = (double)is[ch * 2 * 576 + gr * 576 + is_pos] < 0.0 ? -POWTAB_LAYER_III[(int)(-is[ch * 2 * 576 + gr * 576 + is_pos])] : POWTAB_LAYER_III[(int)is[ch * 2 * 576 + gr * 576 + is_pos]];
        is[ch * 2 * 576 + gr * 576 + is_pos] = tmp1 * tmp2 * tmp3;
    }

    private static void huffman_III(MainDataReader mainDataReader, int table_num, int[] array) {
        int point = 0;
        if (HUFFMAN_TREELEN_LAYER_III[table_num] == 0) {
            array[3] = 0;
            array[2] = 0;
            array[1] = 0;
            array[0] = 0;
            return;
        }
        int treelen = HUFFMAN_TREELEN_LAYER_III[table_num];
        int linbits = HUFFMAN_LINBITS_LAYER_III[table_num];
        int offset = HUFFMAN_TABLE_OFFSET_LAYER_III[table_num];
        boolean error = true;
        int bitsleft = 32;
        do {
            if ((HUFFMAN_TABLE_LAYER_III[offset + point] & 0xFF00) == 0) {
                error = false;
                array[0] = HUFFMAN_TABLE_LAYER_III[offset + point] >> 4 & 0xF;
                array[1] = HUFFMAN_TABLE_LAYER_III[offset + point] & 0xF;
                break;
            }
            if (Decoder.read(mainDataReader, 1) != 0) {
                while ((HUFFMAN_TABLE_LAYER_III[offset + point] & 0xFF) >= 250) {
                    point += HUFFMAN_TABLE_LAYER_III[offset + point] & 0xFF;
                }
                point += HUFFMAN_TABLE_LAYER_III[offset + point] & 0xFF;
                continue;
            }
            while (HUFFMAN_TABLE_LAYER_III[offset + point] >> 8 >= 250) {
                point += HUFFMAN_TABLE_LAYER_III[offset + point] >> 8;
            }
            point += HUFFMAN_TABLE_LAYER_III[offset + point] >> 8;
        } while (--bitsleft > 0 && point < treelen);
        if (error) {
            array[1] = 0;
            array[0] = 0;
            throw new IllegalStateException("Illegal Huff code in data. bleft = %d,point = %d. tab = %d." + bitsleft + " " + point + " " + table_num);
        }
        if (table_num > 31) {
            array[2] = array[1] >> 3 & 1;
            array[3] = array[1] >> 2 & 1;
            array[0] = array[1] >> 1 & 1;
            array[1] = array[1] & 1;
            if (array[2] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[2] = -array[2];
            }
            if (array[3] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[3] = -array[3];
            }
            if (array[0] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[0] = -array[0];
            }
            if (array[1] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[1] = -array[1];
            }
        } else {
            if (linbits > 0 && array[0] == 15) {
                array[0] = array[0] + Decoder.read(mainDataReader, linbits);
            }
            if (array[0] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[0] = -array[0];
            }
            if (linbits > 0 && array[1] == 15) {
                array[1] = array[1] + Decoder.read(mainDataReader, linbits);
            }
            if (array[1] > 0 && Decoder.read(mainDataReader, 1) == 1) {
                array[1] = -array[1];
            }
        }
    }

    private static float[] samples_I(Buffer buffer, int stereo, int bound) throws IOException {
        int ch;
        int sb;
        if (bound < 0) {
            bound = 32;
        }
        int[] allocation = new int[32 - bound];
        int[] allocationChannel = new int[stereo * bound];
        int[] scalefactorChannel = new int[stereo * 32];
        float[] sampleDecoded = new float[stereo * 32 * 12];
        for (sb = 0; sb < bound; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                allocationChannel[ch * bound + sb] = Decoder.read(buffer, 4);
            }
        }
        for (sb = bound; sb < 32; ++sb) {
            allocation[sb - bound] = Decoder.read(buffer, 4);
        }
        for (sb = 0; sb < bound; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocationChannel[ch * bound + sb] == 0) continue;
                scalefactorChannel[ch * 32 + sb] = Decoder.read(buffer, 6);
            }
        }
        for (sb = bound; sb < 32; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocation[sb - bound] == 0) continue;
                scalefactorChannel[ch * 32 + sb] = Decoder.read(buffer, 6);
            }
        }
        for (int s = 0; s < 12; ++s) {
            int sb2;
            for (sb2 = 0; sb2 < bound; ++sb2) {
                for (int ch2 = 0; ch2 < stereo; ++ch2) {
                    int n = allocationChannel[ch2 * bound + sb2];
                    if (n == 0) {
                        sampleDecoded[ch2 * 32 * 12 + sb2 * 12 + s] = 0.0f;
                        continue;
                    }
                    int read = Decoder.read(buffer, n + 1);
                    float fraction = 0.0f;
                    if ((read >> n & 1) == 0) {
                        fraction = -1.0f;
                    }
                    sampleDecoded[ch2 * 32 * 12 + sb2 * 12 + s] = SCALEFACTORS[scalefactorChannel[ch2 * 32 + sb2]] * PRE_FRACTOR_LAYER_I[n + 1] * (fraction += (float)(read & (1 << n) - 1) / (float)(1 << n) + 1.0f / (float)(1 << n));
                }
            }
            for (sb2 = bound; sb2 < 32; ++sb2) {
                int n = allocationChannel[sb2 - bound];
                if (n == 0) {
                    sampleDecoded[384 + sb2 * 12 + s] = 0.0f;
                    sampleDecoded[0 + sb2 * 12 + s] = 0.0f;
                    continue;
                }
                int read = Decoder.read(buffer, n + 1);
                float fraction = 0.0f;
                if ((read >> n & 1) == 0) {
                    fraction = -1.0f;
                }
                fraction += (float)(read & (1 << n) - 1) / (float)(1 << n) + 1.0f / (float)(1 << n);
                for (int ch3 = 0; ch3 < 2; ++ch3) {
                    sampleDecoded[ch3 * 32 * 12 + sb2 * 12 + s] = SCALEFACTORS[scalefactorChannel[ch3 * 32 + sb2]] * PRE_FRACTOR_LAYER_I[n + 1] * fraction;
                }
            }
        }
        return sampleDecoded;
    }

    private static float[] samples_II(Buffer buffer, int stereo, int bound, int bitrate, int frequency) throws IOException {
        int offset;
        int ch;
        int sb;
        int sbIndex = 0;
        if (frequency != 48000 && (bitrate >= 96000 || bitrate == 0)) {
            sbIndex = 1;
        } else if (frequency != 32000 && bitrate > 0 && bitrate <= 48000) {
            sbIndex = 2;
        } else if (frequency == 32000 && bitrate > 0 && bitrate <= 48000) {
            sbIndex = 3;
        }
        int sbLimit = SB_LIMIT[sbIndex];
        if (bound < 0) {
            bound = sbLimit;
        }
        int[] allocation = new int[sbLimit - bound];
        int[] allocationChannel = new int[stereo * bound];
        int[] scfsi = new int[stereo * sbLimit];
        int[] scalefactorChannel = new int[stereo * sbLimit * 3];
        float[] sampleDecoded = new float[stereo * 32 * 12 * 3];
        for (sb = 0; sb < bound; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                allocationChannel[ch * bound + sb] = Decoder.read(buffer, NBAL[sbIndex][sb]);
            }
        }
        for (sb = bound; sb < sbLimit; ++sb) {
            allocation[sb - bound] = Decoder.read(buffer, NBAL[sbIndex][sb]);
        }
        for (sb = 0; sb < bound; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocationChannel[ch * bound + sb] == 0) continue;
                scfsi[ch * sbLimit + sb] = Decoder.read(buffer, 2);
            }
        }
        for (sb = bound; sb < sbLimit; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocation[sb - bound] == 0) continue;
                scfsi[ch * sbLimit + sb] = Decoder.read(buffer, 2);
            }
        }
        for (sb = 0; sb < bound; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocationChannel[ch * bound + sb] == 0) continue;
                offset = ch * sbLimit * 3 + sb * 3;
                if (scfsi[ch * sbLimit + sb] == 0) {
                    scalefactorChannel[offset + 0] = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 1] = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 2] = Decoder.read(buffer, 6);
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] == 1) {
                    int n = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 1] = n;
                    scalefactorChannel[offset + 0] = n;
                    scalefactorChannel[offset + 2] = Decoder.read(buffer, 6);
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] == 2) {
                    int n = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 2] = n;
                    scalefactorChannel[offset + 1] = n;
                    scalefactorChannel[offset + 0] = n;
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] != 3) continue;
                scalefactorChannel[offset + 0] = Decoder.read(buffer, 6);
                int n = Decoder.read(buffer, 6);
                scalefactorChannel[offset + 2] = n;
                scalefactorChannel[offset + 1] = n;
            }
        }
        for (sb = bound; sb < sbLimit; ++sb) {
            for (ch = 0; ch < stereo; ++ch) {
                if (allocation[sb - bound] == 0) continue;
                offset = ch * sbLimit * 3 + sb * 3;
                if (scfsi[ch * sbLimit + sb] == 0) {
                    scalefactorChannel[offset + 0] = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 1] = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 2] = Decoder.read(buffer, 6);
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] == 1) {
                    int n = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 1] = n;
                    scalefactorChannel[offset + 0] = n;
                    scalefactorChannel[offset + 2] = Decoder.read(buffer, 6);
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] == 2) {
                    int n = Decoder.read(buffer, 6);
                    scalefactorChannel[offset + 2] = n;
                    scalefactorChannel[offset + 1] = n;
                    scalefactorChannel[offset + 0] = n;
                    continue;
                }
                if (scfsi[ch * sbLimit + sb] != 3) continue;
                scalefactorChannel[offset + 0] = Decoder.read(buffer, 6);
                int n = Decoder.read(buffer, 6);
                scalefactorChannel[offset + 2] = n;
                scalefactorChannel[offset + 1] = n;
            }
        }
        for (int gr = 0; gr < 12; ++gr) {
            int sb2;
            for (sb2 = 0; sb2 < bound; ++sb2) {
                for (int ch2 = 0; ch2 < stereo; ++ch2) {
                    int n = allocationChannel[ch2 * bound + sb2];
                    int offset2 = ch2 * 32 * 12 * 3 + sb2 * 12 * 3 + gr * 3;
                    if (n == 0) {
                        sampleDecoded[offset2 + 2] = 0.0f;
                        sampleDecoded[offset2 + 1] = 0.0f;
                        sampleDecoded[offset2] = 0.0f;
                        continue;
                    }
                    int index = QUANTIZATION_INDEX_LAYER_II[sbIndex][sb2][n - 1];
                    int[] sampleInt = new int[3];
                    int sampleBits = BITS_LAYER_II[index];
                    int nlevels = NLEVELS[index];
                    if (GROUPING_LAYER_II[index]) {
                        int samplecode = Decoder.read(buffer, sampleBits);
                        sampleInt[0] = samplecode % nlevels;
                        sampleInt[1] = (samplecode /= nlevels) % nlevels;
                        sampleInt[2] = (samplecode /= nlevels) % nlevels;
                    } else {
                        sampleInt[0] = Decoder.read(buffer, sampleBits);
                        sampleInt[1] = Decoder.read(buffer, sampleBits);
                        sampleInt[2] = Decoder.read(buffer, sampleBits);
                    }
                    int msb = 0;
                    while (1 << msb <= nlevels) {
                        ++msb;
                    }
                    --msb;
                    for (int i = 0; i < 3; ++i) {
                        float sample = 0.0f;
                        if ((sampleInt[i] >> msb & 1) == 0) {
                            sample = -1.0f;
                        }
                        sample += (float)(sampleInt[i] & (1 << msb) - 1) / (float)(1 << msb);
                        sample += D_LAYER_II[index];
                        sample *= C_LAYER_II[index];
                        sampleDecoded[offset2 + i] = sample *= SCALEFACTORS[scalefactorChannel[ch2 * sbLimit * 3 + sb2 * 3 + gr / 4]];
                    }
                }
            }
            for (sb2 = bound; sb2 < sbLimit; ++sb2) {
                int n = allocation[sb2 - bound];
                int offset3 = sb2 * 12 * 3 + gr * 3;
                if (n == 0) {
                    for (int ch3 = 0; ch3 < stereo; ++ch3) {
                        sampleDecoded[offset3 + ch3 * 32 * 12 * 3 + 2] = 0.0f;
                        sampleDecoded[offset3 + ch3 * 32 * 12 * 3 + 1] = 0.0f;
                        sampleDecoded[offset3 + ch3 * 32 * 12 * 3] = 0.0f;
                    }
                    continue;
                }
                int index = QUANTIZATION_INDEX_LAYER_II[sbIndex][sb2][n - 1];
                int[] sampleInt = new int[3];
                int sampleBits = BITS_LAYER_II[index];
                int nlevels = NLEVELS[index];
                if (GROUPING_LAYER_II[index]) {
                    int samplecode = Decoder.read(buffer, sampleBits);
                    sampleInt[0] = samplecode % nlevels;
                    sampleInt[1] = (samplecode /= nlevels) % nlevels;
                    sampleInt[2] = (samplecode /= nlevels) % nlevels;
                } else {
                    sampleInt[0] = Decoder.read(buffer, sampleBits);
                    sampleInt[1] = Decoder.read(buffer, sampleBits);
                    sampleInt[2] = Decoder.read(buffer, sampleBits);
                }
                int msb = 0;
                while (1 << msb <= nlevels) {
                    ++msb;
                }
                --msb;
                for (int i = 0; i < 3; ++i) {
                    float sample = 0.0f;
                    if ((sampleInt[i] >> msb & 1) == 0) {
                        sample = -1.0f;
                    }
                    sample += (float)(sampleInt[i] & (1 << msb) - 1) / (float)(1 << msb);
                    sample += D_LAYER_II[index];
                    sample *= C_LAYER_II[index];
                    for (int ch4 = 0; ch4 < stereo; ++ch4) {
                        sampleDecoded[offset3 + ch4 * 32 * 12 * 3 + i] = sample * SCALEFACTORS[scalefactorChannel[ch4 * sbLimit * 3 + sb2 * 3 + gr / 4]];
                    }
                }
            }
        }
        return sampleDecoded;
    }

    private static void synth(SoundData soundData, float[] samples, int[] synthOffset, float[] synthBuffer, int stereo) {
        int size = samples.length / stereo / 32;
        float[] pcm = new float[size * 32 * stereo];
        for (int ch = 0; ch < stereo; ++ch) {
            for (int s = 0; s < size; ++s) {
                float sum;
                synthOffset[ch] = synthOffset[ch] - 64 & 0x3FF;
                for (int i = 0; i < 64; ++i) {
                    sum = 0.0f;
                    for (int k = 0; k < 32; ++k) {
                        sum += NIK_COEFFICIENTS[i * 32 + k] * samples[ch * 32 * size + k * size + s];
                    }
                    synthBuffer[ch * 1024 + synthOffset[ch] + i] = sum;
                }
                for (int j = 0; j < 32; ++j) {
                    sum = 0.0f;
                    for (int i = 0; i < 16; ++i) {
                        int k = j + (i << 5);
                        sum += DI_COEFFICIENTS[k] * synthBuffer[ch * 1024 + (synthOffset[ch] + (k + (i + 1 >> 1 << 6)) & 0x3FF)];
                    }
                    pcm[s * 32 * stereo + j * stereo + ch] = sum;
                }
            }
        }
        if (soundData.samplesBuffer == null) {
            soundData.samplesBuffer = new byte[size * 32 * stereo * 2];
        }
        for (int i = 0; i < size * 32 * stereo; ++i) {
            int sample = (int)(pcm[i] * 32768.0f);
            if (sample >= 32768) {
                sample = Short.MAX_VALUE;
            } else if (sample < Short.MIN_VALUE) {
                sample = Short.MIN_VALUE;
            }
            soundData.samplesBuffer[i * 2] = (byte)sample;
            soundData.samplesBuffer[i * 2 + 1] = (byte)(sample >>> 8);
        }
    }

    private static int read(MainDataReader reader, int bits) {
        int number = 0;
        while (bits > 0) {
            int advance = Integer.min(bits, 8 - reader.current);
            reader.current += advance;
            number |= (reader.array[reader.index] >>> 8 - reader.current & 255 >>> 8 - advance) << (bits -= advance);
            if (reader.current != 8) continue;
            reader.current = 0;
            ++reader.index;
        }
        return number;
    }

    private static int read(Buffer buffer, int bits) throws IOException {
        int number = 0;
        while (bits > 0) {
            int advance = Integer.min(bits, 8 - buffer.current);
            buffer.current += advance;
            if ((bits -= advance) != 0 && buffer.lastByte == -1) {
                throw new EOFException("Unexpected EOF reached in MPEG data");
            }
            number |= (buffer.lastByte >>> 8 - buffer.current & 255 >>> 8 - advance) << bits;
            if (buffer.current != 8) continue;
            buffer.current = 0;
            buffer.lastByte = buffer.in.read();
        }
        return number;
    }

    private static void readInto(Buffer buffer, byte[] array, int offset, int length) throws IOException {
        if (buffer.current != 0) {
            throw new IllegalStateException("buffer current is " + buffer.current);
        }
        if (length == 0) {
            return;
        }
        if (buffer.lastByte == -1) {
            throw new EOFException("Unexpected EOF reached in MPEG data");
        }
        array[offset] = (byte)buffer.lastByte;
        for (int read = 1; read < length; read += buffer.in.read(array, offset + read, length - read)) {
        }
        buffer.lastByte = buffer.in.read();
    }

    /*
     * Opcode count of 20240 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        int i;
        BITRATE_LAYER_I = new int[]{0, 32000, 64000, 96000, 128000, 160000, 192000, 224000, 256000, 288000, 320000, 352000, 384000, 416000, 448000};
        BITRATE_LAYER_II = new int[]{0, 32000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000, 384000};
        BITRATE_LAYER_III = new int[]{0, 32000, 40000, 48000, 56000, 64000, 80000, 96000, 112000, 128000, 160000, 192000, 224000, 256000, 320000};
        SAMPLING_FREQUENCY = new int[]{44100, 48000, 32000};
        SCALEFACTORS = new float[]{2.0f, 1.587401f, 1.2599211f, 1.0f, 0.7937005f, 0.62996054f, 0.5f, 0.39685026f, 0.31498027f, 0.25f, 0.19842513f, 0.15749013f, 0.125f, 0.099212565f, 0.07874507f, 0.0625f, 0.049606282f, 0.039372534f, 0.03125f, 0.024803141f, 0.019686267f, 0.015625f, 0.012401571f, 0.009843133f, 0.0078125f, 0.0062007853f, 0.0049215667f, 0.00390625f, 0.0031003926f, 0.0024607833f, 0.001953125f, 0.0015501963f, 0.0012303917f, 9.765625E-4f, 7.7509816E-4f, 6.1519584E-4f, 4.8828125E-4f, 3.8754908E-4f, 3.0759792E-4f, 2.4414062E-4f, 1.9377454E-4f, 1.5379896E-4f, 1.2207031E-4f, 9.688727E-5f, 7.689948E-5f, 6.1035156E-5f, 4.8443635E-5f, 3.844974E-5f, 3.0517578E-5f, 2.4221818E-5f, 1.922487E-5f, 1.5258789E-5f, 1.2110909E-5f, 9.612435E-6f, 7.6293945E-6f, 6.0554544E-6f, 4.8062175E-6f, 3.8146973E-6f, 3.0277272E-6f, 2.4031087E-6f, 1.9073486E-6f, 1.5138636E-6f, 1.2015544E-6f};
        SCALEFACTOR_SIZES_LAYER_III = new int[]{0, 0, 0, 1, 0, 2, 0, 3, 3, 0, 1, 1, 1, 2, 1, 3, 2, 1, 2, 2, 2, 3, 3, 1, 3, 2, 3, 3, 4, 2, 4, 3};
        SCALEFACTOR_BAND_INDICES_LAYER_III = new int[]{0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 52, 62, 74, 90, 110, 134, 162, 196, 238, 288, 342, 418, 576, 0, 4, 8, 12, 16, 22, 30, 40, 52, 66, 84, 106, 136, 192, 0, 4, 8, 12, 16, 20, 24, 30, 36, 42, 50, 60, 72, 88, 106, 128, 156, 190, 230, 276, 330, 384, 576, 0, 4, 8, 12, 16, 22, 28, 38, 50, 64, 80, 100, 126, 192, 0, 4, 8, 12, 16, 20, 24, 30, 36, 44, 54, 66, 82, 102, 126, 156, 194, 240, 296, 364, 448, 550, 576, 0, 4, 8, 12, 16, 22, 30, 42, 58, 78, 104, 138, 180, 192};
        CS_ALIASING_LAYER_III = new float[]{0.857493f, 0.881742f, 0.949629f, 0.983315f, 0.995518f, 0.999161f, 0.999899f, 0.999993f};
        CA_ALIASING_LAYER_III = new float[]{-0.514496f, -0.471732f, -0.313377f, -0.181913f, -0.094574f, -0.040966f, -0.014199f, -0.0037f};
        DI_COEFFICIENTS = new float[]{0.0f, -1.5259E-5f, -1.5259E-5f, -1.5259E-5f, -1.5259E-5f, -1.5259E-5f, -1.5259E-5f, -3.0518E-5f, -3.0518E-5f, -3.0518E-5f, -3.0518E-5f, -4.5776E-5f, -4.5776E-5f, -6.1035E-5f, -6.1035E-5f, -7.6294E-5f, -7.6294E-5f, -9.1553E-5f, -1.06812E-4f, -1.06812E-4f, -1.2207E-4f, -1.37329E-4f, -1.52588E-4f, -1.67847E-4f, -1.98364E-4f, -2.13623E-4f, -2.44141E-4f, -2.59399E-4f, -2.89917E-4f, -3.20435E-4f, -3.66211E-4f, -3.96729E-4f, -4.42505E-4f, -4.73022E-4f, -5.34058E-4f, -5.79834E-4f, -6.2561E-4f, -6.86646E-4f, -7.47681E-4f, -8.08716E-4f, -8.8501E-4f, -9.61304E-4f, -0.001037598f, -0.001113892f, -0.001205444f, -0.001296997f, -0.00138855f, -0.001480103f, -0.001586914f, -0.001693726f, -0.001785278f, -0.001907349f, -0.00201416f, -0.002120972f, -0.002243042f, -0.002349854f, -0.002456665f, -0.002578735f, -0.002685547f, -0.002792358f, -0.00289917f, -0.002990723f, -0.003082275f, -0.003173828f, 0.003250122f, 0.003326416f, 0.003387451f, 0.003433228f, 0.003463745f, 0.003479004f, 0.003479004f, 0.003463745f, 0.003417969f, 0.003372192f, 0.00328064f, 0.003173828f, 0.003051758f, 0.002883911f, 0.002700806f, 0.002487183f, 0.002227783f, 0.001937866f, 0.001617432f, 0.001266479f, 8.69751E-4f, 4.42505E-4f, -3.0518E-5f, -5.49316E-4f, -0.001098633f, -0.001693726f, -0.002334595f, -0.003005981f, -0.003723145f, -0.004486084f, -0.0052948f, -0.006118774f, -0.007003784f, -0.007919312f, -0.008865356f, -0.009841919f, -0.010848999f, -0.011886597f, -0.012939453f, -0.014022827f, -0.01512146f, -0.016235352f, -0.017349243f, -0.018463135f, -0.019577026f, -0.020690918f, -0.02178955f, -0.022857666f, -0.023910522f, -0.024932861f, -0.025909424f, -0.02684021f, -0.02772522f, -0.028533936f, -0.029281616f, -0.029937744f, -0.030532837f, -0.03100586f, -0.03138733f, -0.031661987f, -0.031814575f, -0.031845093f, -0.03173828f, -0.03147888f, 0.031082153f, 0.030517578f, 0.029785156f, 0.028884888f, 0.027801514f, 0.026535034f, 0.02508545f, 0.023422241f, 0.021575928f, 0.01953125f, 0.01725769f, 0.014801025f, 0.012115479f, 0.009231567f, 0.006134033f, 0.002822876f, -6.86646E-4f, -0.004394531f, -0.00831604f, -0.012420654f, -0.016708374f, -0.0211792f, -0.025817871f, -0.03060913f, -0.03555298f, -0.040634155f, -0.045837402f, -0.051132202f, -0.056533813f, -0.06199646f, -0.06752014f, -0.07305908f, -0.07862854f, -0.08418274f, -0.08970642f, -0.09516907f, -0.10054016f, -0.1058197f, -0.110946655f, -0.11592102f, -0.12069702f, -0.1252594f, -0.12956238f, -0.1335907f, -0.13729858f, -0.14067078f, -0.14367676f, -0.1462555f, -0.14842224f, -0.15011597f, -0.15130615f, -0.15196228f, -0.15206909f, -0.15159607f, -0.15049744f, -0.1487732f, -0.1463623f, -0.14326477f, -0.13945007f, -0.1348877f, -0.12957764f, -0.12347412f, -0.11657715f, -0.1088562f, 0.10031128f, 0.090927124f, 0.08068848f, 0.06959534f, 0.057617188f, 0.044784546f, 0.031082153f, 0.01651001f, 0.001068115f, -0.015228271f, -0.03237915f, -0.050354004f, -0.06916809f, -0.088775635f, -0.10916138f, -0.13031006f, -0.15220642f, -0.17478943f, -0.19805908f, -0.22198486f, -0.24650574f, -0.2715912f, -0.2972107f, -0.32331848f, -0.34986877f, -0.37680054f, -0.40408325f, -0.43165588f, -0.45947266f, -0.48747253f, -0.51560974f, -0.54382324f, -0.57203674f, -0.6002197f, -0.6282959f, -0.6562195f, -0.6839142f, -0.71131897f, -0.7383728f, -0.7650299f, -0.791214f, -0.816864f, -0.84194946f, -0.8663635f, -0.89009094f, -0.9130554f, -0.9351959f, -0.95648193f, -0.9768524f, -0.99624634f, -1.0146179f, -1.0319366f, -1.0481567f, -1.0632172f, -1.0771179f, -1.0897827f, -1.1012115f, -1.1113739f, -1.120224f, -1.1277466f, -1.1339264f, -1.1387634f, -1.1422119f, -1.1442871f, 1.144989f, 1.1442871f, 1.1422119f, 1.1387634f, 1.1339264f, 1.1277466f, 1.120224f, 1.1113739f, 1.1012115f, 1.0897827f, 1.0771179f, 1.0632172f, 1.0481567f, 1.0319366f, 1.0146179f, 0.99624634f, 0.9768524f, 0.95648193f, 0.9351959f, 0.9130554f, 0.89009094f, 0.8663635f, 0.84194946f, 0.816864f, 0.791214f, 0.7650299f, 0.7383728f, 0.71131897f, 0.6839142f, 0.6562195f, 0.6282959f, 0.6002197f, 0.57203674f, 0.54382324f, 0.51560974f, 0.48747253f, 0.45947266f, 0.43165588f, 0.40408325f, 0.37680054f, 0.34986877f, 0.32331848f, 0.2972107f, 0.2715912f, 0.24650574f, 0.22198486f, 0.19805908f, 0.17478943f, 0.15220642f, 0.13031006f, 0.10916138f, 0.088775635f, 0.06916809f, 0.050354004f, 0.03237915f, 0.015228271f, -0.001068115f, -0.01651001f, -0.031082153f, -0.044784546f, -0.057617188f, -0.06959534f, -0.08068848f, -0.090927124f, 0.10031128f, 0.1088562f, 0.11657715f, 0.12347412f, 0.12957764f, 0.1348877f, 0.13945007f, 0.14326477f, 0.1463623f, 0.1487732f, 0.15049744f, 0.15159607f, 0.15206909f, 0.15196228f, 0.15130615f, 0.15011597f, 0.14842224f, 0.1462555f, 0.14367676f, 0.14067078f, 0.13729858f, 0.1335907f, 0.12956238f, 0.1252594f, 0.12069702f, 0.11592102f, 0.110946655f, 0.1058197f, 0.10054016f, 0.09516907f, 0.08970642f, 0.08418274f, 0.07862854f, 0.07305908f, 0.06752014f, 0.06199646f, 0.056533813f, 0.051132202f, 0.045837402f, 0.040634155f, 0.03555298f, 0.03060913f, 0.025817871f, 0.0211792f, 0.016708374f, 0.012420654f, 0.00831604f, 0.004394531f, 6.86646E-4f, -0.002822876f, -0.006134033f, -0.009231567f, -0.012115479f, -0.014801025f, -0.01725769f, -0.01953125f, -0.021575928f, -0.023422241f, -0.02508545f, -0.026535034f, -0.027801514f, -0.028884888f, -0.029785156f, -0.030517578f, 0.031082153f, 0.03147888f, 0.03173828f, 0.031845093f, 0.031814575f, 0.031661987f, 0.03138733f, 0.03100586f, 0.030532837f, 0.029937744f, 0.029281616f, 0.028533936f, 0.02772522f, 0.02684021f, 0.025909424f, 0.024932861f, 0.023910522f, 0.022857666f, 0.02178955f, 0.020690918f, 0.019577026f, 0.018463135f, 0.017349243f, 0.016235352f, 0.01512146f, 0.014022827f, 0.012939453f, 0.011886597f, 0.010848999f, 0.009841919f, 0.008865356f, 0.007919312f, 0.007003784f, 0.006118774f, 0.0052948f, 0.004486084f, 0.003723145f, 0.003005981f, 0.002334595f, 0.001693726f, 0.001098633f, 5.49316E-4f, 3.0518E-5f, -4.42505E-4f, -8.69751E-4f, -0.001266479f, -0.001617432f, -0.001937866f, -0.002227783f, -0.002487183f, -0.002700806f, -0.002883911f, -0.003051758f, -0.003173828f, -0.00328064f, -0.003372192f, -0.003417969f, -0.003463745f, -0.003479004f, -0.003479004f, -0.003463745f, -0.003433228f, -0.003387451f, -0.003326416f, 0.003250122f, 0.003173828f, 0.003082275f, 0.002990723f, 0.00289917f, 0.002792358f, 0.002685547f, 0.002578735f, 0.002456665f, 0.002349854f, 0.002243042f, 0.002120972f, 0.00201416f, 0.001907349f, 0.001785278f, 0.001693726f, 0.001586914f, 0.001480103f, 0.00138855f, 0.001296997f, 0.001205444f, 0.001113892f, 0.001037598f, 9.61304E-4f, 8.8501E-4f, 8.08716E-4f, 7.47681E-4f, 6.86646E-4f, 6.2561E-4f, 5.79834E-4f, 5.34058E-4f, 4.73022E-4f, 4.42505E-4f, 3.96729E-4f, 3.66211E-4f, 3.20435E-4f, 2.89917E-4f, 2.59399E-4f, 2.44141E-4f, 2.13623E-4f, 1.98364E-4f, 1.67847E-4f, 1.52588E-4f, 1.37329E-4f, 1.2207E-4f, 1.06812E-4f, 1.06812E-4f, 9.1553E-5f, 7.6294E-5f, 7.6294E-5f, 6.1035E-5f, 6.1035E-5f, 4.5776E-5f, 4.5776E-5f, 3.0518E-5f, 3.0518E-5f, 3.0518E-5f, 3.0518E-5f, 1.5259E-5f, 1.5259E-5f, 1.5259E-5f, 1.5259E-5f, 1.5259E-5f, 1.5259E-5f};
        SHIFT_ENDIANESS = new int[]{255, 254, 253, 252, 251, 250, 249, 248, 247, 246, 245, 244, 243, 242, 241, 240, 239, 238, 237, 236, 235, 234, 233, 232, 231, 230, 229, 228, 227, 226, 225, 224, 223, 222, 221, 220, 219, 218, 217, 216, 215, 214, 213, 212, 211, 210, 209, 208, 207, 206, 205, 204, 203, 202, 201, 200, 199, 198, 197, 196, 195, 194, 193, 192, 191, 190, 189, 188, 187, 186, 185, 184, 183, 182, 181, 180, 179, 178, 177, 176, 175, 174, 173, 172, 171, 170, 169, 168, 167, 166, 165, 164, 163, 162, 161, 160, 159, 158, 157, 156, 155, 154, 153, 152, 151, 150, 149, 148, 147, 146, 145, 144, 143, 142, 141, 140, 139, 138, 137, 136, 135, 134, 133, 132, 131, 130, 129, 128, 127, 126, 125, 124, 123, 122, 121, 120, 119, 118, 117, 116, 115, 114, 113, 112, 111, 110, 109, 108, 107, 106, 105, 104, 103, 102, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1, 0};
        SB_LIMIT = new int[]{27, 30, 8, 12};
        NBAL = new int[][]{{4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2}, {4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2, 2, 2, 2}, {4, 4, 3, 3, 3, 3, 3, 3}, {4, 4, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3}};
        QUANTIZATION_INDEX_LAYER_II = new int[][][]{new int[][]{{0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}}, new int[][]{{0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 2, 3, 4, 5, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}, {0, 1, 16}}, new int[][]{{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}}, new int[][]{{0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}, {0, 1, 3, 4, 5, 6, 7}}};
        NLEVELS = new int[]{3, 5, 7, 9, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
        C_LAYER_II = new float[]{1.3333334f, 1.6f, 1.1428572f, 1.7777778f, 1.0666667f, 1.032258f, 1.0158731f, 1.007874f, 1.0039216f, 1.0019569f, 1.0009775f, 1.0004885f, 1.0002443f, 1.0001221f, 1.000061f, 1.0000305f, 1.0000153f};
        D_LAYER_II = new float[]{0.5f, 0.5f, 0.25f, 0.5f, 0.125f, 0.0625f, 0.03125f, 0.015625f, 0.0078125f, 0.00390625f, 0.001953125f, 9.765625E-4f, 4.8828125E-4f, 2.4414062E-4f, 1.2207031E-4f, 6.103516E-5f, 3.051758E-5f};
        GROUPING_LAYER_II = new boolean[]{true, true, false, true, false, false, false, false, false, false, false, false, false, false, false, false, false};
        BITS_LAYER_II = new int[]{5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
        HUFFMAN_TABLE_LAYER_III = new int[]{513, 0, 513, 16, 513, 1, 17, 513, 0, 1025, 513, 16, 1, 513, 17, 1025, 513, 32, 33, 513, 18, 513, 2, 34, 1025, 513, 0, 1, 513, 17, 513, 16, 1025, 513, 32, 33, 513, 18, 513, 2, 34, 513, 0, 1025, 513, 16, 1, 513, 17, 2049, 1025, 513, 32, 2, 513, 33, 18, 2049, 1025, 513, 34, 48, 513, 3, 19, 513, 49, 513, 50, 513, 35, 51, 1537, 1025, 513, 0, 16, 17, 1537, 513, 1, 513, 32, 33, 1537, 513, 18, 513, 2, 34, 1025, 513, 49, 19, 1025, 513, 48, 50, 513, 35, 513, 3, 51, 513, 0, 1025, 513, 16, 1, 2049, 513, 17, 1025, 513, 32, 2, 33, 4609, 1537, 513, 18, 513, 34, 48, 1025, 513, 49, 19, 1025, 513, 3, 50, 513, 35, 4, 2561, 1025, 513, 64, 65, 513, 20, 513, 66, 36, 3073, 1537, 1025, 513, 51, 67, 80, 1025, 513, 52, 5, 81, 1537, 513, 21, 513, 82, 37, 1025, 513, 68, 53, 1025, 513, 83, 84, 513, 69, 85, 1537, 513, 0, 513, 16, 1, 513, 17, 1025, 513, 33, 18, 3585, 1025, 513, 32, 2, 513, 34, 1025, 513, 48, 3, 513, 49, 19, 3585, 2049, 1025, 513, 50, 35, 513, 64, 4, 513, 65, 513, 20, 66, 3073, 1537, 513, 36, 513, 51, 80, 1025, 513, 67, 52, 81, 1537, 513, 21, 513, 5, 82, 1537, 513, 37, 513, 68, 53, 513, 83, 513, 69, 513, 84, 85, 2049, 1025, 513, 0, 16, 513, 1, 17, 2561, 1025, 513, 32, 33, 513, 18, 513, 2, 34, 3073, 1537, 1025, 513, 48, 3, 49, 513, 19, 513, 50, 35, 3073, 1025, 513, 65, 20, 1025, 513, 64, 51, 513, 66, 36, 2561, 1537, 1025, 513, 4, 80, 67, 513, 52, 81, 2049, 1025, 513, 21, 82, 513, 37, 68, 1537, 1025, 513, 5, 84, 83, 513, 53, 513, 69, 85, 513, 0, 1025, 513, 16, 1, 2561, 513, 17, 1025, 513, 32, 2, 513, 33, 18, 7169, 2049, 1025, 513, 34, 48, 513, 49, 19, 2049, 1025, 513, 3, 50, 513, 35, 64, 1025, 513, 65, 20, 1025, 513, 4, 51, 513, 66, 36, 7169, 2561, 1537, 1025, 513, 80, 5, 96, 513, 97, 22, 3073, 1537, 1025, 513, 67, 52, 81, 513, 21, 513, 82, 37, 1025, 513, 38, 54, 113, 5121, 2049, 513, 23, 1025, 513, 68, 83, 6, 1537, 1025, 513, 53, 69, 98, 513, 112, 513, 7, 100, 3585, 1025, 513, 114, 39, 1537, 513, 99, 513, 84, 85, 513, 70, 115, 2049, 1025, 513, 55, 101, 513, 86, 116, 1537, 513, 71, 513, 102, 117, 1025, 513, 87, 118, 513, 103, 119, 1537, 513, 0, 513, 16, 1, 2049, 513, 17, 1025, 513, 32, 2, 18, 6145, 2049, 513, 33, 513, 34, 513, 48, 3, 1025, 513, 49, 19, 1025, 513, 50, 35, 1025, 513, 64, 4, 513, 65, 20, 7681, 4097, 2561, 1025, 513, 66, 36, 1025, 513, 51, 67, 80, 1025, 513, 52, 81, 97, 1537, 513, 22, 513, 6, 38, 513, 98, 513, 21, 513, 5, 82, 4097, 2561, 1537, 1025, 513, 37, 68, 96, 513, 99, 54, 1025, 513, 112, 23, 113, 4097, 1537, 1025, 513, 7, 100, 114, 513, 39, 1025, 513, 83, 53, 513, 84, 69, 2561, 1025, 513, 70, 115, 513, 55, 513, 101, 86, 2561, 1537, 1025, 513, 85, 87, 116, 513, 71, 102, 1025, 513, 117, 118, 513, 103, 119, 3073, 1025, 513, 16, 1, 513, 17, 513, 0, 513, 32, 2, 4097, 1025, 513, 33, 18, 1025, 513, 34, 49, 513, 19, 513, 48, 513, 3, 64, 6657, 2049, 1025, 513, 50, 35, 513, 65, 51, 2561, 1025, 513, 20, 66, 513, 36, 513, 4, 80, 1025, 513, 67, 52, 513, 81, 21, 7169, 3585, 2049, 1025, 513, 82, 37, 513, 83, 53, 1025, 513, 96, 22, 97, 1025, 513, 98, 38, 1537, 1025, 513, 5, 6, 68, 513, 84, 69, 4609, 2561, 1025, 513, 99, 54, 1025, 513, 112, 7, 113, 1025, 513, 23, 100, 513, 70, 114, 2561, 1537, 513, 39, 513, 85, 115, 513, 55, 86, 2049, 1025, 513, 101, 116, 513, 71, 102, 1025, 513, 117, 87, 513, 118, 513, 103, 119, 513, 0, 1537, 513, 16, 513, 1, 17, 7169, 2049, 1025, 513, 32, 2, 513, 33, 18, 2049, 1025, 513, 34, 48, 513, 3, 49, 1537, 513, 19, 513, 50, 35, 1025, 513, 64, 4, 65, 17921, 7169, 3585, 1537, 513, 20, 513, 51, 66, 1025, 513, 36, 80, 513, 67, 52, 1025, 513, 81, 21, 1025, 513, 5, 82, 513, 37, 513, 68, 83, 3585, 2049, 1025, 513, 96, 6, 513, 97, 22, 1025, 513, 128, 8, 129, 4097, 2049, 1025, 513, 53, 98, 513, 38, 84, 1025, 513, 69, 99, 513, 54, 112, 1537, 1025, 513, 7, 85, 113, 513, 23, 513, 39, 55, 18433, 6145, 3073, 1025, 513, 24, 130, 513, 40, 1025, 513, 100, 70, 114, 2049, 1025, 513, 132, 72, 513, 144, 9, 513, 145, 25, 6145, 3585, 2049, 1025, 513, 115, 101, 513, 86, 116, 1025, 513, 71, 102, 131, 1537, 513, 56, 513, 117, 87, 513, 146, 41, 3585, 2049, 1025, 513, 103, 133, 513, 88, 57, 513, 147, 513, 73, 134, 1537, 513, 160, 513, 104, 10, 513, 161, 26, 17409, 6145, 3073, 1025, 513, 162, 42, 1025, 513, 149, 89, 513, 163, 58, 2049, 1025, 513, 74, 150, 513, 176, 11, 513, 177, 27, 5121, 2049, 513, 178, 1025, 513, 118, 119, 148, 1537, 1025, 513, 135, 120, 164, 1025, 513, 105, 165, 43, 3073, 1537, 1025, 513, 90, 136, 179, 513, 59, 513, 121, 166, 1537, 1025, 513, 106, 180, 192, 1025, 513, 12, 152, 193, 15361, 5633, 2561, 1537, 513, 28, 513, 137, 181, 513, 91, 194, 1025, 513, 44, 60, 1025, 513, 182, 107, 513, 196, 76, 4097, 2049, 1025, 513, 168, 138, 513, 208, 13, 513, 209, 513, 75, 513, 151, 167, 3073, 1537, 513, 195, 513, 122, 153, 1025, 513, 197, 92, 183, 1025, 513, 29, 210, 513, 45, 513, 123, 211, 13313, 7169, 3073, 1025, 513, 61, 198, 1025, 513, 108, 169, 513, 154, 212, 2049, 1025, 513, 184, 139, 513, 77, 199, 1025, 513, 124, 213, 513, 93, 224, 2561, 1025, 513, 225, 30, 1025, 513, 14, 46, 226, 2049, 1025, 513, 227, 109, 513, 140, 228, 1025, 513, 229, 186, 240, 9729, 4097, 1025, 513, 241, 31, 1537, 1025, 513, 170, 155, 185, 513, 62, 513, 214, 200, 3073, 1537, 513, 78, 513, 215, 125, 513, 171, 513, 94, 201, 1537, 513, 15, 513, 156, 110, 513, 242, 47, 8193, 4097, 1537, 1025, 513, 216, 141, 63, 1537, 513, 243, 513, 230, 202, 513, 244, 79, 2049, 1025, 513, 187, 172, 513, 231, 245, 1025, 513, 217, 157, 513, 95, 232, 7681, 3073, 1537, 513, 111, 513, 246, 203, 1025, 513, 188, 173, 218, 2049, 513, 247, 1025, 513, 126, 127, 142, 1537, 1025, 513, 158, 174, 204, 513, 248, 143, 4609, 2049, 1025, 513, 219, 189, 513, 234, 249, 1025, 513, 159, 235, 513, 190, 513, 205, 250, 3585, 1025, 513, 221, 236, 1537, 1025, 513, 233, 175, 220, 513, 206, 251, 2049, 1025, 513, 191, 222, 513, 207, 238, 1025, 513, 223, 239, 513, 255, 513, 237, 513, 253, 513, 252, 254, 4097, 1537, 513, 0, 513, 16, 1, 513, 17, 1025, 513, 32, 2, 513, 33, 18, 12801, 4097, 1537, 513, 34, 513, 48, 49, 1537, 513, 19, 513, 3, 64, 513, 50, 35, 3585, 1537, 1025, 513, 4, 20, 65, 1025, 513, 51, 66, 513, 36, 67, 2561, 1537, 513, 52, 513, 80, 5, 513, 81, 21, 1025, 513, 82, 37, 1025, 513, 68, 83, 97, 23041, 9217, 4609, 2561, 1537, 513, 53, 513, 96, 6, 513, 22, 98, 1025, 513, 38, 84, 513, 69, 99, 2561, 1537, 513, 54, 513, 112, 7, 513, 113, 85, 1025, 513, 23, 100, 513, 114, 39, 6145, 4097, 2049, 1025, 513, 70, 115, 513, 55, 101, 1025, 513, 86, 128, 513, 8, 116, 1025, 513, 129, 24, 513, 130, 40, 4097, 2049, 1025, 513, 71, 102, 513, 131, 56, 1025, 513, 117, 87, 513, 132, 72, 1537, 1025, 513, 144, 25, 145, 1025, 513, 146, 118, 513, 103, 41, 23553, 9217, 4609, 2561, 1025, 513, 133, 88, 1025, 513, 9, 119, 147, 1025, 513, 57, 148, 513, 73, 134, 2561, 1537, 513, 104, 513, 160, 10, 513, 161, 26, 1025, 513, 162, 42, 513, 149, 89, 6657, 3585, 1537, 513, 163, 513, 58, 135, 1025, 513, 120, 164, 513, 74, 150, 1537, 1025, 513, 105, 176, 177, 1025, 513, 27, 165, 178, 3585, 2049, 1025, 513, 90, 43, 513, 136, 151, 513, 179, 513, 121, 59, 2049, 1025, 513, 106, 180, 513, 75, 193, 1025, 513, 152, 137, 513, 28, 181, 20481, 8705, 4097, 1537, 1025, 513, 91, 44, 194, 1537, 1025, 513, 11, 192, 166, 513, 167, 122, 2561, 1025, 513, 195, 60, 1025, 513, 12, 153, 182, 1025, 513, 107, 196, 513, 76, 168, 5121, 2561, 1025, 513, 138, 197, 1025, 513, 208, 92, 209, 1025, 513, 183, 123, 513, 29, 513, 13, 45, 3073, 1025, 513, 210, 211, 1025, 513, 61, 198, 513, 108, 169, 1537, 1025, 513, 154, 184, 212, 1025, 513, 139, 77, 513, 199, 124, 17409, 8705, 4609, 2561, 1025, 513, 213, 93, 1025, 513, 224, 14, 225, 1025, 513, 30, 226, 513, 170, 46, 2049, 1025, 513, 185, 155, 513, 227, 214, 1025, 513, 109, 62, 513, 200, 140, 4097, 2049, 1025, 513, 228, 78, 513, 215, 125, 1025, 513, 229, 186, 513, 171, 94, 2049, 1025, 513, 201, 156, 513, 241, 31, 1537, 1025, 513, 240, 110, 242, 513, 47, 230, 9729, 4609, 2049, 1025, 513, 216, 243, 513, 63, 244, 1537, 513, 79, 513, 141, 217, 513, 187, 202, 2049, 1025, 513, 172, 231, 513, 126, 245, 2049, 1025, 513, 157, 95, 513, 232, 142, 513, 246, 203, 8705, 4609, 2561, 1537, 1025, 513, 15, 174, 111, 513, 188, 218, 1025, 513, 173, 247, 513, 127, 233, 2049, 1025, 513, 158, 204, 513, 248, 143, 1025, 513, 219, 189, 513, 234, 249, 4097, 2049, 1025, 513, 159, 220, 513, 205, 235, 1025, 513, 190, 250, 513, 175, 221, 3585, 1537, 1025, 513, 236, 206, 251, 1025, 513, 191, 237, 513, 222, 252, 1537, 1025, 513, 207, 253, 238, 1025, 513, 223, 254, 513, 239, 255, 513, 0, 1537, 513, 16, 513, 1, 17, 10753, 2049, 1025, 513, 32, 2, 513, 33, 18, 2561, 1537, 513, 34, 513, 48, 3, 513, 49, 19, 2561, 1025, 513, 50, 35, 1025, 513, 64, 4, 65, 1537, 513, 20, 513, 51, 66, 1025, 513, 36, 80, 513, 67, 52, 35329, 10241, 4097, 1537, 1025, 513, 5, 21, 81, 1025, 513, 82, 37, 1025, 513, 68, 53, 83, 2561, 1537, 1025, 513, 96, 6, 97, 513, 22, 98, 2049, 1025, 513, 38, 84, 513, 69, 99, 1025, 513, 54, 112, 113, 10241, 4609, 2049, 513, 23, 513, 7, 513, 85, 100, 1025, 513, 114, 39, 1025, 513, 70, 101, 115, 2561, 1537, 513, 55, 513, 86, 8, 513, 128, 129, 1537, 513, 24, 513, 116, 71, 513, 130, 513, 40, 102, 6145, 3585, 2049, 1025, 513, 131, 56, 513, 117, 132, 1025, 513, 72, 144, 145, 1537, 513, 25, 513, 9, 118, 513, 146, 41, 3585, 2049, 1025, 513, 133, 88, 513, 147, 57, 1025, 513, 160, 10, 26, 2049, 513, 162, 513, 103, 513, 87, 73, 1537, 513, 148, 513, 119, 134, 513, 161, 513, 104, 149, 56321, 32257, 12801, 6657, 3073, 1537, 513, 42, 513, 89, 58, 513, 163, 513, 135, 120, 2049, 1025, 513, 164, 74, 513, 150, 105, 1025, 513, 176, 11, 177, 2561, 1025, 513, 27, 178, 513, 43, 513, 165, 90, 1537, 513, 179, 513, 166, 106, 1025, 513, 180, 75, 513, 12, 193, 7681, 3585, 1537, 1025, 513, 181, 194, 44, 1025, 513, 167, 195, 513, 107, 196, 2049, 513, 29, 1025, 513, 136, 151, 59, 1025, 513, 209, 210, 513, 45, 211, 4609, 1537, 1025, 513, 30, 46, 226, 1537, 1025, 513, 121, 152, 192, 513, 28, 513, 137, 91, 3585, 1537, 513, 60, 513, 122, 182, 1025, 513, 76, 153, 513, 168, 138, 1537, 513, 13, 513, 197, 92, 1025, 513, 61, 198, 513, 108, 154, 22529, 22017, 9217, 4097, 2049, 1025, 513, 139, 77, 513, 199, 124, 1025, 513, 213, 93, 513, 224, 14, 2049, 513, 227, 1025, 513, 208, 183, 123, 1537, 1025, 513, 169, 184, 212, 513, 225, 513, 170, 185, 6145, 2561, 1537, 1025, 513, 155, 214, 109, 513, 62, 200, 1537, 1025, 513, 140, 228, 78, 1025, 513, 215, 229, 513, 186, 171, 3073, 1025, 513, 156, 230, 1025, 513, 110, 216, 513, 141, 187, 2049, 1025, 513, 231, 157, 513, 232, 142, 1025, 513, 203, 188, 158, 241, 513, 31, 513, 15, 47, 16897, 14337, 513, 242, 13313, 12801, 5121, 2049, 513, 189, 513, 94, 513, 125, 201, 1537, 513, 202, 513, 172, 126, 1025, 513, 218, 173, 204, 2561, 1537, 513, 174, 513, 219, 220, 513, 205, 190, 1537, 1025, 513, 235, 237, 238, 1537, 1025, 513, 217, 234, 233, 513, 222, 1025, 513, 221, 236, 206, 63, 240, 1025, 513, 243, 244, 513, 79, 513, 245, 95, 2561, 513, 255, 1025, 513, 246, 111, 513, 247, 127, 3073, 1537, 513, 143, 513, 248, 249, 1025, 513, 159, 250, 175, 2049, 1025, 513, 251, 191, 513, 252, 207, 1025, 513, 253, 223, 513, 254, 239, 15361, 2049, 1025, 513, 0, 16, 513, 1, 17, 3585, 1537, 1025, 513, 32, 2, 33, 513, 18, 513, 34, 513, 48, 3, 3585, 1025, 513, 49, 19, 1025, 513, 50, 35, 1025, 513, 64, 4, 65, 2049, 1025, 513, 20, 51, 513, 66, 36, 1537, 1025, 513, 67, 52, 81, 1537, 1025, 513, 80, 5, 21, 513, 82, 37, 64001, 25089, 8705, 4609, 2561, 1025, 513, 68, 83, 513, 53, 513, 96, 6, 1025, 513, 97, 22, 513, 98, 38, 2049, 1025, 513, 84, 69, 513, 99, 54, 1025, 513, 113, 85, 513, 100, 70, 8193, 3585, 1537, 513, 114, 513, 39, 55, 513, 115, 1025, 513, 112, 7, 23, 2561, 1025, 513, 101, 86, 1025, 513, 128, 8, 129, 1025, 513, 116, 71, 513, 24, 130, 4097, 2049, 1025, 513, 40, 102, 513, 131, 56, 1025, 513, 117, 87, 513, 132, 72, 2049, 1025, 513, 145, 25, 513, 146, 118, 1025, 513, 103, 41, 513, 133, 88, 23553, 8705, 4097, 2049, 1025, 513, 147, 57, 513, 148, 73, 1025, 513, 119, 134, 513, 104, 161, 2049, 1025, 513, 162, 42, 513, 149, 89, 1025, 513, 163, 58, 513, 135, 513, 120, 74, 5633, 3073, 1025, 513, 164, 150, 1025, 513, 105, 177, 513, 27, 165, 1537, 513, 178, 513, 90, 43, 513, 136, 179, 4097, 2561, 1537, 513, 144, 513, 9, 160, 513, 151, 121, 1025, 513, 166, 106, 180, 3073, 1537, 513, 26, 513, 10, 176, 513, 59, 513, 11, 192, 1025, 513, 75, 193, 513, 152, 137, 17153, 8705, 4097, 2049, 1025, 513, 28, 181, 513, 91, 194, 1025, 513, 44, 167, 513, 122, 195, 2561, 1537, 513, 60, 513, 12, 208, 513, 182, 107, 1025, 513, 196, 76, 513, 153, 168, 4097, 2049, 1025, 513, 138, 197, 513, 92, 209, 1025, 513, 183, 123, 513, 29, 210, 2305, 1025, 513, 45, 211, 513, 61, 198, 22010, 1025, 513, 108, 169, 513, 154, 212, 8193, 4097, 2049, 1025, 513, 184, 139, 513, 77, 199, 1025, 513, 124, 213, 513, 93, 225, 2049, 1025, 513, 30, 226, 513, 170, 185, 1025, 513, 155, 227, 513, 214, 109, 5121, 2561, 1537, 513, 62, 513, 46, 78, 513, 200, 140, 1025, 513, 228, 215, 1025, 513, 125, 171, 229, 2561, 1025, 513, 186, 94, 513, 201, 513, 156, 110, 2049, 513, 230, 513, 13, 513, 224, 14, 1025, 513, 216, 141, 513, 187, 202, 18945, 513, 255, 16385, 14849, 8193, 4097, 2049, 1025, 513, 172, 231, 513, 126, 217, 1025, 513, 157, 232, 513, 142, 203, 2049, 1025, 513, 188, 218, 513, 173, 233, 1025, 513, 158, 204, 513, 219, 189, 4097, 2049, 1025, 513, 234, 174, 513, 220, 205, 1025, 513, 235, 190, 513, 221, 236, 2049, 1025, 513, 206, 237, 513, 222, 238, 15, 1025, 513, 240, 31, 241, 1025, 513, 242, 47, 513, 243, 63, 4609, 2049, 1025, 513, 244, 79, 513, 245, 95, 1025, 513, 246, 111, 513, 247, 513, 127, 143, 2561, 1025, 513, 248, 249, 1025, 513, 159, 175, 250, 2049, 1025, 513, 251, 191, 513, 252, 207, 1025, 513, 253, 223, 513, 254, 239, 513, 0, 2049, 1025, 513, 8, 4, 513, 1, 2, 2049, 1025, 513, 12, 10, 513, 3, 6, 1537, 513, 9, 513, 5, 7, 1025, 513, 14, 13, 513, 15, 11, 4097, 2049, 1025, 513, 0, 1, 513, 2, 3, 1025, 513, 4, 5, 513, 6, 7, 2049, 1025, 513, 8, 9, 513, 10, 11, 1025, 513, 12, 13, 513, 14, 15};
        HUFFMAN_TABLE_OFFSET_LAYER_III = new int[]{Short.MIN_VALUE, 0, 7, 24, Short.MIN_VALUE, 41, 72, 103, 174, 245, 316, 443, 570, 697, Short.MIN_VALUE, 1208, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 1719, 2230, 2230, 2230, 2230, 2230, 2230, 2230, 2230, 2742, 2261};
        HUFFMAN_TREELEN_LAYER_III = new int[]{0, 7, 17, 17, 0, 31, 31, 71, 71, 71, 127, 127, 127, 511, 0, 511, 511, 511, 511, 511, 511, 511, 511, 511, 512, 512, 512, 512, 512, 512, 512, 512, 31, 31};
        HUFFMAN_LINBITS_LAYER_III = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 6, 8, 10, 13, 4, 5, 6, 7, 8, 9, 11, 13, 0, 0};
        REQUANTIZE_LONG_PRETAB_LAYER_III = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 2.0f, 2.0f, 3.0f, 3.0f, 3.0f, 2.0f};
        PRE_FRACTOR_LAYER_I = new float[16];
        for (i = 0; i < 16; ++i) {
            double pow = 1 << i;
            Decoder.PRE_FRACTOR_LAYER_I[i] = (float)(pow / (pow - 1.0));
        }
        NIK_COEFFICIENTS = new float[2048];
        for (i = 0; i < 64; ++i) {
            for (int k = 0; k < 32; ++k) {
                double value = 1.0E9 * Math.cos((double)((16 + i) * (2 * k + 1)) * Math.PI / 64.0);
                value = value >= 0.0 ? (double)((int)(value + 0.5)) : (double)((int)(value - 0.5));
                Decoder.NIK_COEFFICIENTS[i * 32 + k] = (float)(value * 1.0E-9);
            }
        }
        POWTAB_LAYER_III = new float[8207];
        for (i = 0; i < 8207; ++i) {
            Decoder.POWTAB_LAYER_III[i] = (float)Math.pow(i, 1.3333333333333333);
        }
        IS_RATIOS_LAYER_III = new float[6];
        for (i = 0; i < 6; ++i) {
            Decoder.IS_RATIOS_LAYER_III[i] = (float)Math.tan((double)i * Math.PI / 12.0);
        }
        IMDCT_WINDOW_LAYER_III = new float[144];
        for (i = 0; i < 36; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[0 + i] = (float)Math.sin(0.08726646259971647 * ((double)i + 0.5));
        }
        for (i = 0; i < 18; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[36 + i] = (float)Math.sin(0.08726646259971647 * ((double)i + 0.5));
        }
        for (i = 18; i < 24; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[36 + i] = 1.0f;
        }
        for (i = 24; i < 30; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[36 + i] = (float)Math.sin(0.2617993877991494 * ((double)i + 0.5 - 18.0));
        }
        for (i = 0; i < 12; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[72 + i] = (float)Math.sin(0.2617993877991494 * ((double)i + 0.5));
        }
        for (i = 6; i < 12; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[108 + i] = (float)Math.sin(0.2617993877991494 * ((double)i + 0.5 - 6.0));
        }
        for (i = 12; i < 18; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[108 + i] = 1.0f;
        }
        for (i = 18; i < 36; ++i) {
            Decoder.IMDCT_WINDOW_LAYER_III[108 + i] = (float)Math.sin(0.08726646259971647 * ((double)i + 0.5));
        }
        SYNTH_WINDOW_TABLE_LAYER_III = new float[2048];
        for (i = 0; i < 64; ++i) {
            for (int j = 0; j < 32; ++j) {
                Decoder.SYNTH_WINDOW_TABLE_LAYER_III[i * 32 + j] = (float)Math.cos((double)((16 + i) * (2 * j + 1)) * Math.PI / 64.0);
            }
        }
        COS_12_LAYER_III = new float[72];
        for (i = 0; i < 6; ++i) {
            for (int j = 0; j < 12; ++j) {
                Decoder.COS_12_LAYER_III[i * 12 + j] = (float)Math.cos(0.1308996938995747 * (2.0 * (double)j + 1.0 + 6.0) * (2.0 * (double)i + 1.0));
            }
        }
        COS_36_LAYER_III = new float[648];
        for (i = 0; i < 18; ++i) {
            for (int j = 0; j < 36; ++j) {
                Decoder.COS_36_LAYER_III[i * 36 + j] = (float)Math.cos(0.04363323129985824 * (2.0 * (double)j + 1.0 + 18.0) * (2.0 * (double)i + 1.0));
            }
        }
    }

    static final class SoundData {
        private Buffer buffer;
        int frequency = -1;
        int stereo = -1;
        private int[] synthOffset;
        private float[] synthBuffer;
        private byte[] mainData;
        private MainDataReader mainDataReader;
        private float[] store;
        private float[] v;
        byte[] samplesBuffer;

        SoundData() {
        }

        static /* synthetic */ byte[] access$102(SoundData x0, byte[] x1) {
            x0.mainData = x1;
            return x1;
        }

        static /* synthetic */ float[] access$202(SoundData x0, float[] x1) {
            x0.store = x1;
            return x1;
        }

        static /* synthetic */ float[] access$302(SoundData x0, float[] x1) {
            x0.v = x1;
            return x1;
        }

        static /* synthetic */ int[] access$502(SoundData x0, int[] x1) {
            x0.synthOffset = x1;
            return x1;
        }

        static /* synthetic */ float[] access$602(SoundData x0, float[] x1) {
            x0.synthBuffer = x1;
            return x1;
        }
    }

    private static final class Buffer {
        public final InputStream in;
        public int current = 0;
        public int lastByte = -1;

        public Buffer(InputStream inputStream) {
            this.in = inputStream;
        }
    }

    private static final class MainDataReader {
        public final byte[] array;
        public int top = 0;
        public int index = 0;
        public int current = 0;

        public MainDataReader(byte[] array) {
            this.array = array;
        }
    }
}

