/**
 * Copyright (C) 2011-2015 The XDocReport Team <xdocreport@googlegroups.com>
 *
 * All rights reserved.
 *
 * Permission is hereby granted, free  of charge, to any person obtaining
 * a  copy  of this  software  and  associated  documentation files  (the
 * "Software"), to  deal in  the Software without  restriction, including
 * without limitation  the rights to  use, copy, modify,  merge, publish,
 * distribute,  sublicense, and/or sell  copies of  the Software,  and to
 * permit persons to whom the Software  is furnished to do so, subject to
 * the following conditions:
 *
 * The  above  copyright  notice  and  this permission  notice  shall  be
 * included in all copies or substantial portions of the Software.
 *
 * THE  SOFTWARE IS  PROVIDED  "AS  IS", WITHOUT  WARRANTY  OF ANY  KIND,
 * EXPRESS OR  IMPLIED, INCLUDING  BUT NOT LIMITED  TO THE  WARRANTIES OF
 * MERCHANTABILITY,    FITNESS    FOR    A   PARTICULAR    PURPOSE    AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE,  ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.lowagie.text.Chunk;
import com.lowagie.text.pdf.ColumnText;

/**
 * This is used for a StylableColumnText.
 */
public class StylableColumnText
    extends ColumnText
{

    /** Constructs a StylableColumnText. */
    public StylableColumnText()
    {
        super( null );
    }

    /** @return true if all of the elements are blank */
    public boolean isBlank()
    {
        if ( compositeElements != null )
        {
            for ( Object element : compositeElements )
            {
                if ( !( element instanceof StylableParagraph ) )
                {
                    return false;
                }
                for ( Object object : ( (StylableParagraph) element ).getChunks() )
                {
                    if ( object instanceof Chunk )
                    {
                        Chunk chunk = (Chunk) object;
                        if ( chunk.hasAttributes() || !chunk.getContent().trim().isEmpty() )
                        {
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }
}
