/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen.apt;

import io.helidon.codegen.CodegenException;
import io.helidon.codegen.FilerTextResource;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.processing.Filer;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

class FilerTextResourceImpl
implements FilerTextResource {
    private final Filer filer;
    private final String location;
    private final Element[] originatingElements;
    private final FileObject originalResource;
    private final List<String> currentLines;
    private boolean modified;

    FilerTextResourceImpl(Filer filer, String location, Element[] originatingElements) {
        this.filer = filer;
        this.location = location;
        this.originatingElements = originatingElements;
        this.originalResource = null;
        this.currentLines = new ArrayList<String>();
    }

    FilerTextResourceImpl(Filer filer, String location, Element[] originatingElements, FileObject originalResource, List<String> existingLines) {
        this.filer = filer;
        this.location = location;
        this.originatingElements = originatingElements;
        this.originalResource = originalResource;
        this.currentLines = new ArrayList<String>(existingLines);
    }

    public List<String> lines() {
        return List.copyOf(this.currentLines);
    }

    public void lines(List<String> newLines) {
        this.currentLines.clear();
        this.currentLines.addAll(newLines);
        this.modified = true;
    }

    public void write() {
        if (this.modified) {
            if (this.originalResource != null) {
                try {
                    this.originalResource.delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                FileObject newResource = this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.location, this.originatingElements);
                try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(newResource.openOutputStream(), StandardCharsets.UTF_8));){
                    for (String line : this.currentLines) {
                        pw.println(line);
                    }
                }
            }
            catch (Exception e) {
                throw new CodegenException("Failed to create resource: " + this.location, (Throwable)e);
            }
        }
    }
}

