/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.codegen;

import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.Annotation;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.Executable;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.stream.Collectors;

final class ClassModelFactory {
    private ClassModelFactory() {
    }

    static TypeInfo create(RoundContext ctx, TypeName requestedTypeName, ClassBase requestedType) {
        TypeInfo.Builder builder = (TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)((TypeInfo.Builder)TypeInfo.builder().typeName(requestedTypeName)).kind(requestedType.kind())).accessModifier(requestedType.accessModifier())).description(String.join((CharSequence)"\n", requestedType.description()));
        for (Annotation annotation : requestedType.annotations()) {
            builder.addAnnotation(annotation.toTypesAnnotation());
        }
        requestedType.superTypeName().flatMap(ctx::typeInfo).ifPresent(arg_0 -> ((TypeInfo.Builder)builder).superTypeInfo(arg_0));
        List typeNames = requestedType.interfaceTypeNames();
        for (TypeName typeName : typeNames) {
            ctx.typeInfo(typeName).ifPresent(arg_0 -> ((TypeInfo.Builder)builder).addInterfaceTypeInfo(arg_0));
        }
        for (Field field : requestedType.fields()) {
            ClassModelFactory.addField(builder, field);
        }
        for (Constructor constructor : requestedType.constructors()) {
            ClassModelFactory.addConstructor(requestedTypeName, builder, constructor);
        }
        for (Method method : requestedType.methods()) {
            ClassModelFactory.addMethod(builder, method);
        }
        for (ClassBase innerClass : requestedType.innerClasses()) {
            ClassModelFactory.addInnerClass(requestedTypeName, builder, innerClass);
        }
        return builder.build();
    }

    private static void addInnerClass(TypeName requestedTypeName, TypeInfo.Builder builder, ClassBase innerClass) {
        builder.addElementInfo(innerInfo -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)innerInfo.typeName(ClassModelFactory.innerClassTypeName(requestedTypeName, innerClass.name()))).kind(ElementKind.CLASS)).elementName(innerClass.name())).accessModifier(innerClass.accessModifier())).update(it -> {
            if (innerClass.isStatic()) {
                it.addElementModifier(Modifier.STATIC);
            }
            if (innerClass.isAbstract()) {
                it.addElementModifier(Modifier.ABSTRACT);
            }
            if (innerClass.isFinal()) {
                it.addElementModifier(Modifier.FINAL);
            }
        })).description(String.join((CharSequence)"\n", innerClass.description()))).update(it -> ClassModelFactory.addAnnotations(it, innerClass.annotations())));
    }

    private static TypeName innerClassTypeName(TypeName requestedTypeName, String name) {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)requestedTypeName).addEnclosingName(requestedTypeName.className())).className(name)).build();
    }

    private static void addMethod(TypeInfo.Builder builder, Method method) {
        builder.addElementInfo(methodInfo -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)methodInfo.kind(ElementKind.METHOD)).elementName(method.name())).accessModifier(method.accessModifier())).update(it -> {
            if (method.isStatic()) {
                it.addElementModifier(Modifier.STATIC);
            }
            if (method.isFinal()) {
                it.addElementModifier(Modifier.FINAL);
            }
            if (method.isAbstract()) {
                it.addElementModifier(Modifier.ABSTRACT);
            }
            if (method.isDefault()) {
                it.addElementModifier(Modifier.DEFAULT);
            }
        })).description(String.join((CharSequence)"\n", method.description()))).update(it -> ClassModelFactory.addAnnotations(it, method.annotations()))).update(it -> ClassModelFactory.processExecutable(it, (Executable)method))).typeName(method.typeName()));
    }

    private static void processExecutable(TypedElementInfo.Builder builder, Executable executable) {
        for (Parameter parameter : executable.parameters()) {
            builder.addParameterArgument(arg -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)arg.kind(ElementKind.PARAMETER)).elementName(parameter.name())).typeName(parameter.typeName())).description(String.join((CharSequence)"\n", parameter.description()))).update(it -> ClassModelFactory.addAnnotations(it, parameter.annotations())));
        }
        builder.addThrowsChecked(executable.exceptions().stream().collect(Collectors.toUnmodifiableSet()));
    }

    private static void addConstructor(TypeName typeName, TypeInfo.Builder builder, Constructor constructor) {
        builder.addElementInfo(ctrInfo -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)ctrInfo.typeName(typeName)).kind(ElementKind.CONSTRUCTOR)).accessModifier(constructor.accessModifier())).description(String.join((CharSequence)"\n", constructor.description()))).update(it -> ClassModelFactory.addAnnotations(it, constructor.annotations()))).update(it -> ClassModelFactory.processExecutable(it, (Executable)constructor)));
    }

    private static void addField(TypeInfo.Builder builder, Field field) {
        builder.addElementInfo(fieldInfo -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)fieldInfo.typeName(field.typeName())).kind(ElementKind.FIELD)).accessModifier(field.accessModifier())).elementName(field.name())).description(String.join((CharSequence)"\n", field.description()))).update(it -> ClassModelFactory.addAnnotations(it, field.annotations()))).update(it -> {
            if (field.isStatic()) {
                it.addElementModifier(Modifier.STATIC);
            }
            if (field.isFinal()) {
                it.addElementModifier(Modifier.FINAL);
            }
            if (field.isVolatile()) {
                it.addElementModifier(Modifier.VOLATILE);
            }
        }));
    }

    private static void addAnnotations(TypedElementInfo.Builder element, List<Annotation> annotations) {
        for (Annotation annotation : annotations) {
            element.addAnnotation(annotation.toTypesAnnotation());
        }
    }
}

