/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.crypto;

import io.helidon.common.Base64Value;
import io.helidon.common.crypto.CryptoException;
import io.helidon.common.crypto.Digest;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Objects;

public class Signature
implements Digest {
    public static final String ALGORITHM_NONE_RSA = "NONEwithRSA";
    @Deprecated
    public static final String ALGORITHM_MD2_RSA = "MD2withRSA";
    @Deprecated
    public static final String ALGORITHM_MD5_RSA = "MD5withRSA";
    public static final String ALGORITHM_SHA1_RSA = "SHA1withRSA";
    public static final String ALGORITHM_SHA224_RSA = "SHA224withRSA";
    public static final String ALGORITHM_SHA256_RSA = "SHA256withRSA";
    public static final String ALGORITHM_SHA384_RSA = "SHA384withRSA";
    public static final String ALGORITHM_SHA512_RSA = "SHA512withRSA";
    public static final String ALGORITHM_SHA512_224_RSA = "SHA512/224withRSA";
    public static final String ALGORITHM_SHA512_256_RSA = "SHA512/256withRSA";
    public static final String ALGORITHM_NONE_ECDSA = "NONEwithECDSA";
    public static final String ALGORITHM_SHA1_ECDSA = "SHA1withECDSA";
    public static final String ALGORITHM_SHA224_ECDSA = "SHA224withECDSA";
    public static final String ALGORITHM_SHA256_ECDSA = "SHA256withECDSA";
    public static final String ALGORITHM_SHA384_ECDSA = "SHA384withECDSA";
    public static final String ALGORITHM_SHA512_ECDSA = "SHA512withECDSA";
    private final String algorithm;
    private final String provider;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;

    private Signature(Builder builder) {
        this.algorithm = builder.algorithm;
        this.provider = builder.provider;
        this.privateKey = builder.privateKey;
        this.publicKey = builder.publicKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Base64Value digest(Base64Value value) {
        if (this.privateKey == null) {
            throw new CryptoException("Private key not set. This object cannot create new signatures");
        }
        try {
            java.security.Signature signature = this.getSignature();
            signature.initSign(this.privateKey);
            signature.update(value.toBytes());
            return Base64Value.create((byte[])signature.sign());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new CryptoException("Could not sign data", e);
        }
    }

    @Override
    public boolean verify(Base64Value toVerify, Base64Value digestToVerify) {
        if (this.publicKey == null) {
            throw new CryptoException("Public key not set. This object cannot verify the signatures");
        }
        try {
            java.security.Signature signature = this.getSignature();
            signature.initVerify(this.publicKey);
            signature.update(toVerify.toBytes());
            return signature.verify(digestToVerify.toBytes());
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | SignatureException e) {
            throw new CryptoException("Could not verify signature", e);
        }
    }

    private java.security.Signature getSignature() throws NoSuchAlgorithmException, NoSuchProviderException {
        if (this.provider == null) {
            return java.security.Signature.getInstance(this.algorithm);
        }
        return java.security.Signature.getInstance(this.algorithm, this.provider);
    }

    public static final class Builder
    implements io.helidon.common.Builder<Builder, Signature> {
        private String algorithm = "SHA256withRSA";
        private String provider = null;
        private PrivateKey privateKey;
        private PublicKey publicKey;

        private Builder() {
        }

        public Builder algorithm(String algorithm) {
            this.algorithm = Objects.requireNonNull(algorithm, "Algorithm cannot be null");
            return this;
        }

        public Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public Builder publicKey(PublicKey publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public Signature build() {
            if (this.privateKey == null && this.publicKey == null) {
                throw new CryptoException("At least private or public key has to be set");
            }
            return new Signature(this);
        }
    }
}

