/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.RuntimeType;
import io.helidon.faulttolerance.AsyncConfig;
import io.helidon.faulttolerance.AsyncImpl;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Supplier;

@RuntimeType.PrototypedBy(value=AsyncConfig.class)
public interface Async
extends RuntimeType.Api<AsyncConfig> {
    public static Async create() {
        return Async.create(AsyncConfig.create());
    }

    public static Async create(AsyncConfig config) {
        return new AsyncImpl(config);
    }

    public static Async create(Consumer<AsyncConfig.Builder> builderConsumer) {
        AsyncConfig.Builder builder = AsyncConfig.builder();
        builderConsumer.accept(builder);
        return Async.create(builder.buildPrototype());
    }

    public static AsyncConfig.Builder builder() {
        return AsyncConfig.builder();
    }

    public static <T> CompletableFuture<T> invokeStatic(Supplier<T> supplier) {
        return Async.create().invoke(supplier);
    }

    public static <T> CompletableFuture<T> invokeStatic(Supplier<T> supplier, CompletableFuture<Async> onStart) {
        return Async.create(((AsyncConfig.Builder)AsyncConfig.builder().onStart(onStart)).buildPrototype()).invoke(supplier);
    }

    public <T> CompletableFuture<T> invoke(Supplier<T> var1);
}

