/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.faulttolerance;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.faulttolerance.Async;
import io.helidon.faulttolerance.AsyncConfig;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

@Prototype.Blueprint(decorator=BuilderDecorator.class)
@Prototype.Configured
interface AsyncConfigBlueprint
extends Prototype.Factory<Async> {
    public Optional<String> name();

    @Option.Configured
    public Optional<String> executorName();

    public Optional<ExecutorService> executor();

    public Optional<CompletableFuture<Async>> onStart();

    public static class BuilderDecorator
    implements Prototype.BuilderDecorator<AsyncConfig.BuilderBase<?, ?>> {
        public void decorate(AsyncConfig.BuilderBase<?, ?> target) {
            if (target.name().isEmpty()) {
                target.config().ifPresent(cfg -> target.name(cfg.name()));
            }
        }
    }
}

