/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.logging.jul;

import io.helidon.logging.common.HelidonMdc;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HelidonFormatter
extends SimpleFormatter {
    static final String THREAD = "thread";
    static final String THREAD_TOKEN = "!thread!";
    static final Pattern THREAD_PATTERN = Pattern.compile("!thread!");
    static final Pattern X_VALUE = Pattern.compile("(\\s?%X\\{)(\\S*?)(})");
    static final Map<String, Pattern> PATTERN_CACHE = new HashMap<String, Pattern>();
    static final String JUL_FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";
    private final String format = LogManager.getLogManager().getProperty("java.util.logging.SimpleFormatter.format");
    private final Set<String> parsedProps = new HashSet<String>();
    private final boolean thread = this.format.contains("!thread!") || this.format.contains("%X{thread}");

    public HelidonFormatter() {
        Matcher matcher = X_VALUE.matcher(this.format);
        while (matcher.find()) {
            this.parsedProps.add(matcher.group(2));
        }
    }

    static String thread(String format) {
        String currentThread = Thread.currentThread().toString();
        String message = PATTERN_CACHE.computeIfAbsent(THREAD, key -> Pattern.compile("%X\\{thread}")).matcher(format).replaceAll(currentThread);
        message = THREAD_PATTERN.matcher(message).replaceAll(currentThread);
        return message;
    }

    static Object[] parameters(LogRecord record, String formattedMessage) {
        Object source;
        ZonedDateTime timestamp = ZonedDateTime.ofInstant(record.getInstant(), ZoneId.systemDefault());
        if (record.getSourceClassName() != null) {
            source = record.getSourceClassName();
            if (record.getSourceMethodName() != null) {
                source = (String)source + " " + record.getSourceMethodName();
            }
        } else {
            source = record.getLoggerName();
        }
        String throwable = "";
        if (record.getThrown() != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println();
            record.getThrown().printStackTrace(pw);
            pw.close();
            throwable = sw.toString();
        }
        Object[] result = new Object[]{timestamp, source, record.getLoggerName(), record.getLevel().getName(), formattedMessage, throwable};
        return result;
    }

    @Override
    public String format(LogRecord record) {
        String message = this.thread ? HelidonFormatter.thread(this.format) : this.format;
        for (String parsedKey : this.parsedProps) {
            String value = HelidonMdc.get((String)parsedKey).orElse("");
            message = PATTERN_CACHE.computeIfAbsent(parsedKey, key -> Pattern.compile("%X\\{" + key + "}")).matcher(message).replaceAll(value);
        }
        return this.formatRow(record, message);
    }

    private String formatRow(LogRecord record, String format) {
        return String.format(format, HelidonFormatter.parameters(record, super.formatMessage(record)));
    }
}

