/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.Bucket;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

class MBucket
implements Bucket {
    private final CountAtBucket delegate;

    private MBucket(CountAtBucket delegate) {
        this.delegate = delegate;
    }

    static MBucket create(CountAtBucket delegate) {
        return new MBucket(delegate);
    }

    public double boundary() {
        return this.delegate.bucket();
    }

    public double boundary(TimeUnit unit) {
        return this.delegate.bucket(unit);
    }

    public long count() {
        return (long)this.delegate.count();
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bucket)) {
            return false;
        }
        Bucket that = (Bucket)o;
        return Objects.equals(this.delegate.bucket(), that.boundary()) && Objects.equals((long)this.delegate.count(), that.count());
    }

    public int hashCode() {
        return Objects.hash((long)this.delegate.bucket(), this.delegate.count());
    }

    public String toString() {
        return new StringJoiner(",", this.getClass().getSimpleName() + "[", "]").add("boundary=" + this.boundary()).add("count=" + this.count()).toString();
    }
}

