/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.metrics.api.Bucket;
import io.helidon.metrics.api.ValueAtPercentile;
import io.helidon.metrics.providers.micrometer.MBucket;
import io.helidon.metrics.providers.micrometer.MValueAtPercentile;
import io.micrometer.core.instrument.distribution.CountAtBucket;
import io.micrometer.core.instrument.distribution.HistogramSnapshot;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

class MHistogramSnapshot
implements io.helidon.metrics.api.HistogramSnapshot {
    private final HistogramSnapshot delegate;

    private MHistogramSnapshot(HistogramSnapshot delegate) {
        this.delegate = delegate;
    }

    static MHistogramSnapshot create(HistogramSnapshot delegate) {
        return new MHistogramSnapshot(delegate);
    }

    public long count() {
        return this.delegate.count();
    }

    public double total() {
        return this.delegate.total();
    }

    public double total(TimeUnit timeUnit) {
        return this.delegate.total(timeUnit);
    }

    public double max() {
        return this.delegate.max();
    }

    public double mean() {
        return this.delegate.mean();
    }

    public double mean(TimeUnit timeUnit) {
        return this.delegate.mean(timeUnit);
    }

    public String toString() {
        return new StringJoiner(",", this.getClass().getSimpleName() + "[", "]").add("count=" + this.count()).add("total=" + this.total()).add("mean=" + this.mean()).add("max=" + this.max()).toString();
    }

    public Iterable<? extends ValueAtPercentile> percentileValues() {
        return Arrays.stream(this.delegate.percentileValues()).map(MValueAtPercentile::create).toList();
    }

    public Iterable<Bucket> histogramCounts() {
        return () -> new Iterator<Bucket>(){
            private final CountAtBucket[] counts;
            private int slot;
            {
                this.counts = MHistogramSnapshot.this.delegate.histogramCounts();
            }

            @Override
            public boolean hasNext() {
                return this.slot < this.counts.length;
            }

            @Override
            public Bucket next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return MBucket.create(this.counts[this.slot++]);
            }
        };
    }

    public void outputSummary(PrintStream out, double scale) {
        this.delegate.outputSummary(out, scale);
    }

    public <R> R unwrap(Class<? extends R> c) {
        return c.cast(this.delegate);
    }
}

