/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metrics.providers.micrometer;

import io.helidon.common.LazyValue;
import io.helidon.metrics.api.SystemTagsManager;
import io.micrometer.core.instrument.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

class SystemTagsMeterFilterManager
implements Consumer<SystemTagsManager> {
    private static final LazyValue<SystemTagsMeterFilterManager> MANAGER = LazyValue.create(() -> {
        SystemTagsMeterFilterManager result = new SystemTagsMeterFilterManager(SystemTagsManager.instance());
        SystemTagsManager.onChange((Consumer)result);
        return result;
    });
    private final List<Tag> micrometerSystemTags = new ArrayList<Tag>();
    private final ReentrantLock lock = new ReentrantLock();

    static SystemTagsMeterFilterManager instance() {
        return (SystemTagsMeterFilterManager)MANAGER.get();
    }

    private SystemTagsMeterFilterManager(SystemTagsManager systemTagsManager) {
        this.apply(systemTagsManager);
    }

    @Override
    public void accept(SystemTagsManager systemTagsManager) {
        this.apply(systemTagsManager);
    }

    Iterable<Tag> tags() {
        return this.micrometerSystemTags;
    }

    private SystemTagsMeterFilterManager apply(SystemTagsManager systemTagsManager) {
        this.lock.lock();
        try {
            this.micrometerSystemTags.clear();
            systemTagsManager.displayTagPairs().forEach((name, value) -> this.micrometerSystemTags.add(Tag.of((String)name, (String)value)));
            SystemTagsMeterFilterManager systemTagsMeterFilterManager = this;
            return systemTagsMeterFilterManager;
        }
        finally {
            this.lock.unlock();
        }
    }
}

