/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.microprofile.metrics;

import io.helidon.metrics.api.Counter;
import io.helidon.metrics.api.Meter;
import io.helidon.metrics.api.MeterRegistry;
import io.helidon.metrics.api.SampledMetric;
import io.helidon.microprofile.metrics.MetricImpl;
import io.helidon.microprofile.metrics.Registry;
import java.util.Objects;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.Tag;

class HelidonCounter
extends MetricImpl<io.helidon.metrics.api.Counter>
implements Counter,
SampledMetric {
    private final io.helidon.metrics.api.Counter delegate;

    private HelidonCounter(String scope, Metadata metadata, io.helidon.metrics.api.Counter delegate) {
        super(scope, metadata);
        this.delegate = delegate;
    }

    static HelidonCounter create(MeterRegistry meterRegistry, String scope, Metadata metadata, Tag ... tags) {
        return HelidonCounter.create(scope, metadata, (io.helidon.metrics.api.Counter)meterRegistry.getOrCreate((Meter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)io.helidon.metrics.api.Counter.builder((String)metadata.getName()).scope(scope)).baseUnit(HelidonCounter.sanitizeUnit(metadata.getUnit()))).description(metadata.getDescription())).tags(HelidonCounter.allTags(scope, tags)))));
    }

    static HelidonCounter create(String scope, Metadata metadata, io.helidon.metrics.api.Counter delegate) {
        return new HelidonCounter(scope, metadata, delegate);
    }

    static HelidonCounter create(io.helidon.metrics.api.Counter delegate) {
        return new HelidonCounter(HelidonCounter.resolvedScope((Meter)delegate), Registry.metadata((Meter)delegate), delegate);
    }

    public void inc() {
        this.delegate.increment();
    }

    public void inc(long n) {
        this.delegate.increment(n);
    }

    public long getCount() {
        return this.delegate.count();
    }

    @Override
    public io.helidon.metrics.api.Counter delegate() {
        return this.delegate;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }

    @Override
    public Class<io.helidon.metrics.api.Counter> delegateType() {
        return io.helidon.metrics.api.Counter.class;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        HelidonCounter that = (HelidonCounter)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    @Override
    protected String toStringDetails() {
        return ", counter='" + this.getCount() + "'";
    }
}

