/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.security.AuditEvent;
import io.helidon.security.AuthenticationResponse;
import io.helidon.security.ProviderRequest;
import io.helidon.security.Security;
import io.helidon.security.SecurityClient;
import io.helidon.security.SecurityContextImpl;
import io.helidon.security.SecurityException;
import io.helidon.security.SecurityRequest;
import io.helidon.security.SecurityResponse;
import io.helidon.security.internal.SecurityAuditEvent;
import io.helidon.security.spi.AuthenticationProvider;

final class AuthenticationClientImpl
implements SecurityClient<AuthenticationResponse> {
    private final Security security;
    private final SecurityContextImpl context;
    private final SecurityRequest request;
    private final String providerName;

    AuthenticationClientImpl(Security security, SecurityContextImpl context, SecurityRequest request, String providerName) {
        this.security = security;
        this.context = context;
        this.request = request;
        this.providerName = providerName;
    }

    @Override
    public AuthenticationResponse submit() {
        AuthenticationResponse authenticationResponse = this.security.resolveAtnProvider(this.providerName).map(this::authenticate).orElseThrow(() -> new SecurityException("Could not find any authentication provider. Security is not configured"));
        return this.mapSubject(authenticationResponse);
    }

    private AuthenticationResponse mapSubject(AuthenticationResponse prevResponse) {
        ProviderRequest providerRequest = new ProviderRequest(this.context, this.request.resources());
        if (prevResponse.status() == SecurityResponse.SecurityStatus.SUCCESS) {
            AuthenticationResponse newResponse = this.security.subjectMapper().map(mapper -> mapper.map(providerRequest, prevResponse)).orElseGet(() -> prevResponse);
            if (newResponse == prevResponse) {
                return prevResponse;
            }
            newResponse.user().ifPresent(this.context::setUser);
            newResponse.service().ifPresent(this.context::setService);
            return newResponse;
        }
        return prevResponse;
    }

    private AuthenticationResponse authenticate(AuthenticationProvider providerInstance) {
        ProviderRequest providerRequest = new ProviderRequest(this.context, this.request.resources());
        AuthenticationResponse response = providerInstance.authenticate(providerRequest);
        try {
            if (response.status().isSuccess()) {
                response.user().ifPresent(this.context::setUser);
                response.service().ifPresent(this.context::setService);
                this.context.audit(SecurityAuditEvent.success("authn.authenticate", "Path %s. Provider %s. Subject %s").addParam(AuditEvent.AuditParam.plain("path", providerRequest.env().path())).addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("subject", response.user())));
                return response;
            }
            SecurityAuditEvent event = SecurityAuditEvent.failure("authn.authenticate", "Provider %s. Message: %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("message", response.description().orElse(null)));
            response.throwable().map(e -> event.addParam(AuditEvent.AuditParam.plain("exception", response.throwable())));
            this.context.audit(event);
            return response;
        }
        catch (Exception e2) {
            this.context.audit(SecurityAuditEvent.error("authn.authenticate", "Provider %s. Message: %s").addParam(AuditEvent.AuditParam.plain("provider", providerInstance.getClass().getName())).addParam(AuditEvent.AuditParam.plain("message", e2.getMessage())).addParam(AuditEvent.AuditParam.plain("exception", e2)));
            throw new SecurityException(e2);
        }
    }
}

