/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.security;

import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.security.AuditEvent;
import io.helidon.security.NamedProvider;
import io.helidon.security.SecurityException;
import io.helidon.security.spi.AuditProvider;
import io.helidon.security.spi.SecurityProvider;
import io.helidon.tracing.Tracer;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

final class SecurityUtil {
    private static final System.Logger LOGGER = System.getLogger(SecurityUtil.class.getName());

    private SecurityUtil() {
    }

    static Set<Class<? extends Annotation>> getAnnotations(Map<SecurityProvider, Boolean> providers) {
        HashSet<Class<? extends Annotation>> annotations = new HashSet<Class<? extends Annotation>>();
        for (SecurityProvider provider : providers.keySet()) {
            annotations.addAll(provider.supportedAnnotations());
        }
        return annotations;
    }

    static Tracer getTracer(boolean tracingEnabled, Tracer builderTracer) {
        if (tracingEnabled) {
            return builderTracer == null ? Tracer.global() : builderTracer;
        }
        return Tracer.noOp();
    }

    static AuditProvider.TracedAuditEvent wrapEvent(final String tracingId, final AuditProvider.AuditSource auditSource, final AuditEvent event) {
        return new AuditProvider.TracedAuditEvent(){

            @Override
            public AuditProvider.AuditSource auditSource() {
                return auditSource;
            }

            @Override
            public String tracingId() {
                return tracingId;
            }

            @Override
            public String eventType() {
                return event.eventType();
            }

            @Override
            public Optional<Throwable> throwable() {
                return event.throwable();
            }

            @Override
            public List<AuditEvent.AuditParam> params() {
                return event.params();
            }

            @Override
            public String messageFormat() {
                return event.messageFormat();
            }

            @Override
            public AuditEvent.AuditSeverity severity() {
                return event.severity();
            }

            public String toString() {
                return event.toString();
            }
        };
    }

    static String forAuditNamed(List<? extends NamedProvider<?>> collection) {
        return collection.stream().map(p -> p.getName() + ": " + p.getProvider().getClass().getName()).collect(Collectors.toList()).toString();
    }

    static String forAudit(Collection<?> collection) {
        return collection.stream().map(p -> p.getClass().getName()).collect(Collectors.toList()).toString();
    }

    static <T> T instantiate(String className, Class<? extends T> type, Config config) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to get class " + className, e);
        }
        Throwable configException = null;
        if (null != config) {
            try {
                return type.cast(config.as(clazz).get());
            }
            catch (ClassCastException e) {
                throw new SecurityException("Class " + className + " is not instance of expected type: " + type.getName());
            }
            catch (ConfigException e) {
                LOGGER.log(System.Logger.Level.TRACE, () -> "Class " + className + " failed to get mapped by config. Will attempt public default constructor", (Throwable)e);
                configException = e;
            }
        }
        try {
            return type.cast(clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            LOGGER.log(System.Logger.Level.TRACE, "Could not instantiate: " + className + ". Class must either have a default public constructor or be mappable by Config");
            configException = null == configException ? e : configException;
            throw new SecurityException("Failed to load " + type.getName() + " from class " + String.valueOf(clazz) + ", parsing from config failed with: " + SecurityUtil.extractExceptionDetails((Exception)configException), e);
        }
    }

    private static String extractExceptionDetails(Exception configException) {
        Throwable cause;
        Throwable prev = configException;
        StringBuilder details = new StringBuilder();
        details.append(configException.getMessage());
        while (null != (cause = prev.getCause()) && cause != prev) {
            details.append(", caused by: ").append(cause.getMessage());
            prev = cause;
        }
        return details.toString();
    }
}

