/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.servicecommon;

import io.helidon.config.Config;
import io.helidon.cors.CrossOriginConfig;
import io.helidon.webserver.servicecommon.RestServiceSettings;
import java.util.Objects;

class RestServiceSettingsImpl
implements RestServiceSettings {
    private final String webContext;
    private final String routing;
    private final CrossOriginConfig crossOriginConfig;
    private final boolean enabled;

    private RestServiceSettingsImpl(Builder builder) {
        this.webContext = Objects.requireNonNull(builder.webContext, "webContext cannot be null");
        if (this.webContext.isBlank()) {
            throw new IllegalArgumentException("webContext cannot be blank");
        }
        this.routing = builder.routing;
        this.enabled = builder.enabled;
        this.crossOriginConfig = builder.crossOriginConfigBuilder.build();
    }

    @Override
    public String webContext() {
        return this.webContext;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    @Override
    public CrossOriginConfig crossOriginConfig() {
        return this.crossOriginConfig;
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    static class Builder
    implements RestServiceSettings.Builder {
        private String webContext;
        private String routing;
        private boolean enabled = true;
        private CrossOriginConfig.Builder crossOriginConfigBuilder = CrossOriginConfig.builder();

        Builder() {
        }

        static Builder create() {
            return new Builder();
        }

        @Override
        public RestServiceSettings.Builder webContext(String webContext) {
            this.webContext = webContext;
            return this;
        }

        @Override
        public RestServiceSettings.Builder routing(String routing) {
            this.routing = routing;
            return this;
        }

        @Override
        public RestServiceSettings.Builder crossOriginConfig(CrossOriginConfig.Builder crossOriginConfigBuilder) {
            this.crossOriginConfigBuilder = crossOriginConfigBuilder;
            return this;
        }

        @Override
        public RestServiceSettings.Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public RestServiceSettings.Builder crossOriginConfig(CrossOriginConfig crossOriginConfig) {
            this.crossOriginConfigBuilder = CrossOriginConfig.builder((CrossOriginConfig)crossOriginConfig);
            return this;
        }

        @Override
        public RestServiceSettings.Builder config(Config serviceConfig) {
            serviceConfig.get("web-context").asString().ifPresent(this::webContext);
            serviceConfig.get("routing").asString().ifPresent(this::routing);
            serviceConfig.get("enabled").asBoolean().ifPresent(this::enabled);
            return this;
        }

        @Override
        public RestServiceSettings build() {
            return new RestServiceSettingsImpl(this);
        }
    }
}

