/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone.clients;

import io.pinecone.clients.Pinecone;
import io.pinecone.configs.PineconeConfig;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import okhttp3.OkHttpClient;
import org.openapitools.inference.client.ApiClient;
import org.openapitools.inference.client.ApiException;
import org.openapitools.inference.client.api.InferenceApi;
import org.openapitools.inference.client.model.EmbedRequest;
import org.openapitools.inference.client.model.EmbedRequestInputsInner;
import org.openapitools.inference.client.model.EmbedRequestParameters;
import org.openapitools.inference.client.model.EmbeddingsList;
import org.openapitools.inference.client.model.RerankRequest;
import org.openapitools.inference.client.model.RerankResult;

public class Inference {
    private final InferenceApi inferenceApi;

    public Inference(PineconeConfig config) {
        OkHttpClient customOkHttpClient = config.getCustomOkHttpClient();
        ApiClient apiClient = customOkHttpClient != null ? new ApiClient(customOkHttpClient) : new ApiClient(Pinecone.buildOkHttpClient(config.getProxyConfig()));
        apiClient.setApiKey(config.getApiKey());
        apiClient.setUserAgent(config.getUserAgent());
        apiClient.addDefaultHeader("X-Pinecone-Api-Version", "2024-10");
        this.inferenceApi = new InferenceApi(apiClient);
    }

    public EmbeddingsList embed(String model, Map<String, Object> parameters, List<String> inputs) throws ApiException {
        EmbedRequestParameters embedRequestParameters = new EmbedRequestParameters();
        parameters.forEach(embedRequestParameters::putAdditionalProperty);
        EmbedRequest embedRequest = new EmbedRequest().model(model).parameters(embedRequestParameters).inputs(this.convertToEmbedInputs(inputs));
        return this.inferenceApi.embed(embedRequest);
    }

    public RerankResult rerank(String model, String query, List<Map<String, String>> documents) throws ApiException {
        return this.rerank(model, query, documents, Arrays.asList("text"), documents.size(), true, new HashMap<String, String>());
    }

    public RerankResult rerank(String model, String query, List<Map<String, String>> documents, List<String> rankFields, int topN, boolean returnDocuments, Map<String, String> parameters) throws ApiException {
        RerankRequest rerankRequest = new RerankRequest();
        rerankRequest.model(model).query(query).documents(documents).rankFields(rankFields).topN(topN).returnDocuments(returnDocuments).parameters(parameters);
        return this.inferenceApi.rerank(rerankRequest);
    }

    private List<EmbedRequestInputsInner> convertToEmbedInputs(List<String> inputs) {
        return inputs.stream().map(input -> new EmbedRequestInputsInner().text((String)input)).collect(Collectors.toList());
    }
}

