/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.launcher;

import io.quarkus.launcher.RuntimeLaunchClassLoader;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class JBangIntegration {
    public static final String CONFIG = "//Q:CONFIG";

    public static Map<String, Object> postBuild(Path appClasses, Path pomFile, List<Map.Entry<String, String>> repositories, List<Map.Entry<String, Path>> originalDeps, List<String> comments, boolean nativeImage) throws IOException {
        if (Boolean.getBoolean("quarkus.dev")) {
            System.clearProperty("quarkus.dev");
            HashMap<String, byte[]> files = new HashMap<String, byte[]>();
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            String string = String.join((CharSequence)"\n", Files.readAllLines(pomFile));
            dataOutputStream.writeUTF(string);
            dataOutputStream.writeUTF(System.getProperty("jbang.source"));
            dataOutputStream.writeInt(originalDeps.size());
            for (Map.Entry<String, Path> i : originalDeps) {
                dataOutputStream.writeUTF(i.getKey());
                dataOutputStream.writeUTF(i.getValue().toAbsolutePath().toString());
            }
            dataOutputStream.close();
            files.put("jbang-dev.dat", outputStream.toByteArray());
            HashMap<String, Object> ret = new HashMap<String, Object>();
            ret.put("files", files);
            ret.put("main-class", "io.quarkus.launcher.JBangDevModeLauncher");
            return ret;
        }
        Properties configurationProperties = new Properties();
        for (String string : comments) {
            if (!string.startsWith(CONFIG)) continue;
            String string2 = string.substring(CONFIG.length()).trim();
            int equals = string2.indexOf("=");
            if (equals == -1) {
                throw new RuntimeException("invalid config  " + string);
            }
            configurationProperties.setProperty(string2.substring(0, equals), string2.substring(equals + 1));
        }
        ArrayList<Map.Entry<String, Path>> dependencies = new ArrayList<Map.Entry<String, Path>>();
        for (Map.Entry<String, Path> entry : originalDeps) {
            if (entry.getKey().startsWith("org.ow2.asm:asm:")) continue;
            dependencies.add(entry);
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            RuntimeLaunchClassLoader runtimeLaunchClassLoader = new RuntimeLaunchClassLoader(new ClassLoader(JBangIntegration.class.getClassLoader()){

                @Override
                public Class<?> loadClass(String name) throws ClassNotFoundException {
                    return this.loadClass(name, false);
                }

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (name.startsWith("org.") && !name.startsWith("org.xml.") && !name.startsWith("org.w3c.") && !name.startsWith("org.jboss.")) {
                        throw new ClassNotFoundException();
                    }
                    return super.loadClass(name, resolve);
                }

                @Override
                public URL getResource(String name) {
                    if (name.startsWith("org/") && !name.startsWith("org/xml/") && !name.startsWith("org/w3c/") && !name.startsWith("org/jboss/")) {
                        return null;
                    }
                    return super.getResource(name);
                }

                @Override
                public Enumeration<URL> getResources(String name) throws IOException {
                    if (name.startsWith("org/") && !name.startsWith("org/xml/") && !name.startsWith("org/w3c/") && !name.startsWith("org/jboss/")) {
                        return Collections.emptyEnumeration();
                    }
                    return super.getResources(name);
                }
            });
            Thread.currentThread().setContextClassLoader(runtimeLaunchClassLoader);
            Class<?> launcher = runtimeLaunchClassLoader.loadClass("io.quarkus.bootstrap.jbang.JBangBuilderImpl");
            Map map = (Map)launcher.getDeclaredMethod("postBuild", Path.class, Path.class, List.class, List.class, Properties.class, Boolean.TYPE).invoke(null, appClasses, pomFile, repositories, dependencies, configurationProperties, nativeImage);
            return map;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            System.clearProperty("quarkus-internal.serialized-app-model.path");
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }
}

