/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SqlConnectionBase;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;

public interface Driver {
    default public Pool createPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options) {
        Pool pool;
        VertxInternal vx;
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use Pool#pool(Vertx, SqlConnectOptions, PoolOptions) instead");
            }
            VertxOptions vertxOptions = new VertxOptions();
            SqlConnectOptions database = databases.get(0);
            if (database.isUsingDomainSocket()) {
                vertxOptions.setPreferNativeTransport(true);
            }
            vx = (VertxInternal)Vertx.vertx((VertxOptions)vertxOptions);
        } else {
            vx = (VertxInternal)vertx;
        }
        CloseFuture closeFuture = new CloseFuture();
        try {
            pool = this.newPool((Vertx)vx, databases, options, closeFuture);
        }
        catch (Exception e) {
            if (vertx == null) {
                vx.close();
            }
            throw e;
        }
        vx.addCloseHook((Closeable)closeFuture);
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    public Pool newPool(Vertx var1, List<? extends SqlConnectOptions> var2, PoolOptions var3, CloseFuture var4);

    public ConnectionFactory createConnectionFactory(Vertx var1, SqlConnectOptions var2);

    public SqlConnectOptions parseConnectionUri(String var1);

    public boolean acceptsOptions(SqlConnectOptions var1);

    default public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append("?");
        return current;
    }

    default public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        return new SqlConnectionBase(context, factory, conn, this, tracer, metrics);
    }
}

