/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.base;

import io.weaviate.client.Config;
import io.weaviate.client.base.Response;
import io.weaviate.client.base.Serializer;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.base.http.HttpClient;
import io.weaviate.client.base.http.HttpResponse;
import java.util.Collections;

public abstract class BaseClient<T> {
    private final HttpClient client;
    protected final Config config;
    protected final Serializer serializer;

    public BaseClient(HttpClient client, Config config) {
        this.config = config;
        this.client = client;
        this.serializer = new Serializer();
    }

    protected Response<T> sendGetRequest(String endpoint, Class<T> classOfT) {
        return this.sendRequest(endpoint, null, "GET", classOfT);
    }

    protected Response<T> sendPostRequest(String endpoint, Object payload, Class<T> classOfT) {
        return this.sendRequest(endpoint, payload, "POST", classOfT);
    }

    protected Response<T> sendPutRequest(String endpoint, Object payload, Class<T> classOfT) {
        return this.sendRequest(endpoint, payload, "PUT", classOfT);
    }

    protected Response<T> sendPatchRequest(String endpoint, Object payload, Class<T> classOfT) {
        return this.sendRequest(endpoint, payload, "PATCH", classOfT);
    }

    protected Response<T> sendDeleteRequest(String endpoint, Object payload, Class<T> classOfT) {
        return this.sendRequest(endpoint, payload, "DELETE", classOfT);
    }

    protected Response<T> sendHeadRequest(String endpoint, Class<T> classOfT) {
        return this.sendRequest(endpoint, null, "HEAD", classOfT);
    }

    private Response<T> sendRequest(String endpoint, Object payload, String method, Class<T> classOfT) {
        try {
            HttpResponse response = this.sendHttpRequest(endpoint, payload, method);
            int statusCode = response.getStatusCode();
            String responseBody = response.getBody();
            if (statusCode < 399) {
                return new Response<T>(statusCode, this.toResponse(responseBody, classOfT), null);
            }
            return new Response<Object>(statusCode, null, this.toResponse(responseBody, WeaviateErrorResponse.class));
        }
        catch (Exception e) {
            WeaviateErrorResponse errors = this.getWeaviateErrorResponse(e);
            return new Response<Object>(0, null, errors);
        }
    }

    protected HttpResponse sendHttpRequest(String endpoint, Object payload, String method) throws Exception {
        String address = this.config.getBaseURL() + endpoint;
        String json = this.toJsonString(payload);
        if (method.equals("POST")) {
            return this.client.sendPostRequest(address, json);
        }
        if (method.equals("PUT")) {
            return this.client.sendPutRequest(address, json);
        }
        if (method.equals("PATCH")) {
            return this.client.sendPatchRequest(address, json);
        }
        if (method.equals("DELETE")) {
            return this.client.sendDeleteRequest(address, json);
        }
        if (method.equals("HEAD")) {
            return this.client.sendHeadRequest(address);
        }
        return this.client.sendGetRequest(address);
    }

    protected <C> C toResponse(String response, Class<C> classOfT) {
        return this.serializer.toResponse(response, classOfT);
    }

    private String toJsonString(Object object) {
        return this.serializer.toJsonString(object);
    }

    protected WeaviateErrorResponse getWeaviateErrorResponse(Exception e) {
        WeaviateErrorMessage error = WeaviateErrorMessage.builder().message(e.getMessage()).throwable(e).build();
        return WeaviateErrorResponse.builder().error(Collections.singletonList(error)).build();
    }
}

