/*
 * Decompiled with CFR 0.152.
 */
package io.weaviate.client.v1.schema.api;

import io.weaviate.client.base.ClientResult;
import io.weaviate.client.base.Result;
import io.weaviate.client.base.WeaviateError;
import io.weaviate.client.base.WeaviateErrorMessage;
import io.weaviate.client.base.WeaviateErrorResponse;
import io.weaviate.client.v1.schema.api.ClassGetter;
import io.weaviate.client.v1.schema.model.WeaviateClass;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;

public class ClassExists
implements ClientResult<Boolean> {
    private final ClassGetter classGetter;
    private String className;

    public ClassExists(ClassGetter classGetter) {
        this.classGetter = classGetter;
    }

    public ClassExists withClassName(String className) {
        this.className = className;
        return this;
    }

    @Override
    public Result<Boolean> run() {
        if (StringUtils.isEmpty((CharSequence)this.className)) {
            WeaviateErrorMessage errorMessage = WeaviateErrorMessage.builder().message("classname cannot be empty").build();
            WeaviateErrorResponse errors = WeaviateErrorResponse.builder().error(Collections.singletonList(errorMessage)).build();
            return new Result<Object>(422, null, errors);
        }
        Result<WeaviateClass> getterClass = this.classGetter.withClassName(this.className).run();
        if (getterClass.hasErrors()) {
            WeaviateError error = getterClass.getError();
            return new Result<Object>(error.getStatusCode(), null, WeaviateErrorResponse.builder().error(error.getMessages()).build());
        }
        return new Result<Boolean>(200, getterClass.getResult() != null, null);
    }
}

