/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import com.alibaba.fastjson.JSONObject;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthHuaweiRequest
extends AuthDefaultRequest {
    public AuthHuaweiRequest(AuthConfig config) {
        super(config, AuthDefaultSource.HUAWEI);
    }

    public AuthHuaweiRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.HUAWEI, authStateCache);
    }

    @Override
    protected AuthToken getAccessToken(AuthCallback authCallback) {
        HttpRequest request = HttpRequest.post((String)this.source.accessToken()).form("grant_type", (Object)"authorization_code").form("code", (Object)authCallback.getAuthorization_code()).form("client_id", (Object)this.config.getClientId()).form("client_secret", (Object)this.config.getClientSecret()).form("redirect_uri", (Object)this.config.getRedirectUri());
        return this.getAuthToken(request);
    }

    @Override
    protected AuthUser getUserInfo(AuthToken authToken) {
        HttpResponse response = HttpRequest.post((String)this.source.userInfo()).form("nsp_ts", (Object)System.currentTimeMillis()).form("access_token", (Object)authToken.getAccessToken()).form("nsp_fmt", (Object)"JS").form("nsp_svc", (Object)"OpenUP.User.getInfo").execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        AuthUserGender gender = this.getRealGender(object);
        return AuthUser.builder().uuid(object.getString("userID")).username(object.getString("userName")).nickname(object.getString("userName")).gender(gender).avatar(object.getString("headPictureURL")).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse refresh(AuthToken authToken) {
        HttpRequest request = HttpRequest.post((String)this.source.refresh()).form("client_id", (Object)this.config.getClientId()).form("client_secret", (Object)this.config.getClientSecret()).form("refresh_token", (Object)authToken.getRefreshToken()).form("grant_type", (Object)"refresh_token");
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(request)).build();
    }

    private AuthToken getAuthToken(HttpRequest request) {
        HttpResponse response = request.execute();
        JSONObject object = JSONObject.parseObject((String)response.body());
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("access_type", "offline").queryParam("scope", "https%3A%2F%2Fwww.huawei.com%2Fauth%2Faccount%2Fbase.profile").queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("grant_type", "authorization_code").queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("nsp_ts", System.currentTimeMillis()).queryParam("access_token", authToken.getAccessToken()).queryParam("nsp_fmt", "JS").queryParam("nsp_svc", "OpenUP.User.getInfo").build();
    }

    private AuthUserGender getRealGender(JSONObject object) {
        int genderCodeInt = object.getIntValue("gender");
        String genderCode = genderCodeInt == 1 ? "0" : (genderCodeInt == 0 ? "1" : genderCodeInt + "");
        return AuthUserGender.getRealGender(genderCode);
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"NSP_STATUS")) {
            throw new AuthException(object.getString("error"));
        }
        if (object.containsKey((Object)"error")) {
            throw new AuthException(object.getString("sub_error") + ":" + object.getString("error_description"));
        }
    }
}

