/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.mrbean;

import org.codehaus.jackson.Version;
import org.codehaus.jackson.Versioned;
import org.codehaus.jackson.map.AbstractTypeResolver;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.mrbean.BeanBuilder;
import org.codehaus.jackson.type.JavaType;
import org.codehaus.jackson.util.VersionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTypeMaterializer
extends AbstractTypeResolver
implements Versioned {
    protected static final int DEFAULT_FEATURE_FLAGS = Feature.collectDefaults();
    public static final String DEFAULT_PACKAGE_FOR_GENERATED = "org.codehaus.jackson.generated.";
    protected final MyClassLoader _classLoader;
    protected int _featureFlags = DEFAULT_FEATURE_FLAGS;
    protected String _defaultPackage = "org.codehaus.jackson.generated.";

    public AbstractTypeMaterializer() {
        this(null);
    }

    public AbstractTypeMaterializer(ClassLoader parentClassLoader) {
        if (parentClassLoader == null) {
            parentClassLoader = this.getClass().getClassLoader();
        }
        this._classLoader = new MyClassLoader(parentClassLoader);
    }

    @Override
    public Version version() {
        return VersionUtil.versionFor(this.getClass());
    }

    public final boolean isEnabled(Feature f) {
        return (this._featureFlags & f.getMask()) != 0;
    }

    public void enable(Feature f) {
        this._featureFlags |= f.getMask();
    }

    public void disable(Feature f) {
        this._featureFlags &= ~f.getMask();
    }

    public void set(Feature f, boolean state) {
        if (state) {
            this.enable(f);
        } else {
            this.disable(f);
        }
    }

    public void setDefaultPackage(String defPkg) {
        if (!defPkg.endsWith(".")) {
            defPkg = defPkg + ".";
        }
        this._defaultPackage = defPkg;
    }

    @Override
    public JavaType resolveAbstractType(DeserializationConfig config, JavaType type) {
        if (type.isContainerType() || type.isPrimitive() || type.isEnumType() || type.isThrowable()) {
            return null;
        }
        return config.constructType(this.materializeClass(config, type.getRawClass()));
    }

    protected Class<?> materializeClass(DeserializationConfig config, Class<?> cls) {
        String newName = this._defaultPackage + cls.getName();
        BeanBuilder builder = new BeanBuilder(config, cls);
        byte[] bytecode = builder.implement(this.isEnabled(Feature.FAIL_ON_UNMATERIALIZED_METHOD)).build(newName);
        Class<?> result = this._classLoader.loadAndResolve(newName, bytecode, cls);
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyClassLoader
    extends ClassLoader {
        public MyClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class<?> loadAndResolve(String className, byte[] byteCode, Class<?> targetClass) throws IllegalArgumentException {
            Class<?> impl;
            Class<?> old = this.findLoadedClass(className);
            if (old != null && targetClass.isAssignableFrom(old)) {
                return old;
            }
            try {
                impl = this.defineClass(className, byteCode, 0, byteCode.length);
            }
            catch (LinkageError e) {
                throw new IllegalArgumentException("Failed to load class '" + className + "': " + e.getMessage(), e);
            }
            this.resolveClass(impl);
            return impl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Feature {
        FAIL_ON_UNMATERIALIZED_METHOD(false);

        final boolean _defaultState;

        protected static int collectDefaults() {
            int flags = 0;
            for (Feature f : Feature.values()) {
                if (!f.enabledByDefault()) continue;
                flags |= f.getMask();
            }
            return flags;
        }

        private Feature(boolean defaultState) {
            this._defaultState = defaultState;
        }

        public boolean enabledByDefault() {
            return this._defaultState;
        }

        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

