/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.calculate;

import java.util.HashSet;
import java.util.Set;
import nl.basjes.parse.useragent.AgentField;
import nl.basjes.parse.useragent.UserAgent;
import nl.basjes.parse.useragent.calculate.FieldCalculator;
import nl.basjes.parse.useragent.utils.HostnameExtracter;
import nl.basjes.parse.useragent.utils.Normalize;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixMatcherLoader;

public class CalculateDeviceBrand
implements FieldCalculator {
    private final Set<String> unwantedUrlBrands = new HashSet<String>();
    private final Set<String> unwantedEmailBrands;

    public CalculateDeviceBrand() {
        this.unwantedUrlBrands.add("Localhost");
        this.unwantedUrlBrands.add("Github");
        this.unwantedUrlBrands.add("Gitlab");
        this.unwantedEmailBrands = new HashSet<String>();
        this.unwantedEmailBrands.add("Localhost");
        this.unwantedEmailBrands.add("Gmail");
        this.unwantedEmailBrands.add("Outlook");
    }

    @Override
    public void calculate(UserAgent.MutableUserAgent userAgent) {
        AgentField deviceBrand = userAgent.get("DeviceBrand");
        if (deviceBrand.isDefaultValue()) {
            String newDeviceBrand = this.determineDeviceBrand(userAgent);
            if (newDeviceBrand != null) {
                userAgent.setForced("DeviceBrand", newDeviceBrand, 0L);
            } else {
                userAgent.setForced("DeviceBrand", "<<<null>>>", 0L);
            }
        } else {
            userAgent.setForced("DeviceBrand", Normalize.brand(deviceBrand.getValue()), deviceBrand.getConfidence());
        }
    }

    private String determineDeviceBrand(UserAgent userAgent) {
        String deviceBrand = null;
        AgentField informationUrl = userAgent.get("AgentInformationUrl");
        if (!informationUrl.isDefaultValue()) {
            String hostname = HostnameExtracter.extractHostname(informationUrl.getValue());
            deviceBrand = this.extractCompanyFromHostName(hostname, this.unwantedUrlBrands);
        }
        if (deviceBrand != null) {
            return deviceBrand;
        }
        AgentField informationEmail = userAgent.get("AgentInformationEmail");
        if (!informationEmail.isDefaultValue()) {
            String hostname = informationEmail.getValue();
            int atOffset = hostname.indexOf(64);
            if (atOffset >= 0) {
                hostname = hostname.substring(atOffset + 1);
            }
            deviceBrand = this.extractCompanyFromHostName(hostname, this.unwantedEmailBrands);
        }
        return deviceBrand;
    }

    private String extractCompanyFromHostName(String hostname, Set<String> blackList) {
        String root = PublicSuffixMatcherLoader.getDefault().getDomainRoot(hostname, DomainType.ICANN);
        if (root == null) {
            return null;
        }
        String brand = Normalize.brand(root.split("\\.", 2)[0]);
        if (blackList.contains(brand)) {
            return null;
        }
        return brand;
    }

    @Override
    public String[] getDependencies() {
        return new String[]{"AgentInformationUrl", "AgentInformationEmail"};
    }

    public String toString() {
        return "Calculate DeviceBrand";
    }
}

