/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.workflow.simple.definition.form;

import java.util.ArrayList;
import java.util.List;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinition;
import org.activiti.workflow.simple.definition.form.FormPropertyDefinitionContainer;
import org.activiti.workflow.simple.exception.SimpleWorkflowException;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonSerialize;

public class FormPropertyGroup
implements FormPropertyDefinitionContainer {
    protected String title;
    protected String id;
    protected String type;
    protected List<FormPropertyDefinition> formPropertyDefinitions = new ArrayList<FormPropertyDefinition>();

    public FormPropertyGroup() {
    }

    public FormPropertyGroup(String id, String type, String title) {
        this.id = id;
        this.type = type;
        this.title = title;
    }

    @Override
    @JsonSerialize(contentAs=FormPropertyDefinition.class)
    @JsonProperty(value="formProperties")
    public List<FormPropertyDefinition> getFormPropertyDefinitions() {
        return this.formPropertyDefinitions;
    }

    @Override
    public void addFormProperty(FormPropertyDefinition definition) {
        this.formPropertyDefinitions.add(definition);
    }

    @Override
    public boolean removeFormProperty(FormPropertyDefinition definition) {
        return this.formPropertyDefinitions.remove(definition);
    }

    public void setFormPropertyDefinitions(List<FormPropertyDefinition> formPropertyDefinitions) {
        this.formPropertyDefinitions = formPropertyDefinitions;
    }

    public FormPropertyGroup addFormPropertyDefinition(FormPropertyDefinition definition) {
        if (definition == null) {
            throw new SimpleWorkflowException("Definition to add cannot be null");
        }
        this.formPropertyDefinitions.add(definition);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitle() {
        return this.title;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public FormPropertyGroup clone() {
        FormPropertyGroup clone = new FormPropertyGroup();
        clone.setValues(this);
        return clone;
    }

    public void setValues(FormPropertyGroup otherGroup) {
        if (!(otherGroup instanceof FormPropertyGroup)) {
            throw new SimpleWorkflowException("An instance of FormPropertyGroup is required to set values");
        }
        FormPropertyGroup formGroup = otherGroup;
        this.setId(formGroup.getId());
        this.setTitle(formGroup.getTitle());
        this.setType(formGroup.getType());
        ArrayList<FormPropertyDefinition> definitionList = new ArrayList<FormPropertyDefinition>();
        if (formGroup.getFormPropertyDefinitions() != null && formGroup.getFormPropertyDefinitions().size() > 0) {
            for (FormPropertyDefinition propertyDefinition : formGroup.getFormPropertyDefinitions()) {
                definitionList.add(propertyDefinition.clone());
            }
        }
        this.setFormPropertyDefinitions(definitionList);
    }
}

